/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.Transport;
import org.jgroups.View;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.blocks.RspCollector;
import org.jgroups.util.Command;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupRequest
implements RspCollector,
Command {
    public static final int GET_FIRST = 1;
    public static final int GET_ALL = 2;
    public static final int GET_MAJORITY = 3;
    public static final int GET_ABS_MAJORITY = 4;
    public static final int GET_N = 5;
    public static final int GET_NONE = 6;
    private Address caller;
    private final Map<Address, Rsp> requests = new HashMap<Address, Rsp>();
    private final Vector<Address> suspects = new Vector();
    private final Collection<Address> members = new TreeSet<Address>();
    private static final int max_suspects = 40;
    protected Message request_msg;
    protected RequestCorrelator corr;
    protected Transport transport;
    protected int rsp_mode = 2;
    protected boolean done = false;
    protected long timeout = 0L;
    protected int expected_mbrs = 0;
    private static final Log log = LogFactory.getLog(GroupRequest.class);
    private static long last_req_id = 1L;
    private long req_id = -1L;

    public GroupRequest(Message m, RequestCorrelator corr, Vector<Address> members, int rsp_mode) {
        this.request_msg = m;
        this.corr = corr;
        this.rsp_mode = rsp_mode;
        this.reset(members);
    }

    public GroupRequest(Message m, RequestCorrelator corr, Vector<Address> members, int rsp_mode, long timeout, int expected_mbrs) {
        this(m, corr, members, rsp_mode);
        if (timeout > 0L) {
            this.timeout = timeout;
        }
        this.expected_mbrs = expected_mbrs;
    }

    public GroupRequest(Message m, Transport transport, Vector<Address> members, int rsp_mode) {
        this.request_msg = m;
        this.transport = transport;
        this.rsp_mode = rsp_mode;
        this.reset(members);
    }

    public GroupRequest(Message m, Transport transport, Vector<Address> members, int rsp_mode, long timeout, int expected_mbrs) {
        this(m, transport, members, rsp_mode);
        if (timeout > 0L) {
            this.timeout = timeout;
        }
        this.expected_mbrs = expected_mbrs;
    }

    public Address getCaller() {
        return this.caller;
    }

    public void setCaller(Address caller) {
        this.caller = caller;
    }

    @Override
    public boolean execute() throws Exception {
        return this.execute(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(boolean use_anycasting) throws Exception {
        if (this.corr == null && this.transport == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)"both corr and transport are null, cannot send group request");
            }
            return false;
        }
        try {
            this.done = false;
            boolean retval = this.doExecute(use_anycasting, this.timeout);
            if (!retval && log.isTraceEnabled()) {
                log.trace((Object)("call did not execute correctly, request is " + this.toString()));
            }
            boolean bl = retval;
            return bl;
        }
        finally {
            this.done = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset(Vector<Address> mbrs) {
        if (mbrs != null) {
            Object object = this.requests;
            synchronized (object) {
                this.requests.clear();
                for (Address mbr : mbrs) {
                    this.requests.put(mbr, new Rsp(mbr));
                }
            }
            object = this.members;
            synchronized (object) {
                this.members.clear();
                this.members.addAll(mbrs);
            }
        }
        Map<Address, Rsp> map = this.requests;
        synchronized (map) {
            for (Rsp rsp : this.requests.values()) {
                rsp.setReceived(false);
                rsp.setValue(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveResponse(Object response_value, Address sender) {
        if (this.done) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"command is done; cannot add response !");
            }
            return;
        }
        if (this.suspects.contains(sender)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("received response from suspected member " + sender + "; discarding"));
            }
            return;
        }
        Map<Address, Rsp> map = this.requests;
        synchronized (map) {
            Rsp rsp = this.requests.get(sender);
            if (rsp != null && !rsp.wasReceived()) {
                rsp.setValue(response_value);
                rsp.setReceived(true);
                if (log.isTraceEnabled()) {
                    log.trace((Object)new StringBuffer("received response for request ").append(this.req_id).append(", sender=").append(sender).append(", val=").append(response_value));
                }
                this.requests.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspect(Address suspected_member) {
        if (suspected_member == null) {
            return;
        }
        this.addSuspect(suspected_member);
        Map<Address, Rsp> map = this.requests;
        synchronized (map) {
            Rsp rsp = this.requests.get(suspected_member);
            if (rsp != null) {
                rsp.setSuspected(true);
                rsp.setValue(null);
                this.requests.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void viewChange(View new_view) {
        Vector<Address> mbrs;
        Vector<Address> vector = mbrs = new_view != null ? new_view.getMembers() : null;
        if (this.requests == null || this.requests.isEmpty() || mbrs == null) {
            return;
        }
        Collection<Address> collection = this.members;
        synchronized (collection) {
            this.members.clear();
            this.members.addAll(mbrs);
        }
        boolean modified = false;
        HashSet<Address> tmp = null;
        Map<Address, Rsp> map = this.requests;
        synchronized (map) {
            for (Map.Entry<Address, Rsp> entry : this.requests.entrySet()) {
                Address mbr = entry.getKey();
                if (mbrs.contains(mbr)) continue;
                if (tmp == null) {
                    tmp = new HashSet<Address>();
                }
                tmp.add(mbr);
                Rsp rsp = entry.getValue();
                rsp.setValue(null);
                rsp.setSuspected(true);
                modified = true;
            }
        }
        if (modified || tmp != null) {
            map = this.requests;
            synchronized (map) {
                for (Address suspect : tmp) {
                    this.addSuspect(suspect);
                }
                this.requests.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RspList getResults() {
        Map<Address, Rsp> map = this.requests;
        synchronized (map) {
            Collection<Rsp> rsps = this.requests.values();
            return new RspList(rsps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder ret = new StringBuilder(128);
        ret.append("[req_id=").append(this.req_id).append('\n');
        if (this.caller != null) {
            ret.append("caller=").append(this.caller).append("\n");
        }
        Map<Address, Rsp> map = this.requests;
        synchronized (map) {
            for (Map.Entry<Address, Rsp> entry : this.requests.entrySet()) {
                Address mbr = entry.getKey();
                Rsp rsp = entry.getValue();
                ret.append(mbr).append(": ").append(rsp).append("\n");
            }
        }
        if (!this.suspects.isEmpty()) {
            ret.append("\nsuspects: ").append(this.suspects);
        }
        ret.append("\nrequest_msg: ").append(this.request_msg);
        ret.append("\nrsp_mode: ").append(GroupRequest.modeToString(this.rsp_mode));
        ret.append("\ndone: ").append(this.done);
        ret.append("\ntimeout: ").append(this.timeout);
        ret.append("\nexpected_mbrs: ").append(this.expected_mbrs).append(" (" + this.members + ")]");
        return ret.toString();
    }

    public int getNumSuspects() {
        return this.suspects.size();
    }

    public Vector getSuspects() {
        return this.suspects;
    }

    public boolean isDone() {
        return this.done;
    }

    private static int determineMajority(int i) {
        return i < 2 ? i : i / 2 + 1;
    }

    private static synchronized long getRequestId() {
        long result = System.currentTimeMillis();
        if (result <= last_req_id) {
            result = last_req_id + 1L;
        }
        last_req_id = result;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doExecute(boolean use_anycasting, long timeout) throws Exception {
        long start_time = 0L;
        this.req_id = GroupRequest.getRequestId();
        this.reset(null);
        Map<Address, Rsp> map = this.requests;
        synchronized (map) {
            for (Address suspect : this.suspects) {
                Rsp rsp = this.requests.get(suspect);
                if (rsp == null) continue;
                rsp.setSuspected(true);
                break;
            }
        }
        try {
            AbstractList tmp;
            if (log.isTraceEnabled()) {
                log.trace((Object)new StringBuffer("sending request (id=").append(this.req_id).append(')'));
            }
            if (this.corr != null) {
                tmp = new Vector<Address>(this.members);
                this.corr.sendRequest(this.req_id, tmp, this.request_msg, this.rsp_mode == 6 ? null : this, use_anycasting);
            } else if (use_anycasting) {
                tmp = new ArrayList<Address>(this.members);
                for (Address mbr : tmp) {
                    Message copy = this.request_msg.copy(true);
                    copy.setDest(mbr);
                    this.transport.send(copy);
                }
            } else {
                this.transport.send(this.request_msg);
            }
        }
        catch (Exception ex) {
            if (this.corr != null) {
                this.corr.done(this.req_id);
            }
            throw ex;
        }
        map = this.requests;
        synchronized (map) {
            if (timeout <= 0L) {
                while (true) {
                    this.adjustMembership();
                    if (this.responsesComplete()) {
                        if (this.corr != null) {
                            this.corr.done(this.req_id);
                        }
                        if (log.isTraceEnabled() && this.rsp_mode != 6) {
                            log.trace((Object)("received all responses: " + this.toString()));
                        }
                        return true;
                    }
                    try {
                        this.requests.wait();
                    }
                    catch (Exception e) {}
                }
            }
            start_time = System.currentTimeMillis();
            long timeout_time = start_time + timeout;
            while (timeout > 0L) {
                if (this.responsesComplete()) {
                    if (this.corr != null) {
                        this.corr.done(this.req_id);
                    }
                    if (log.isTraceEnabled() && this.rsp_mode != 6) {
                        log.trace((Object)("received all responses: " + this.toString()));
                    }
                    return true;
                }
                timeout = timeout_time - System.currentTimeMillis();
                if (timeout <= 0L) continue;
                try {
                    this.requests.wait(timeout);
                }
                catch (Exception e) {}
            }
            if (this.corr != null) {
                this.corr.done(this.req_id);
            }
            return false;
        }
    }

    private boolean responsesComplete() {
        int num_received = 0;
        int num_not_received = 0;
        int num_suspected = 0;
        int num_total = this.requests.size();
        for (Rsp rsp : this.requests.values()) {
            if (rsp.wasReceived()) {
                ++num_received;
                continue;
            }
            if (rsp.wasSuspected()) {
                ++num_suspected;
                continue;
            }
            ++num_not_received;
        }
        switch (this.rsp_mode) {
            case 1: {
                if (num_received > 0) {
                    return true;
                }
                if (num_suspected < num_total) break;
                return true;
            }
            case 2: {
                return num_received + num_suspected >= num_total;
            }
            case 3: {
                int majority = GroupRequest.determineMajority(num_total);
                if (num_received + num_suspected < majority) break;
                return true;
            }
            case 4: {
                int majority = GroupRequest.determineMajority(num_total);
                if (num_received < majority) break;
                return true;
            }
            case 5: {
                if (this.expected_mbrs >= num_total) {
                    this.rsp_mode = 2;
                    return this.responsesComplete();
                }
                return num_received >= this.expected_mbrs || num_received + num_not_received < this.expected_mbrs && num_received + num_suspected >= this.expected_mbrs;
            }
            case 6: {
                return true;
            }
            default: {
                if (!log.isErrorEnabled()) break;
                log.error((Object)("rsp_mode " + this.rsp_mode + " unknown !"));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustMembership() {
        if (this.requests.isEmpty()) {
            return;
        }
        Collection<Address> collection = this.members;
        synchronized (collection) {
            for (Map.Entry<Address, Rsp> entry : this.requests.entrySet()) {
                Address mbr = entry.getKey();
                if (this.members.contains(mbr) && !this.suspects.contains(mbr)) continue;
                this.addSuspect(mbr);
                Rsp rsp = entry.getValue();
                rsp.setValue(null);
                rsp.setSuspected(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSuspect(Address suspected_mbr) {
        Vector<Address> vector = this.suspects;
        synchronized (vector) {
            if (!this.suspects.contains(suspected_mbr)) {
                this.suspects.addElement(suspected_mbr);
                while (this.suspects.size() >= 40 && !this.suspects.isEmpty()) {
                    this.suspects.remove(0);
                }
            }
        }
    }

    private static String modeToString(int m) {
        switch (m) {
            case 1: {
                return "GET_FIRST";
            }
            case 2: {
                return "GET_ALL";
            }
            case 3: {
                return "GET_MAJORITY";
            }
            case 4: {
                return "GET_ABS_MAJORITY";
            }
            case 5: {
                return "GET_N";
            }
            case 6: {
                return "GET_NONE";
            }
        }
        return "<unknown> (" + m + ")";
    }
}

