/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.Protocol;
import org.jgroups.util.BoundedList;
import org.jgroups.util.Streamable;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class FD_ALL
extends Protocol {
    Map<Address, Long> timestamps = new ConcurrentHashMap<Address, Long>();
    long interval = 3000L;
    long timeout = 5000L;
    boolean msg_counts_as_heartbeat = true;
    Address local_addr = null;
    final List members = new ArrayList();
    boolean shun = true;
    TimeScheduler timer = null;
    private ScheduledFuture heartbeat_sender_future = null;
    private ScheduledFuture timeout_checker_future = null;
    private boolean tasks_running = false;
    protected int num_heartbeats_sent;
    protected int num_heartbeats_received = 0;
    protected int num_suspect_events = 0;
    static final String name = "FD_ALL";
    BoundedList suspect_history = new BoundedList(20);
    final Map<Address, Integer> invalid_pingers = new HashMap<Address, Integer>(7);
    final Lock lock = new ReentrantLock();

    public String getName() {
        return name;
    }

    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    public String getMembers() {
        return this.members != null ? this.members.toString() : "null";
    }

    public int getHeartbeatsSent() {
        return this.num_heartbeats_sent;
    }

    public int getHeartbeatsReceived() {
        return this.num_heartbeats_received;
    }

    public int getSuspectEventsSent() {
        return this.num_suspect_events;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public boolean isShun() {
        return this.shun;
    }

    public void setShun(boolean flag) {
        this.shun = flag;
    }

    public boolean isRunning() {
        return this.tasks_running;
    }

    public String printSuspectHistory() {
        StringBuilder sb = new StringBuilder();
        Enumeration en = this.suspect_history.elements();
        while (en.hasMoreElements()) {
            sb.append(new Date()).append(": ").append(en.nextElement()).append("\n");
        }
        return sb.toString();
    }

    public String printTimestamps() {
        return this.printTimeStamps();
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if ((str = props.getProperty("interval")) != null) {
            this.interval = Long.parseLong(str);
            props.remove("interval");
        }
        if ((str = props.getProperty("shun")) != null) {
            this.shun = Boolean.valueOf(str);
            props.remove("shun");
        }
        if ((str = props.getProperty("msg_counts_as_heartbeat")) != null) {
            this.msg_counts_as_heartbeat = Boolean.valueOf(str);
            props.remove("msg_counts_as_heartbeat");
        }
        if (!props.isEmpty()) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public void resetStats() {
        this.num_suspect_events = 0;
        this.num_heartbeats_received = 0;
        this.num_heartbeats_sent = 0;
        this.suspect_history.removeAll();
    }

    public void init() throws Exception {
        if (this.stack == null || this.stack.timer == null) {
            throw new Exception("timer cannot be retrieved from protocol stack");
        }
        this.timer = this.stack.timer;
    }

    public void stop() {
        this.stopTasks();
    }

    public Object up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Header hdr = (Header)msg.getHeader(name);
                if (this.msg_counts_as_heartbeat) {
                    this.update(msg.getSrc());
                }
                if (hdr == null) break;
                switch (hdr.type) {
                    case 0: {
                        Address sender = msg.getSrc();
                        if (sender.equals(this.local_addr)) break;
                        if (this.shun && sender != null && this.members != null && !this.members.contains(sender)) {
                            this.shunInvalidHeartbeatSender(sender);
                            break;
                        }
                        this.update(sender);
                        ++this.num_heartbeats_received;
                        break;
                    }
                    case 1: {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("[SUSPECT] suspect hdr is " + hdr));
                        }
                        this.down_prot.down(new Event(9, hdr.suspected_mbr));
                        this.up_prot.up(new Event(9, hdr.suspected_mbr));
                        break;
                    }
                    case 2: {
                        if (!this.shun) break;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)"[NOT_MEMBER] I'm being shunned; exiting");
                        }
                        this.up_prot.up(new Event(46));
                    }
                }
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.down_prot.down(evt);
                View v = (View)evt.getArg();
                this.handleViewChange(v);
                return null;
            }
        }
        return this.down_prot.down(evt);
    }

    private void startTasks() {
        this.startHeartbeatSender();
        this.startTimeoutChecker();
        this.tasks_running = true;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"started heartbeat sender and timeout checker tasks");
        }
    }

    private void stopTasks() {
        this.stopTimeoutChecker();
        this.stopHeartbeatSender();
        this.tasks_running = false;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"stopped heartbeat sender and timeout checker tasks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTimeoutChecker() {
        this.lock.lock();
        try {
            if (this.timeout_checker_future == null || this.timeout_checker_future.isDone()) {
                this.timeout_checker_future = this.timer.scheduleWithFixedDelay(new TimeoutChecker(), this.interval, this.interval, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTimeoutChecker() {
        this.lock.lock();
        try {
            if (this.timeout_checker_future != null) {
                this.timeout_checker_future.cancel(true);
                this.timeout_checker_future = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startHeartbeatSender() {
        this.lock.lock();
        try {
            if (this.heartbeat_sender_future == null || this.heartbeat_sender_future.isDone()) {
                this.heartbeat_sender_future = this.timer.scheduleWithFixedDelay(new HeartbeatSender(), this.interval, this.interval, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopHeartbeatSender() {
        this.lock.lock();
        try {
            if (this.heartbeat_sender_future != null) {
                this.heartbeat_sender_future.cancel(true);
                this.heartbeat_sender_future = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void update(Address sender) {
        if (sender != null && !sender.equals(this.local_addr)) {
            this.timestamps.put(sender, System.currentTimeMillis());
        }
    }

    private void handleViewChange(View v) {
        Vector<Address> mbrs = v.getMembers();
        this.members.clear();
        this.members.addAll(mbrs);
        Set<Address> keys = this.timestamps.keySet();
        keys.retainAll(mbrs);
        for (Address mbr : mbrs) {
            if (mbr.equals(this.local_addr) || this.timestamps.containsKey(mbr)) continue;
            this.timestamps.put(mbr, System.currentTimeMillis());
        }
        this.invalid_pingers.clear();
        if (!this.tasks_running && this.members.size() > 1) {
            this.startTasks();
        } else if (this.tasks_running && this.members.size() < 2) {
            this.stopTasks();
        }
    }

    private void shunInvalidHeartbeatSender(Address sender) {
        int num_pings = 0;
        if (this.invalid_pingers.containsKey(sender)) {
            num_pings = this.invalid_pingers.get(sender);
            if (num_pings >= 3) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)(sender + " is not in " + this.members + " ! Shunning it"));
                }
                Message shun_msg = new Message(sender, null, null);
                shun_msg.setFlag((byte)1);
                shun_msg.putHeader(name, new Header(2));
                this.down_prot.down(new Event(1, shun_msg));
                this.invalid_pingers.remove(sender);
            } else {
                this.invalid_pingers.put(sender, new Integer(++num_pings));
            }
        } else {
            this.invalid_pingers.put(sender, ++num_pings);
        }
    }

    private String printTimeStamps() {
        StringBuilder sb = new StringBuilder();
        long current_time = System.currentTimeMillis();
        for (Map.Entry<Address, Long> entry : this.timestamps.entrySet()) {
            sb.append(entry.getKey()).append(": ");
            sb.append(current_time - entry.getValue()).append(" ms old\n");
        }
        return sb.toString();
    }

    void suspect(Address mbr) {
        Message suspect_msg = new Message();
        suspect_msg.setFlag((byte)1);
        Header hdr = new Header(1, mbr);
        suspect_msg.putHeader(name, hdr);
        this.down_prot.down(new Event(1, suspect_msg));
        ++this.num_suspect_events;
        this.suspect_history.add(mbr);
    }

    class TimeoutChecker
    extends HeartbeatSender {
        TimeoutChecker() {
        }

        public void run() {
            if (FD_ALL.this.log.isTraceEnabled()) {
                FD_ALL.this.log.trace((Object)("checking for expired senders, table is:\n" + FD_ALL.this.printTimeStamps()));
            }
            long current_time = System.currentTimeMillis();
            Iterator<Map.Entry<Address, Long>> it = FD_ALL.this.timestamps.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Address, Long> entry = it.next();
                Address key = entry.getKey();
                Long val = entry.getValue();
                if (val == null) {
                    it.remove();
                    continue;
                }
                long diff = current_time - val;
                if (diff <= FD_ALL.this.timeout) continue;
                if (FD_ALL.this.log.isTraceEnabled()) {
                    FD_ALL.this.log.trace((Object)("haven't received a heartbeat from " + key + " for " + diff + " ms, suspecting it"));
                }
                FD_ALL.this.suspect(key);
            }
        }
    }

    class HeartbeatSender
    implements Runnable {
        HeartbeatSender() {
        }

        public void run() {
            Message heartbeat = new Message();
            heartbeat.setFlag((byte)1);
            Header hdr = new Header(0);
            heartbeat.putHeader(FD_ALL.name, hdr);
            FD_ALL.this.down_prot.down(new Event(1, heartbeat));
            ++FD_ALL.this.num_heartbeats_sent;
        }
    }

    public static class Header
    extends org.jgroups.Header
    implements Streamable {
        public static final byte HEARTBEAT = 0;
        public static final byte SUSPECT = 1;
        public static final byte NOT_MEMBER = 2;
        byte type = 0;
        Address suspected_mbr = null;

        public Header() {
        }

        public Header(byte type) {
            this.type = type;
        }

        public Header(byte type, Address suspect) {
            this(type);
            this.suspected_mbr = suspect;
        }

        public String toString() {
            switch (this.type) {
                case 0: {
                    return "heartbeat";
                }
                case 1: {
                    return "SUSPECT (suspected_mbr=" + this.suspected_mbr + ")";
                }
                case 2: {
                    return "NOT_MEMBER";
                }
            }
            return "unknown type (" + this.type + ")";
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeByte(this.type);
            out.writeObject(this.suspected_mbr);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.suspected_mbr = (Address)in.readObject();
        }

        public int size() {
            int retval = 1;
            return retval += Util.size(this.suspected_mbr);
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeByte(this.type);
            Util.writeAddress(this.suspected_mbr, out);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.type = in.readByte();
            this.suspected_mbr = Util.readAddress(in);
        }
    }
}

