/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.proccess.WorkerThread;
import org.exoplatform.services.log.ExoLogger;
import org.picocontainer.Startable;

@Managed
@NameTemplate(value={@Property(key="service", value="SessionRegistry")})
public final class SessionRegistry
implements Startable {
    private final Map<String, SessionImpl> sessionsMap = new ConcurrentHashMap<String, SessionImpl>();
    public static final int DEFAULT_CLEANER_TIMEOUT = 60000;
    protected static Log log = ExoLogger.getLogger((String)"jcr.SessionRegistry");
    private SessionCleaner sessionCleaner;
    protected long timeOut;

    @Managed
    @ManagedDescription(value="How many sessions are currently active")
    public int getSize() {
        return this.sessionsMap.size();
    }

    @Managed
    @ManagedDescription(value="The session time out")
    public long getTimeOut() {
        return this.timeOut;
    }

    @Managed
    @ManagedDescription(value="Perform a cleanup of timed out sessions")
    public void runCleanup() {
        try {
            this.sessionCleaner.callPeriodically();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SessionRegistry(RepositoryEntry entry) {
        if (entry != null) {
            this.timeOut = entry.getSessionTimeOut() > 0L ? entry.getSessionTimeOut() : 0L;
        }
    }

    public void registerSession(SessionImpl session) {
        this.sessionsMap.put(session.getId(), session);
    }

    public void unregisterSession(String sessionId) {
        this.sessionsMap.remove(sessionId);
    }

    public SessionImpl getSession(String sessionId) {
        return sessionId == null ? null : this.sessionsMap.get(sessionId);
    }

    public boolean isInUse(String workspaceName) {
        if (workspaceName == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Session in use " + this.sessionsMap.size()));
            }
            return this.sessionsMap.size() > 0;
        }
        for (SessionImpl session : this.sessionsMap.values()) {
            if (!session.getWorkspace().getName().equals(workspaceName)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Session for workspace " + workspaceName + " in use." + " Session id:" + session.getId() + " user: " + session.getUserID()));
            }
            return true;
        }
        return false;
    }

    public void start() {
        this.sessionsMap.clear();
        if (this.timeOut > 0L) {
            this.sessionCleaner = new SessionCleaner(60000L, this.timeOut);
        }
    }

    public void stop() {
        if (this.timeOut > 0L && this.sessionCleaner != null) {
            this.sessionCleaner.halt();
        }
        this.sessionsMap.clear();
    }

    private class SessionCleaner
    extends WorkerThread {
        private final long sessionTimeOut;

        public SessionCleaner(long workTime, long sessionTimeOut) {
            super(workTime);
            this.sessionTimeOut = sessionTimeOut;
            this.setName("SessionCleaner " + this.getId());
            this.setPriority(1);
            this.setDaemon(true);
            this.start();
            log.info((Object)("SessionCleaner instantiated name= " + this.getName() + " workTime= " + workTime + " sessionTimeOut=" + sessionTimeOut));
        }

        protected void callPeriodically() throws Exception {
            for (SessionImpl session : SessionRegistry.this.sessionsMap.values()) {
                if (session.getLastAccessTime() + this.sessionTimeOut >= System.currentTimeMillis()) continue;
                session.logout();
            }
        }
    }
}

