/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.IOException;
import org.exoplatform.services.jcr.impl.storage.value.fs.FileValueStorage;
import org.exoplatform.services.jcr.impl.storage.value.fs.TreeFile;
import org.exoplatform.services.jcr.impl.storage.value.fs.TreeFileIOChannel;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;

public class TreeFileValueStorage
extends FileValueStorage {
    public TreeFileValueStorage() {
        this.cleaner = new TreeFileCleaner();
    }

    public ValueIOChannel openIOChannel() throws IOException {
        return new TreeFileIOChannel(this.rootDir, this.cleaner, this.getId());
    }

    protected class TreeFileCleaner
    extends FileCleaner {
        protected TreeFileCleaner() {
        }

        public synchronized void addFile(File file) {
            super.addFile(new TreeFile(file.getAbsolutePath(), TreeFileValueStorage.this.cleaner, TreeFileValueStorage.this.rootDir));
        }
    }
}

