/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemDataKeeper;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.xml.XmlMapping;
import org.exoplatform.services.jcr.impl.xml.exporting.BaseXmlExporter;
import org.exoplatform.services.jcr.impl.xml.exporting.DocumentViewContentExporter;
import org.exoplatform.services.jcr.impl.xml.exporting.DocumentViewStreamExporter;
import org.exoplatform.services.jcr.impl.xml.exporting.SystemViewContentExporter;
import org.exoplatform.services.jcr.impl.xml.exporting.SystemViewStreamExporter;
import org.exoplatform.services.jcr.impl.xml.exporting.WorkspaceSystemViewStreamExporter;
import org.exoplatform.services.jcr.impl.xml.importing.ContentHandlerImporter;
import org.exoplatform.services.jcr.impl.xml.importing.StreamImporter;
import org.exoplatform.services.jcr.impl.xml.importing.WorkspaceDataImporter;
import org.exoplatform.services.security.ConversationState;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportImportFactory {
    public BaseXmlExporter getExportVisitor(XmlMapping type, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse, ItemDataConsumer dataManager, NamespaceRegistry namespaceRegistry, ValueFactoryImpl systemValueFactory) throws NamespaceException, RepositoryException {
        if (type == XmlMapping.SYSVIEW) {
            return new SystemViewContentExporter(contentHandler, dataManager, namespaceRegistry, systemValueFactory, skipBinary, noRecurse);
        }
        if (type == XmlMapping.DOCVIEW) {
            return new DocumentViewContentExporter(contentHandler, dataManager, namespaceRegistry, systemValueFactory, skipBinary, noRecurse);
        }
        return null;
    }

    public BaseXmlExporter getExportVisitor(XmlMapping type, OutputStream stream, boolean skipBinary, boolean noRecurse, ItemDataConsumer dataManager, NamespaceRegistry namespaceRegistry, ValueFactoryImpl systemValueFactory) throws NamespaceException, RepositoryException, IOException {
        XMLStreamWriter streamWriter;
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        try {
            streamWriter = outputFactory.createXMLStreamWriter(stream, "UTF-8");
        }
        catch (XMLStreamException e) {
            throw new IOException(e.getLocalizedMessage());
        }
        if (type == XmlMapping.SYSVIEW) {
            return new SystemViewStreamExporter(streamWriter, dataManager, namespaceRegistry, systemValueFactory, skipBinary, noRecurse);
        }
        if (type == XmlMapping.DOCVIEW) {
            return new DocumentViewStreamExporter(streamWriter, dataManager, namespaceRegistry, systemValueFactory, skipBinary, noRecurse);
        }
        if (type == XmlMapping.BACKUP) {
            return new WorkspaceSystemViewStreamExporter(streamWriter, dataManager, namespaceRegistry, systemValueFactory, skipBinary, noRecurse);
        }
        return null;
    }

    public ContentHandler getImportHandler(NodeData parent, int uuidBehavior, ItemDataKeeper dataKeeper, ItemDataConsumer dataConsumer, NodeTypeManagerImpl ntManager, LocationFactory locationFactory, ValueFactoryImpl valueFactory, NamespaceRegistry namespaceRegistry, AccessManager accessManager, ConversationState userState, Map<String, Object> context, RepositoryImpl repository, String currentWorkspaceName) {
        return new ContentHandlerImporter(parent, uuidBehavior, dataKeeper, dataConsumer, ntManager, locationFactory, valueFactory, namespaceRegistry, accessManager, userState, context, repository, currentWorkspaceName);
    }

    public StreamImporter getStreamImporter(NodeData parent, int uuidBehavior, ItemDataKeeper dataKeeper, ItemDataConsumer dataConsumer, NodeTypeManagerImpl ntManager, LocationFactory locationFactory, ValueFactoryImpl valueFactory, NamespaceRegistry namespaceRegistry, AccessManager accessManager, ConversationState userState, Map<String, Object> context, RepositoryImpl repository, String currentWorkspaceName) {
        return new StreamImporter(parent, uuidBehavior, dataKeeper, dataConsumer, ntManager, locationFactory, valueFactory, namespaceRegistry, accessManager, userState, context, repository, currentWorkspaceName);
    }

    public StreamImporter getWorkspaceImporter(NodeData parent, int uuidBehavior, ItemDataKeeper dataKeeper, ItemDataConsumer dataConsumer, NodeTypeManagerImpl ntManager, LocationFactory locationFactory, ValueFactoryImpl valueFactory, NamespaceRegistry namespaceRegistry, AccessManager accessManager, ConversationState userState, Map<String, Object> context, RepositoryImpl repository, String currentWorkspaceName) {
        return new WorkspaceDataImporter(parent, uuidBehavior, dataKeeper, dataConsumer, ntManager, locationFactory, valueFactory, namespaceRegistry, accessManager, userState, context, repository, currentWorkspaceName);
    }
}

