/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xml.serialize.BaseMarkupSerializer;
import org.apache.xml.serialize.ElementState;
import org.apache.xml.serialize.OutputFormat;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLSerializer
extends BaseMarkupSerializer {
    protected static final boolean DEBUG = false;
    protected NamespaceSupport fNSBinder;
    protected NamespaceSupport fLocalNSBinder;
    protected SymbolTable fSymbolTable;
    protected String fEmptySymbol;
    protected String fXmlSymbol;
    protected String fXmlnsSymbol;
    protected boolean fDOML1 = false;
    protected int fNamespaceCounter = 1;
    protected boolean fNamespaces = false;
    private boolean fPreserveSpace;

    public XMLSerializer() {
        super(new OutputFormat("xml", null, false));
    }

    public XMLSerializer(OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
    }

    public XMLSerializer(Writer writer, OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputCharStream(writer);
    }

    public XMLSerializer(OutputStream outputStream, OutputFormat outputFormat) {
        super(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputByteStream(outputStream);
    }

    public void setOutputFormat(OutputFormat outputFormat) {
        super.setOutputFormat(outputFormat != null ? outputFormat : new OutputFormat("xml", null, false));
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        boolean bl = false;
        try {
            String string4;
            String string5;
            Object object;
            if (this._printer == null) {
                throw new IllegalStateException("SER002 No writer supplied for serializer");
            }
            ElementState elementState = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(string2 == null || string2.length() == 0 ? string3 : string2);
                }
            } else {
                if (elementState.empty) {
                    this._printer.printText('>');
                }
                if (elementState.inCData) {
                    this._printer.printText("]]>");
                    elementState.inCData = false;
                }
                if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean bl2 = elementState.preserveSpace;
            attributes = this.extractNamespaces(attributes);
            if (string3 == null || string3.length() == 0) {
                if (string2 == null) {
                    throw new SAXException("No rawName and localName is null");
                }
                string3 = string != null && !string.equals("") ? ((object = this.getPrefix(string)) != null && ((String)object).length() > 0 ? (String)object + ":" + string2 : string2) : string2;
                bl = true;
            }
            this._printer.printText('<');
            this._printer.printText(string3);
            this._printer.indent();
            if (attributes != null) {
                int n = 0;
                while (n < attributes.getLength()) {
                    this._printer.printSpace();
                    string5 = attributes.getQName(n);
                    if (string5 != null && string5.length() == 0) {
                        string5 = attributes.getLocalName(n);
                        String string6 = attributes.getURI(n);
                        if (!(string6 == null || string6.length() == 0 || string != null && string.length() != 0 && string6.equals(string) || (object = this.getPrefix(string6)) == null || ((String)object).length() <= 0)) {
                            string5 = (String)object + ":" + string5;
                        }
                    }
                    if ((string4 = attributes.getValue(n)) == null) {
                        string4 = "";
                    }
                    this._printer.printText(string5);
                    this._printer.printText("=\"");
                    this.printEscaped(string4);
                    this._printer.printText('\"');
                    if (string5.equals("xml:space")) {
                        bl2 = string4.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++n;
                }
            }
            if (this._prefixes != null) {
                object = this._prefixes.keys();
                while (object.hasMoreElements()) {
                    this._printer.printSpace();
                    string4 = (String)object.nextElement();
                    string5 = (String)this._prefixes.get(string4);
                    if (string5.length() == 0) {
                        this._printer.printText("xmlns=\"");
                        this.printEscaped(string4);
                        this._printer.printText('\"');
                        continue;
                    }
                    this._printer.printText("xmlns:");
                    this._printer.printText(string5);
                    this._printer.printText("=\"");
                    this.printEscaped(string4);
                    this._printer.printText('\"');
                }
            }
            elementState = this.enterElementState(string, string2, string3, bl2);
            string5 = string2 == null || string2.length() == 0 ? string3 : string + "^" + string2;
            elementState.doCData = this._format.isCDataElement(string5);
            elementState.unescaped = this._format.isNonEscapingElement(string5);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.endElementIO(string, string2, string3);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElementIO(String string, String string2, String string3) throws IOException {
        this._printer.unindent();
        ElementState elementState = this.getElementState();
        if (elementState.empty) {
            this._printer.printText("/>");
        } else {
            if (elementState.inCData) {
                this._printer.printText("]]>");
            }
            if (this._indenting && !elementState.preserveSpace && (elementState.afterElement || elementState.afterComment)) {
                this._printer.breakLine();
            }
            this._printer.printText("</");
            this._printer.printText(elementState.rawName);
            this._printer.printText('>');
        }
        elementState = this.leaveElementState();
        elementState.afterElement = true;
        elementState.afterComment = false;
        elementState.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        try {
            if (this._printer == null) {
                throw new IllegalStateException("SER002 No writer supplied for serializer");
            }
            ElementState elementState = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(string);
                }
            } else {
                if (elementState.empty) {
                    this._printer.printText('>');
                }
                if (elementState.inCData) {
                    this._printer.printText("]]>");
                    elementState.inCData = false;
                }
                if (this._indenting && !elementState.preserveSpace && (elementState.empty || elementState.afterElement || elementState.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean bl = elementState.preserveSpace;
            this._printer.printText('<');
            this._printer.printText(string);
            this._printer.indent();
            if (attributeList != null) {
                int n = 0;
                while (n < attributeList.getLength()) {
                    this._printer.printSpace();
                    String string2 = attributeList.getName(n);
                    String string3 = attributeList.getValue(n);
                    if (string3 != null) {
                        this._printer.printText(string2);
                        this._printer.printText("=\"");
                        this.printEscaped(string3);
                        this._printer.printText('\"');
                    }
                    if (string2.equals("xml:space")) {
                        bl = string3.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++n;
                }
            }
            elementState = this.enterElementState(null, null, string, bl);
            elementState.doCData = this._format.isCDataElement(string);
            elementState.unescaped = this._format.isNonEscapingElement(string);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void endElement(String string) throws SAXException {
        this.endElement(null, null, string);
    }

    protected void startDocument(String string) throws IOException {
        String string2 = this._printer.leaveDTD();
        if (!this._started) {
            if (!this._format.getOmitXMLDeclaration()) {
                StringBuffer stringBuffer = new StringBuffer("<?xml version=\"");
                if (this._format.getVersion() != null) {
                    stringBuffer.append(this._format.getVersion());
                } else {
                    stringBuffer.append("1.0");
                }
                stringBuffer.append('\"');
                String string3 = this._format.getEncoding();
                if (string3 != null) {
                    stringBuffer.append(" encoding=\"");
                    stringBuffer.append(string3);
                    stringBuffer.append('\"');
                }
                if (this._format.getStandalone() && this._docTypeSystemId == null && this._docTypePublicId == null) {
                    stringBuffer.append(" standalone=\"yes\"");
                }
                stringBuffer.append("?>");
                this._printer.printText(stringBuffer);
                this._printer.breakLine();
            }
            if (!this._format.getOmitDocumentType()) {
                if (this._docTypeSystemId != null) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(string);
                    if (this._docTypePublicId != null) {
                        this._printer.printText(" PUBLIC ");
                        this.printDoctypeURL(this._docTypePublicId);
                        if (this._indenting) {
                            this._printer.breakLine();
                            int n = 0;
                            while (n < 18 + string.length()) {
                                this._printer.printText(" ");
                                ++n;
                            }
                        } else {
                            this._printer.printText(" ");
                        }
                        this.printDoctypeURL(this._docTypeSystemId);
                    } else {
                        this._printer.printText(" SYSTEM ");
                        this.printDoctypeURL(this._docTypeSystemId);
                    }
                    if (string2 != null && string2.length() > 0) {
                        this._printer.printText(" [");
                        this.printText(string2, true, true);
                        this._printer.printText(']');
                    }
                    this._printer.printText(">");
                    this._printer.breakLine();
                } else if (string2 != null && string2.length() > 0) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(string);
                    this._printer.printText(" [");
                    this.printText(string2, true, true);
                    this._printer.printText("]>");
                    this._printer.breakLine();
                }
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    /*
     * Unable to fully structure code
     */
    protected void serializeElement(Element var1_1) throws IOException {
        block59: {
            block58: {
                if (this.fNamespaces) {
                    this.fLocalNSBinder.reset(this.fSymbolTable);
                    this.fLocalNSBinder.pushContext();
                    this.fNSBinder.pushContext();
                }
                var9_2 = var1_1.getTagName();
                var6_3 = this.getElementState();
                if (this.isDocumentState()) {
                    v0 = this.fDOML1 = var1_1.getLocalName() == null;
                    if (!this._started) {
                        this.startDocument(var9_2);
                    }
                } else {
                    if (var6_3.empty) {
                        this._printer.printText('>');
                    }
                    if (var6_3.inCData) {
                        this._printer.printText("]]>");
                        var6_3.inCData = false;
                    }
                    if (this._indenting && !var6_3.preserveSpace && (var6_3.empty || var6_3.afterElement || var6_3.afterComment)) {
                        this._printer.breakLine();
                    }
                }
                this.fPreserveSpace = var6_3.preserveSpace;
                var12_4 = 0;
                var3_5 = null;
                if (var1_1.hasAttributes()) {
                    var3_5 = var1_1.getAttributes();
                    var12_4 = var3_5.getLength();
                }
                if (this.fNamespaces) break block58;
                this._printer.printText('<');
                this._printer.printText(var9_2);
                this._printer.indent();
                var4_6 = 0;
                while (var4_6 < var12_4) {
                    var2_7 = (Attr)var3_5.item(var4_6);
                    var7_8 = var2_7.getName();
                    var8_9 = var2_7.getValue();
                    if (var8_9 == null) {
                        var8_9 = "";
                    }
                    if (var2_7.getSpecified()) {
                        this._printer.printSpace();
                        this._printer.printText(var7_8);
                        this._printer.printText("=\"");
                        this.printEscaped(var8_9);
                        this._printer.printText('\"');
                    }
                    if (var7_8.equals("xml:space")) {
                        this.fPreserveSpace = var8_9.equals("preserve") != false ? true : this._format.getPreserveSpace();
                    }
                    ++var4_6;
                }
                break block59;
            }
            var11_10 = var1_1.getNamespaceURI();
            var10_11 = var1_1.getPrefix();
            if (var11_10 != null && var10_11 != null && var11_10.length() == 0 && var10_11.length() != 0) {
                var10_11 = null;
                this._printer.printText('<');
                this._printer.printText(var1_1.getLocalName());
                this._printer.indent();
            } else {
                this._printer.printText('<');
                this._printer.printText(var9_2);
                this._printer.indent();
            }
            if (var11_10 != null) {
                var11_10 = this.fSymbolTable.addSymbol(var11_10);
                v1 = var10_11 = var10_11 == null || var10_11.length() == 0 ? this.fEmptySymbol : this.fSymbolTable.addSymbol(var10_11);
                if (this.fNSBinder.getURI(var10_11) != var11_10) {
                    this.printNamespaceAttr(var10_11, var11_10);
                    this.fLocalNSBinder.declarePrefix(var10_11, var11_10);
                    this.fNSBinder.declarePrefix(var10_11, var11_10);
                }
            } else {
                var13_12 = var9_2.indexOf(58);
                if (var13_12 > -1) {
                    var14_17 = var9_2.lastIndexOf(58);
                    if (var13_12 != var14_17) {
                        if (this.fDOMErrorHandler != null) {
                            this.modifyDOMError("Element's name is not a QName: " + var9_2, (short)1);
                            var15_19 = this.fDOMErrorHandler.handleError(this.fDOMError);
                        }
                    } else if (this.fDOMErrorHandler != null) {
                        this.modifyDOMError("Element <" + var9_2 + "> does not belong to any namespace: prefix could be undeclared or bound to some namespace", (short)0);
                        var15_19 = this.fDOMErrorHandler.handleError(this.fDOMError);
                    }
                } else {
                    var11_10 = this.fNSBinder.getURI(this.fEmptySymbol);
                    if (var11_10 != null && var11_10.length() > 0) {
                        this.printNamespaceAttr(this.fEmptySymbol, this.fEmptySymbol);
                        this.fLocalNSBinder.declarePrefix(this.fEmptySymbol, this.fEmptySymbol);
                        this.fNSBinder.declarePrefix(this.fEmptySymbol, this.fEmptySymbol);
                    }
                }
            }
            var4_6 = 0;
            while (var4_6 < var12_4) {
                block61: {
                    block60: {
                        var2_7 = (Attr)var3_5.item(var4_6);
                        var8_9 = var2_7.getValue();
                        var7_8 = var2_7.getNodeName();
                        var11_10 = var2_7.getNamespaceURI();
                        if (var11_10 != null && var11_10.length() == 0) {
                            var11_10 = null;
                            var7_8 = var2_7.getLocalName();
                        }
                        if (var8_9 == null) {
                            var8_9 = this.fEmptySymbol;
                        }
                        if (var11_10 == null) break block60;
                        var10_11 = var2_7.getPrefix();
                        var10_11 = var10_11 == null ? this.fEmptySymbol : this.fSymbolTable.addSymbol(var10_11);
                        var14_18 = this.fSymbolTable.addSymbol(var2_7.getLocalName());
                        if (var10_11 == this.fXmlnsSymbol) {
                            var11_10 = this.fNSBinder.getURI(var14_18);
                            var13_13 = this.fLocalNSBinder.getURI(var14_18);
                            var8_9 = this.fSymbolTable.addSymbol(var8_9);
                            if ((var11_10 == null || var13_13 == null) && var8_9.length() != 0) {
                                this.printNamespaceAttr(var14_18, var8_9);
                                this.fNSBinder.declarePrefix(var14_18, var8_9);
                                this.fLocalNSBinder.declarePrefix(var14_18, var8_9);
                            }
                        } else if (var14_18 == this.fXmlnsSymbol && var10_11 == this.fEmptySymbol) {
                            var11_10 = this.fNSBinder.getURI(this.fEmptySymbol);
                            var13_14 = this.fLocalNSBinder.getURI(this.fEmptySymbol);
                            var8_9 = this.fSymbolTable.addSymbol(var8_9);
                            if (var13_14 == null) {
                                this.printNamespaceAttr(this.fEmptySymbol, var8_9);
                                this.fLocalNSBinder.declarePrefix(this.fEmptySymbol, var8_9);
                                this.fNSBinder.declarePrefix(this.fEmptySymbol, var8_9);
                            }
                        } else {
                            var11_10 = this.fSymbolTable.addSymbol(var11_10);
                            var15_20 = this.fNSBinder.getURI(var10_11);
                            if (var10_11 == this.fEmptySymbol || var15_20 != var11_10) {
                                var7_8 = var2_7.getNodeName();
                                var16_22 = this.fNSBinder.getPrefix(var11_10);
                                if (var16_22 == null || var16_22 == this.fEmptySymbol) {
                                    if (var10_11 == this.fEmptySymbol) {
                                        var10_11 = "NS" + this.fNamespaceCounter++;
                                    }
                                    this.printNamespaceAttr(var10_11, var11_10);
                                    var8_9 = this.fSymbolTable.addSymbol(var8_9);
                                    this.fLocalNSBinder.declarePrefix(var10_11, var8_9);
                                    this.fNSBinder.declarePrefix(var10_11, var11_10);
                                } else {
                                    var10_11 = var16_22;
                                }
                                var7_8 = var10_11 + ":" + var14_18;
                            }
                            this.printAttribute(var7_8, var8_9 == null ? this.fEmptySymbol : var8_9, var2_7.getSpecified());
                        }
                        break block61;
                    }
                    var14_17 = var7_8.indexOf(58);
                    var15_21 = var7_8.lastIndexOf(58);
                    if (!var7_8.startsWith(this.fXmlnsSymbol)) ** GOTO lbl182
                    if (var14_17 < 0) {
                        var11_10 = this.fNSBinder.getURI(this.fEmptySymbol);
                        var13_15 = this.fLocalNSBinder.getURI(this.fEmptySymbol);
                        if (var13_15 == null) {
                            var8_9 = this.fSymbolTable.addSymbol(var8_9);
                            this.fNSBinder.declarePrefix(this.fEmptySymbol, var8_9);
                            this.fLocalNSBinder.declarePrefix(this.fEmptySymbol, var8_9);
                            this.printAttribute(var7_8, var8_9, var2_7.getSpecified());
                        }
                    } else {
                        if (var14_17 == var15_21) {
                            var10_11 = var7_8.substring(6);
                            v2 = var10_11 = var10_11.length() == 0 ? this.fEmptySymbol : this.fSymbolTable.addSymbol(var10_11);
                            if (var10_11.length() == 0) {
                                if (this.fDOMErrorHandler != null) {
                                    this.modifyDOMError("Namespace declaration syntax is incorrect " + var7_8, (short)1);
                                    var16_23 = this.fDOMErrorHandler.handleError(this.fDOMError);
                                }
                            } else if (var8_9.length() == 0 && this.fDOMErrorHandler != null) {
                                this.modifyDOMError("Namespace declaration syntax is incorrect " + var7_8, (short)1);
                                var16_24 = this.fDOMErrorHandler.handleError(this.fDOMError);
                            }
                            var11_10 = this.fNSBinder.getURI(var10_11);
                            var13_16 = this.fLocalNSBinder.getURI(var10_11);
                            if ((var11_10 == null || var13_16 == null) && var8_9.length() != 0) {
                                var8_9 = this.fSymbolTable.addSymbol(var8_9);
                                this.fNSBinder.declarePrefix(var10_11, var8_9);
                                this.fLocalNSBinder.declarePrefix(var10_11, var8_9);
                            }
                        }
lbl182:
                        // 6 sources

                        if (var14_17 > -1) {
                            if (var14_17 != var15_21) {
                                if (this.fDOMErrorHandler != null) {
                                    this.modifyDOMError("Attribute's name is not a QName: " + var7_8, (short)1);
                                    var16_25 = this.fDOMErrorHandler.handleError(this.fDOMError);
                                }
                            } else if (this.fDOMErrorHandler != null) {
                                this.modifyDOMError("Attribute '" + var7_8 + "' does not belong to any namespace: prefix could be undeclared or bound to some namespace", (short)0);
                                var16_26 = this.fDOMErrorHandler.handleError(this.fDOMError);
                            }
                            this.printAttribute(var7_8, var8_9, var2_7.getSpecified());
                        } else {
                            this.printAttribute(var7_8, var8_9, var2_7.getSpecified());
                        }
                    }
                }
                ++var4_6;
            }
        }
        if (var1_1.hasChildNodes()) {
            var6_3 = this.enterElementState(null, null, var9_2, this.fPreserveSpace);
            var6_3.doCData = this._format.isCDataElement(var9_2);
            var6_3.unescaped = this._format.isNonEscapingElement(var9_2);
            var5_27 = var1_1.getFirstChild();
            while (var5_27 != null) {
                this.serializeNode(var5_27);
                var5_27 = var5_27.getNextSibling();
            }
            if (this.fNamespaces) {
                this.fNSBinder.popContext();
            }
            this.endElementIO(null, null, var9_2);
        } else {
            if (this.fNamespaces) {
                this.fNSBinder.popContext();
            }
            this._printer.unindent();
            this._printer.printText("/>");
            var6_3.afterElement = true;
            var6_3.afterComment = false;
            var6_3.empty = false;
            if (this.isDocumentState()) {
                this._printer.flush();
            }
        }
    }

    private void printNamespaceAttr(String string, String string2) throws IOException {
        this._printer.printSpace();
        if (string == this.fEmptySymbol) {
            this._printer.printText(this.fXmlnsSymbol);
        } else {
            this._printer.printText("xmlns:" + string);
        }
        this._printer.printText("=\"");
        this.printEscaped(string2);
        this._printer.printText('\"');
    }

    private void printAttribute(String string, String string2, boolean bl) throws IOException {
        if (bl || this.fFeatures != null && !((Boolean)this.fFeatures.get("discard-default-content")).booleanValue()) {
            this._printer.printSpace();
            this._printer.printText(string);
            this._printer.printText("=\"");
            this.printEscaped(string2);
            this._printer.printText('\"');
        }
        if (string.equals("xml:space")) {
            this.fPreserveSpace = string2.equals("preserve") ? true : this._format.getPreserveSpace();
        }
    }

    protected String getEntityRef(int n) {
        switch (n) {
            case 60: {
                return "lt";
            }
            case 62: {
                return "gt";
            }
            case 34: {
                return "quot";
            }
            case 39: {
                return "apos";
            }
            case 38: {
                return "amp";
            }
        }
        return null;
    }

    private Attributes extractNamespaces(Attributes attributes) throws SAXException {
        if (attributes == null) {
            return null;
        }
        int n = attributes.getLength();
        AttributesImpl attributesImpl = new AttributesImpl(attributes);
        int n2 = n - 1;
        while (n2 >= 0) {
            String string = attributesImpl.getQName(n2);
            if (string.startsWith("xmlns")) {
                if (string.length() == 5) {
                    this.startPrefixMapping("", attributes.getValue(n2));
                    attributesImpl.removeAttribute(n2);
                } else if (string.charAt(5) == ':') {
                    this.startPrefixMapping(string.substring(6), attributes.getValue(n2));
                    attributesImpl.removeAttribute(n2);
                }
            }
            --n2;
        }
        return attributesImpl;
    }

    public boolean reset() {
        super.reset();
        return true;
    }
}

