/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitions;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeImpl;

public class WorkspaceNTImpl
implements ExtendedNodeType {
    private NodeTypeImpl nodeType;
    private SessionImpl session;

    public WorkspaceNTImpl(NodeTypeImpl nodeType, SessionImpl session) {
        this.session = session;
        this.nodeType = nodeType;
    }

    public String getName() {
        String n = null;
        try {
            n = this.session.getLocationFactory().createJCRName(this.nodeType.getQName()).getAsString();
        }
        catch (RepositoryException e) {
            throw new RuntimeException("TYPE NAME >>> " + n + " " + (Object)((Object)e), e);
        }
        return n;
    }

    public NodeType[] getDeclaredSupertypes() {
        return this.nodeType.getDeclaredSupertypes();
    }

    public NodeType[] getSupertypes() {
        return this.nodeType.getSupertypes();
    }

    public boolean canAddChildNode(String childNodeName, String nodeTypeName) {
        return this.nodeType.canAddChildNode(childNodeName, nodeTypeName);
    }

    public boolean canAddChildNode(String childNodeName) {
        return this.nodeType.canAddChildNode(childNodeName);
    }

    public boolean canRemoveItem(String itemName) {
        return this.nodeType.canRemoveItem(itemName);
    }

    public boolean canSetProperty(String propertyName, Value value) {
        return this.nodeType.canSetProperty(propertyName, value);
    }

    public boolean canSetProperty(String propertyName, Value[] values) {
        return this.nodeType.canSetProperty(propertyName, values);
    }

    public NodeDefinition[] getChildNodeDefinitions() {
        return this.nodeType.getChildNodeDefinitions();
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        return this.nodeType.getDeclaredChildNodeDefinitions();
    }

    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        return this.nodeType.getDeclaredPropertyDefinitions();
    }

    public String getPrimaryItemName() {
        return this.nodeType.getPrimaryItemName();
    }

    public PropertyDefinition[] getPropertyDefinitions() {
        return this.nodeType.getPropertyDefinitions();
    }

    public boolean hasOrderableChildNodes() {
        return this.nodeType.hasOrderableChildNodes();
    }

    public boolean isMixin() {
        return this.nodeType.isMixin();
    }

    public boolean isNodeType(String nodeTypeName) {
        return this.nodeType.isNodeType(nodeTypeName);
    }

    public boolean isNodeType(InternalQName nodeTypeQName) {
        return this.nodeType.isNodeType(nodeTypeQName);
    }

    public boolean equals(Object obj) {
        return this.nodeType.equals(obj);
    }

    public InternalQName getQName() {
        return this.nodeType.getQName();
    }

    public NodeDefinition getChildNodeDefinition(InternalQName name) {
        return this.nodeType.getChildNodeDefinition(name);
    }

    public PropertyDefinitions getPropertyDefinitions(InternalQName name) {
        return this.nodeType.getPropertyDefinitions(name);
    }

    public boolean isChildNodePrimaryTypeAllowed(String typeName) {
        return this.nodeType.isChildNodePrimaryTypeAllowed(typeName);
    }

    public NodeDefinition getChildNodeDefinition(String typeName) {
        return this.nodeType.getChildNodeDefinition(typeName);
    }

    public ArrayList getManadatoryItemDefs() {
        return this.nodeType.getManadatoryItemDefs();
    }

    public PropertyDefinitions getPropertyDefinitions(String name) {
        return this.nodeType.getPropertyDefinitions(name);
    }

    public void setDeclaredNodeDefs(NodeDefinition[] nodeDefinitions) {
        this.nodeType.setDeclaredNodeDefs(nodeDefinitions);
    }

    public void setDeclaredPropertyDefs(PropertyDefinition[] propertyDefinitions) {
        this.nodeType.setDeclaredPropertyDefs(propertyDefinitions);
    }

    public void setDeclaredSupertypes(NodeType[] nodeTypes) {
        this.nodeType.setDeclaredSupertypes(nodeTypes);
    }

    public void setMixin(boolean mixin) {
        this.nodeType.setMixin(mixin);
    }

    public void setName(String name) {
        try {
            this.nodeType.setName(name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOrderableChild(boolean child) {
        this.nodeType.setOrderableChild(child);
    }

    public void setPrimaryItemName(String primaryItemName) {
        this.nodeType.setPrimaryItemName(primaryItemName);
    }
}

