/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.rmi.jrmp.interceptor;

import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import org.objectweb.carol.rmi.jrmp.interceptor.JClientRequestInterceptor;
import org.objectweb.carol.rmi.jrmp.interceptor.JInitializer;
import org.objectweb.carol.rmi.jrmp.interceptor.JInterceptorHelper;
import org.objectweb.carol.rmi.jrmp.interceptor.JRMPInitInfoImpl;
import org.objectweb.carol.rmi.jrmp.interceptor.JServerRequestInterceptor;
import org.objectweb.carol.util.configuration.TraceCarol;

public class JInterceptorStore {
    public static final String INTIALIZER_PREFIX = "org.objectweb.PortableInterceptor.JRMPInitializerClass";
    private static JServerRequestInterceptor[] sis = null;
    private static JClientRequestInterceptor[] cis = null;
    private static JClientRequestInterceptor[] rcis = null;
    private static UID uid = null;
    private static byte[] address = null;
    private static String[] initializers = null;
    private static JRMPInitInfoImpl jrmpInfo = new JRMPInitInfoImpl();

    public static JServerRequestInterceptor[] getLocalServerInterceptors() {
        return sis;
    }

    public static JClientRequestInterceptor[] getLocalClientInterceptors() {
        return cis;
    }

    public static synchronized String[] getJRMPInitializers() {
        if (initializers != null) {
            return initializers;
        }
        ArrayList<String> ins = new ArrayList<String>();
        Properties sys = System.getProperties();
        Enumeration<?> e = System.getProperties().propertyNames();
        while (e.hasMoreElements()) {
            String pkey = (String)e.nextElement();
            if (!pkey.startsWith(INTIALIZER_PREFIX)) continue;
            ins.add(pkey.substring(INTIALIZER_PREFIX.length() + 1));
        }
        int sz = ins.size();
        initializers = new String[sz];
        for (int i = 0; i < sz; ++i) {
            JInterceptorStore.initializers[i] = (String)ins.get(i);
        }
        return initializers;
    }

    public static synchronized JClientRequestInterceptor[] setRemoteInterceptors(byte[] raddr, UID ruid, String[] ia) {
        if (Arrays.equals(raddr, address) && ruid.equals(uid)) {
            return rcis;
        }
        jrmpInfo.clear();
        for (int i = 0; i < ia.length; ++i) {
            JInitializer jinit = null;
            try {
                jinit = (JInitializer)Class.forName(ia[i]).newInstance();
                jinit.pre_init(jrmpInfo);
                jinit.post_init(jrmpInfo);
                continue;
            }
            catch (Exception e) {
                TraceCarol.error("can not load interceptors", e);
            }
        }
        ruid = uid;
        address = raddr;
        rcis = jrmpInfo.getClientRequestInterceptors();
        return rcis;
    }

    static {
        try {
            JRMPInitInfoImpl jrmpInfo = new JRMPInitInfoImpl();
            String[] ins = JInterceptorStore.getJRMPInitializers();
            for (int i = 0; i < ins.length; ++i) {
                JInitializer jinit = (JInitializer)Thread.currentThread().getContextClassLoader().loadClass(ins[i]).newInstance();
                jinit.pre_init(jrmpInfo);
                jinit.post_init(jrmpInfo);
            }
            sis = jrmpInfo.getServerRequestInterceptors();
            cis = jrmpInfo.getClientRequestInterceptors();
            rcis = cis;
            uid = JInterceptorHelper.getSpaceID();
            address = JInterceptorHelper.getInetAddress();
        }
        catch (Exception e) {
            TraceCarol.error("JrmpPRODelegate(), No interceptors found", e);
        }
    }
}

