/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.management.annotations.ManagedBy;
import org.exoplatform.services.cache.BaseExoCache;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheConfigPlugin;
import org.exoplatform.services.cache.ExoCacheFactory;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.SimpleExoCache;
import org.exoplatform.services.cache.impl.CacheServiceManaged;
import org.exoplatform.services.cache.impl.DistributedCacheListener;
import org.exoplatform.services.cache.impl.LoggingCacheListener;

@ManagedBy(value=CacheServiceManaged.class)
public class CacheServiceImpl
implements CacheService {
    private final HashMap<String, ExoCacheConfig> configs_ = new HashMap();
    private final HashMap<String, ExoCache> cacheMap_ = new HashMap();
    private final ExoCacheConfig defaultConfig_;
    private final LoggingCacheListener loggingListener_;
    private final ExoCacheFactory factory_;
    private DistributedCacheListener distrbutedListener_;
    CacheServiceManaged managed;

    public CacheServiceImpl(InitParams params) throws Exception {
        this(params, null);
    }

    public CacheServiceImpl(InitParams params, ExoCacheFactory factory) throws Exception {
        List configs = params.getObjectParamValues(ExoCacheConfig.class);
        for (int i = 0; i < configs.size(); ++i) {
            ExoCacheConfig config = (ExoCacheConfig)configs.get(i);
            this.configs_.put(config.getName(), config);
        }
        this.defaultConfig_ = this.configs_.get("default");
        this.loggingListener_ = new LoggingCacheListener();
        this.factory_ = factory == null ? new SimpleExoCacheFactory() : factory;
    }

    public void addExoCacheConfig(ComponentPlugin plugin) {
        this.addExoCacheConfig((ExoCacheConfigPlugin)plugin);
    }

    public void addExoCacheConfig(ExoCacheConfigPlugin plugin) {
        List<ExoCacheConfig> configs = plugin.getConfigs();
        for (ExoCacheConfig config : configs) {
            this.configs_.put(config.getName(), config);
        }
    }

    public void setDistributedCacheListener(DistributedCacheListener listener) {
        this.distrbutedListener_ = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExoCache getCacheInstance(String region) {
        if (region == null) {
            throw new NullPointerException("region cannot be null");
        }
        if (region.length() == 0) {
            throw new IllegalArgumentException("region cannot be empty");
        }
        ExoCache cache = this.cacheMap_.get(region);
        if (cache == null) {
            HashMap<String, ExoCache> hashMap = this.cacheMap_;
            synchronized (hashMap) {
                ExoCacheConfig config = this.configs_.get(region);
                if (config == null) {
                    config = this.defaultConfig_;
                }
                try {
                    cache = this.createCacheInstance(region);
                    this.cacheMap_.put(region, cache);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return cache;
    }

    private synchronized ExoCache createCacheInstance(String region) throws Exception {
        ExoCacheConfig config = this.configs_.get(region);
        if (config == null) {
            config = this.defaultConfig_;
        }
        ExoCacheConfig safeConfig = config.clone();
        safeConfig.setName(region);
        ExoCache simple = this.factory_.createCache(safeConfig);
        if (this.managed != null) {
            this.managed.registerCache(simple);
        }
        return simple;
    }

    public Collection getAllCacheInstances() {
        return this.cacheMap_.values();
    }

    public synchronized void synchronize(String region, Serializable key, Object value) throws Exception {
        BaseExoCache cache = (BaseExoCache)this.getCacheInstance(region);
        if (key == null) {
            cache.localClear();
        } else if (value == null) {
            cache.localRemove(key);
        } else {
            cache.localPut(key, value);
        }
    }

    private class SimpleExoCacheFactory
    implements ExoCacheFactory {
        private SimpleExoCacheFactory() {
        }

        public ExoCache createCache(ExoCacheConfig config) throws ExoCacheInitException {
            ExoCache simple = this.createCacheInstance(config);
            simple.setName(config.getName());
            simple.setLabel(config.getLabel());
            simple.setMaxSize(config.getMaxSize());
            simple.setLiveTime(config.getLiveTime());
            simple.setReplicated(config.isRepicated());
            simple.setDistributed(config.isDistributed());
            if (simple.isDistributed()) {
                simple.addCacheListener(CacheServiceImpl.this.distrbutedListener_);
            }
            simple.setLogEnabled(config.isLogEnabled());
            if (simple.isLogEnabled()) {
                simple.addCacheListener(CacheServiceImpl.this.loggingListener_);
            }
            return simple;
        }

        private ExoCache createCacheInstance(ExoCacheConfig config) throws ExoCacheInitException {
            if (config.getImplementation() == null) {
                return new SimpleExoCache();
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> clazz = cl.loadClass(config.getImplementation());
                return (ExoCache)clazz.newInstance();
            }
            catch (Exception e) {
                throw new ExoCacheInitException("Cannot create instance of ExoCache of type " + config.getImplementation(), e);
            }
        }
    }
}

