/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.persistence;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSString;
import org.pdfbox.exceptions.COSVisitorException;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdfwriter.COSWriter;

public class FieldsDoc {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(String in, String out, String name, String value) throws IOException, COSVisitorException {
        InputStream is = null;
        COSDocument doc = null;
        OutputStream os = null;
        COSWriter writer = null;
        try {
            is = new FileInputStream(in);
            PDFParser parser = new PDFParser(is);
            parser.parse();
            doc = parser.getDocument();
            this.setField(doc, new COSString(name), new COSString(value));
            os = new FileOutputStream(out);
            writer = new COSWriter(os);
            writer.write(doc);
        }
        finally {
            is.close();
            doc.close();
            os.close();
            writer.close();
        }
    }

    public static void main(String[] args) {
        FieldsDoc app = new FieldsDoc();
        try {
            if (args.length != 4) {
                app.usage();
            } else {
                app.doIt(args[0], args[1], args[2], args[3]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setField(COSDocument doc, COSString name, COSString value) {
        for (COSObject obj : doc.getObjects()) {
            COSBase fname;
            COSBase subtype;
            COSDictionary dict;
            COSBase type;
            COSBase base = obj.getObject();
            if (!(base instanceof COSDictionary) || (type = (dict = (COSDictionary)base).getItem(COSName.TYPE)) == null || !type.equals(COSName.getPDFName("Annot")) || (subtype = dict.getItem(COSName.getPDFName("Subtype"))) == null || !subtype.equals(COSName.getPDFName("Widget")) || (fname = dict.getItem(COSName.getPDFName("T"))) == null || !fname.equals(name)) continue;
            dict.setItem(COSName.getPDFName("V"), (COSBase)value);
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <input-file> <output-file> <name> <value>");
    }
}

