/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.rmi.multi;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import org.objectweb.carol.util.configuration.TraceCarol;

public class JacORBPRODelegate
implements PortableRemoteObjectDelegate {
    private static final String SUN_JDK14_CLASS = "com.sun.corba.se.internal.javax.rmi.PortableRemoteObject";
    private static final String IBM_JDK14_CLASS = "com.ibm.CORBA.iiop.PortableRemoteObject";
    private static final String SUN_JDK50_CLASS = "com.sun.corba.se.impl.javax.rmi.PortableRemoteObject";
    private static final String DEFAULT_JACORB_CLASS = "org.jacorb.orb.rmi.PortableRemoteObjectDelegateImpl";
    private static final String[] DELEGATE_CLASSES = new String[]{"com.sun.corba.se.internal.javax.rmi.PortableRemoteObject", "com.ibm.CORBA.iiop.PortableRemoteObject", "com.sun.corba.se.impl.javax.rmi.PortableRemoteObject"};
    private static PortableRemoteObjectDelegate delegate = null;

    public void exportObject(Remote obj) throws RemoteException {
        this.getDelegate().exportObject(obj);
    }

    public void unexportObject(Remote obj) throws NoSuchObjectException {
        this.getDelegate().unexportObject(obj);
    }

    public Remote toStub(Remote obj) throws NoSuchObjectException {
        return this.getDelegate().toStub(obj);
    }

    public void connect(Remote target, Remote source) throws RemoteException {
        this.getDelegate().connect(target, source);
    }

    public Object narrow(Object narrowFrom, Class narrowTo) throws ClassCastException {
        return this.getDelegate().narrow(narrowFrom, narrowTo);
    }

    private PortableRemoteObjectDelegate getDelegate() {
        if (delegate != null) {
            return delegate;
        }
        Class<?> clazz = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        boolean classFound = false;
        for (int i = 0; !classFound && i < DELEGATE_CLASSES.length; ++i) {
            String cls = DELEGATE_CLASSES[i];
            if (TraceCarol.isDebugCarol()) {
                TraceCarol.debugCarol("Trying with class '" + cls + "'.");
            }
            try {
                clazz = cl.loadClass(cls);
                if (TraceCarol.isDebugCarol()) {
                    TraceCarol.debugCarol("Class found, Use as prodelegate class : '" + cls + "'.");
                }
                classFound = true;
                continue;
            }
            catch (ClassNotFoundException cnfesun) {
                if (!TraceCarol.isDebugCarol()) continue;
                TraceCarol.debugCarol("Class '" + cls + "' not available.");
            }
        }
        if (!classFound) {
            try {
                clazz = cl.loadClass(DEFAULT_JACORB_CLASS);
            }
            catch (ClassNotFoundException cnfejacorb) {
                throw new IllegalArgumentException("Could not load default class 'org.jacorb.orb.rmi.PortableRemoteObjectDelegateImpl' :" + cnfejacorb.getMessage());
            }
            TraceCarol.infoCarol("Using default Jacorb delegate class and not the JVM class as JVM class was not found. It may fail in some cases.");
        }
        Object o = null;
        try {
            o = clazz.newInstance();
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("Cannot make instance of class : '" + clazz + "' : " + iae.getMessage());
        }
        catch (InstantiationException ie) {
            throw new IllegalArgumentException("Cannot make instance of class : '" + clazz + "' : " + ie.getMessage());
        }
        if (o instanceof PortableRemoteObjectDelegate) {
            delegate = o;
            return delegate;
        }
        throw new IllegalArgumentException("Object '" + o + "' is not an instance of PortableRemoteObjectDelegate");
    }
}

