/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConversationRegistry {
    public static final String INIT_PARAM_CONCURRENCY_LEVEL = "concurrency-level";
    private static final Log LOG = ExoLogger.getLogger((String)ConversationRegistry.class.getName());
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private final ConcurrentHashMap<Object, ConversationState> states;
    private final IdentityRegistry identityRegistry;
    private final ListenerService listenerService;

    public ConversationRegistry(InitParams params, IdentityRegistry identityRegistry, ListenerService listenerService) {
        this(ConversationRegistry.parse(params), identityRegistry, listenerService);
    }

    private static int parse(InitParams ip) {
        try {
            return Integer.valueOf(ip.getValueParam(INIT_PARAM_CONCURRENCY_LEVEL).getValue());
        }
        catch (NullPointerException e) {
            LOG.info((Object)"Parameter concurrency-level was not found in configuration, default 16 will be used.");
            return 16;
        }
        catch (Exception e) {
            LOG.error((Object)"Can't parse parameter concurrency-level", (Throwable)e);
            return 16;
        }
    }

    private ConversationRegistry(int concurrencyLevel, IdentityRegistry identityRegistry, ListenerService listenerService) {
        this.states = new ConcurrentHashMap(concurrencyLevel, 0.75f, concurrencyLevel);
        this.identityRegistry = identityRegistry;
        this.listenerService = listenerService;
    }

    public ConversationState getState(Object key) {
        return this.states.get(key);
    }

    public void register(Object key, ConversationState state) {
        this.states.put(key, state);
        try {
            this.listenerService.broadcast("exo.core.security.ConversationRegistry.register", (Object)this, (Object)state);
        }
        catch (Exception e) {
            LOG.error((Object)"Broadcast message filed ", (Throwable)e);
        }
    }

    public ConversationState unregister(Object key) {
        ConversationState state = this.states.remove(key);
        if (state == null) {
            return null;
        }
        String userId = state.getIdentity().getUserId();
        List<Object> keys = this.getStateKeys(userId);
        if (keys.size() == 0 || keys.size() == 1 && keys.get(0).equals(userId)) {
            this.identityRegistry.unregister(userId);
        }
        try {
            this.listenerService.broadcast("exo.core.security.ConversationRegistry.unregister", (Object)this, (Object)state);
        }
        catch (Exception e) {
            LOG.error((Object)"Broadcast message filed ", (Throwable)e);
        }
        return state;
    }

    public List<Object> getStateKeys(String userId) {
        ArrayList<Object> s = new ArrayList<Object>();
        for (Map.Entry<Object, ConversationState> a : this.states.entrySet()) {
            if (!a.getValue().getIdentity().getUserId().equals(userId)) continue;
            s.add(a.getKey());
        }
        return s;
    }

    void clear() {
        this.states.clear();
    }
}

