/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database;

import java.util.Comparator;

public class DBQueryParameter {
    protected String name;
    protected String value;
    protected Operator operator;
    protected int order = 3;
    public static final int SELECT = 1;
    public static final int WHERE = 3;
    public static final int GROUP = 4;
    public static final int HAVING = 5;
    public static final int ORDER = 6;
    public static final Comparator<DBQueryParameter> PARAMETER_SORT = new Comparator<DBQueryParameter>(){

        @Override
        public int compare(DBQueryParameter param1, DBQueryParameter param2) {
            return param1.order - param2.order;
        }
    };

    protected DBQueryParameter() {
    }

    public DBQueryParameter(String value) {
        this.value = value;
    }

    public DBQueryParameter(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public DBQueryParameter(String name, String value, Operator operator) {
        this.name = name;
        this.value = value;
        this.operator = operator;
    }

    public void build(StringBuilder builder) {
        if (this.order == 3 && builder.indexOf(" WHERE ") < 0) {
            builder.append(" WHERE ");
        }
        builder.append(' ').append(this.name).append(this.operator.toString()).append(this.value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static class Operator {
        public static final Operator AND = new Operator(" AND ");
        public static final Operator OR = new Operator(" OR ");
        public static final Operator LESS_THAN = new Operator(" < ");
        public static final Operator LESS_THAN_AND_EQUALS = new Operator(" <= ");
        public static final Operator GREATER_THAN = new Operator(" > ");
        public static final Operator GREATER_THAN_AND_EQUALS = new Operator(" >= ");
        public static final Operator LIKE = new Operator(" LIKE ");
        public static final Operator IN = new Operator(" IN ");
        public static final Operator IS = new Operator(" IS ");
        public static final Operator EQUALS = new Operator(" = ");
        private String value;

        public Operator(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

