/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.StringReader;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.parsers.AbstractDOMParser;
import org.apache.xerces.util.DOMEntityResolverWrapper;
import org.apache.xerces.util.DOMErrorHandlerWrapper;
import org.apache.xerces.util.ObjectFactory;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMBuilder;
import org.w3c.dom.ls.DOMBuilderFilter;
import org.w3c.dom.ls.DOMEntityResolver;
import org.w3c.dom.ls.DOMInputSource;

public class DOMBuilderImpl
extends AbstractDOMParser
implements DOMBuilder {
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    protected static final String XMLSCHEMA = "http://apache.org/xml/features/validation/schema";
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    protected static final String XML_SCHEMA_VALIDATION = "http://www.w3.org/2001/XMLSchema";
    protected static final String DTD_VALIDATION = "http://www.w3.org/TR/REC-xml";
    protected String fSchemaType = "http://www.w3.org/2001/XMLSchema";
    protected static final boolean DEBUG = false;

    public DOMBuilderImpl(String string, String string2) {
        this((XMLParserConfiguration)ObjectFactory.createObject("org.apache.xerces.xni.parser.XMLParserConfiguration", string));
        this.fSchemaType = string2;
    }

    public DOMBuilderImpl(XMLParserConfiguration xMLParserConfiguration) {
        super(xMLParserConfiguration);
        String[] stringArray = new String[]{"canonical-form", "cdata-sections", "charset-overrides-xml-encoding", "infoset", "namespace-declarations", "supported-mediatypes-only"};
        this.fConfiguration.addRecognizedFeatures(stringArray);
        this.fConfiguration.setFeature("canonical-form", false);
        this.fConfiguration.setFeature("cdata-sections", true);
        this.fConfiguration.setFeature("charset-overrides-xml-encoding", true);
        this.fConfiguration.setFeature("infoset", false);
        this.fConfiguration.setFeature("namespace-declarations", true);
        this.fConfiguration.setFeature("supported-mediatypes-only", false);
        this.fConfiguration.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", false);
    }

    public DOMBuilderImpl(SymbolTable symbolTable) {
        this((XMLParserConfiguration)ObjectFactory.createObject("org.apache.xerces.xni.parser.XMLParserConfiguration", "org.apache.xerces.parsers.StandardParserConfiguration"));
        this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/symbol-table", symbolTable);
    }

    public DOMBuilderImpl(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool) {
        this((XMLParserConfiguration)ObjectFactory.createObject("org.apache.xerces.xni.parser.XMLParserConfiguration", "org.apache.xerces.parsers.StandardParserConfiguration"));
        this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/symbol-table", symbolTable);
        this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/grammar-pool", xMLGrammarPool);
    }

    public void reset() {
        super.reset();
    }

    public DOMEntityResolver getEntityResolver() {
        DOMEntityResolver dOMEntityResolver = null;
        try {
            DOMEntityResolver dOMEntityResolver2 = (DOMEntityResolver)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/entity-resolver");
            if (dOMEntityResolver2 != null && dOMEntityResolver2 instanceof DOMEntityResolverWrapper) {
                dOMEntityResolver = ((DOMEntityResolverWrapper)((Object)dOMEntityResolver2)).getEntityResolver();
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        return dOMEntityResolver;
    }

    public void setEntityResolver(DOMEntityResolver dOMEntityResolver) {
        try {
            this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/entity-resolver", new DOMEntityResolverWrapper(dOMEntityResolver));
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    public DOMErrorHandler getErrorHandler() {
        DOMErrorHandler dOMErrorHandler = null;
        try {
            DOMErrorHandler dOMErrorHandler2 = (DOMErrorHandler)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/error-handler");
            if (dOMErrorHandler2 != null && dOMErrorHandler2 instanceof DOMErrorHandlerWrapper) {
                dOMErrorHandler = ((DOMErrorHandlerWrapper)dOMErrorHandler2).getErrorHandler();
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
        return dOMErrorHandler;
    }

    public void setErrorHandler(DOMErrorHandler dOMErrorHandler) {
        try {
            this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/error-handler", new DOMErrorHandlerWrapper(dOMErrorHandler));
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            // empty catch block
        }
    }

    public DOMBuilderFilter getFilter() {
        throw new DOMException(9, "Not supported");
    }

    public void setFilter(DOMBuilderFilter dOMBuilderFilter) {
        throw new DOMException(9, "Not supported");
    }

    public void setFeature(String string, boolean bl) throws DOMException {
        try {
            if (string.equals("comments")) {
                this.fConfiguration.setFeature("http://apache.org/xml/features/include-comments", bl);
            } else if (string.equals("datatype-normalization")) {
                this.fConfiguration.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", bl);
            } else if (string.equals("entities")) {
                this.fConfiguration.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", bl);
            } else if (string.equals("infoset") || string.equals("supported-mediatypes-only") || string.equals("canonical-form")) {
                if (bl) {
                    throw new DOMException(9, "Feature \"" + string + "\" cannot be set to \"" + bl + "\"");
                }
            } else if (string.equals("namespaces")) {
                this.fConfiguration.setFeature(NAMESPACES, bl);
            } else if (string.equals("cdata-sections") || string.equals("namespace-declarations")) {
                if (!bl) {
                    throw new DOMException(9, "Feature \"" + string + "\" cannot be set to \"" + bl + "\"");
                }
            } else if (string.equals("validate")) {
                this.fConfiguration.setFeature(VALIDATION_FEATURE, bl);
                if (this.fSchemaType == null || this.fSchemaType.equals(XML_SCHEMA_VALIDATION)) {
                    this.fConfiguration.setFeature(XMLSCHEMA, bl);
                }
            } else if (string.equals("validate-if-schema")) {
                this.fConfiguration.setFeature(DYNAMIC_VALIDATION, bl);
            } else if (string.equals("whitespace-in-element-content")) {
                this.fConfiguration.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", bl);
            } else {
                this.fConfiguration.setFeature(string, bl);
            }
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            throw new DOMException(8, "Feature \"" + string + "\" not recognized");
        }
    }

    public boolean canSetFeature(String string, boolean bl) {
        if (string.equals("infoset") || string.equals("supported-mediatypes-only") || string.equals("canonical-form")) {
            return !bl;
        }
        if (string.equals("cdata-sections") || string.equals("namespace-declarations")) {
            return bl;
        }
        return string.equals("charset-overrides-xml-encoding") || string.equals("comments") || string.equals("datatype-normalization") || string.equals("entities") || string.equals("namespaces") || string.equals("validate") || string.equals("validate-if-schema") || string.equals("whitespace-in-element-content");
    }

    public boolean getFeature(String string) throws DOMException {
        if (string.equals("comments")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/include-comments");
        }
        if (string.equals("datatype-normalization")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/validation/schema/normalized-value");
        }
        if (string.equals("entities")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes");
        }
        if (string.equals("namespaces")) {
            return this.fConfiguration.getFeature(NAMESPACES);
        }
        if (string.equals("validate")) {
            return this.fConfiguration.getFeature(VALIDATION_FEATURE);
        }
        if (string.equals("validate-if-schema")) {
            return this.fConfiguration.getFeature(DYNAMIC_VALIDATION);
        }
        if (string.equals("whitespace-in-element-content")) {
            return this.fConfiguration.getFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace");
        }
        if (string.equals("namespace-declarations") || string.equals("cdata-sections") || string.equals("canonical-form") || string.equals("supported-mediatypes-only") || string.equals("infoset") || string.equals("charset-overrides-xml-encoding")) {
            return this.fConfiguration.getFeature(string);
        }
        throw new DOMException(8, "Feature \"" + string + "\" not recognized");
    }

    public Document parseURI(String string) {
        XMLInputSource xMLInputSource = new XMLInputSource(null, string, null);
        this.initGrammarPool();
        try {
            this.parse(xMLInputSource);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getDocument();
    }

    public Document parse(DOMInputSource dOMInputSource) throws Exception {
        XMLInputSource xMLInputSource = this.dom2xmlInputSource(dOMInputSource);
        this.initGrammarPool();
        try {
            this.parse(xMLInputSource);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getDocument();
    }

    protected void initGrammarPool() {
    }

    public void parseWithContext(DOMInputSource dOMInputSource, Node node, short s) throws DOMException {
        throw new DOMException(9, "Not supported");
    }

    XMLInputSource dom2xmlInputSource(DOMInputSource dOMInputSource) {
        XMLInputSource xMLInputSource = null;
        xMLInputSource = dOMInputSource.getStringData() != null ? new XMLInputSource(dOMInputSource.getPublicId(), dOMInputSource.getSystemId(), dOMInputSource.getBaseURI(), new StringReader(dOMInputSource.getStringData()), "UTF-16") : (dOMInputSource.getCharacterStream() != null ? new XMLInputSource(dOMInputSource.getPublicId(), dOMInputSource.getSystemId(), dOMInputSource.getBaseURI(), dOMInputSource.getCharacterStream(), "UTF-16") : (dOMInputSource.getByteStream() != null ? new XMLInputSource(dOMInputSource.getPublicId(), dOMInputSource.getSystemId(), dOMInputSource.getBaseURI(), dOMInputSource.getByteStream(), dOMInputSource.getEncoding()) : new XMLInputSource(dOMInputSource.getPublicId(), dOMInputSource.getSystemId(), dOMInputSource.getBaseURI())));
        return xMLInputSource;
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        super.endDocument(augmentations);
        if (this.fDocumentImpl != null) {
            CoreDocumentImpl coreDocumentImpl = (CoreDocumentImpl)this.fDocument;
            coreDocumentImpl.copyConfigurationProperties(this.fConfiguration);
        }
    }
}

