/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInstantiationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVisitor;

public class BasicComponentParameter
implements Parameter,
Serializable {
    public static final BasicComponentParameter BASIC_DEFAULT = new BasicComponentParameter();
    private Object componentKey;

    public BasicComponentParameter(Object componentKey) {
        this.componentKey = componentKey;
    }

    public BasicComponentParameter() {
    }

    public boolean isResolvable(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        return this.resolveAdapter(container, adapter, expectedType) != null;
    }

    public Object resolveInstance(PicoContainer container, ComponentAdapter adapter, Class expectedType) throws PicoInstantiationException {
        ComponentAdapter componentAdapter = this.resolveAdapter(container, adapter, expectedType);
        if (componentAdapter != null) {
            return container.getComponentInstance(componentAdapter.getComponentKey());
        }
        return null;
    }

    public void verify(PicoContainer container, ComponentAdapter adapter, Class expectedType) throws PicoIntrospectionException {
        ComponentAdapter componentAdapter = this.resolveAdapter(container, adapter, expectedType);
        if (componentAdapter == null) {
            throw new PicoIntrospectionException(String.valueOf(expectedType.getName()) + " is not resolvable");
        }
        componentAdapter.verify(container);
    }

    public void accept(PicoVisitor visitor) {
        visitor.visitParameter(this);
    }

    private ComponentAdapter resolveAdapter(PicoContainer container, ComponentAdapter adapter, Class expectedType) {
        ComponentAdapter result = this.getTargetAdapter(container, expectedType);
        if (result == null) {
            return null;
        }
        if (adapter != null && adapter.getComponentKey().equals(result.getComponentKey())) {
            return null;
        }
        if (!expectedType.isAssignableFrom(result.getComponentImplementation())) {
            if (expectedType.isPrimitive()) {
                try {
                    Field field = result.getComponentImplementation().getField("TYPE");
                    Class type = (Class)field.get(result.getComponentInstance(null));
                    if (expectedType.isAssignableFrom(type)) {
                        return result;
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return null;
        }
        return result;
    }

    private ComponentAdapter getTargetAdapter(PicoContainer container, Class expectedType) {
        if (this.componentKey != null) {
            return container.getComponentAdapter(this.componentKey);
        }
        return container.getComponentAdapterOfType(expectedType);
    }
}

