/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.ns;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import org.objectweb.carol.jndi.ns.AbsRegistry;
import org.objectweb.carol.jndi.ns.NameService;
import org.objectweb.carol.jndi.ns.NameServiceException;
import org.objectweb.carol.rmi.util.PortNumber;
import org.objectweb.carol.util.configuration.TraceCarol;
import org.objectweb.jeremie.binding.moa.UnicastRemoteObject;
import org.objectweb.jeremie.services.registry.LocateRegistry;

public class JeremieRegistry
extends AbsRegistry
implements NameService {
    private static final int DEFAULT_PORT_NUMBER = 12340;
    private Registry registry = null;

    public JeremieRegistry() {
        super(12340);
    }

    public void start() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("JeremieRegistry.start() on port:" + this.getPort());
        }
        if (System.getProperty("carol.server.mode", "false").equalsIgnoreCase("true")) {
            if (this.getConfigProperties() != null) {
                String propertyName = "carol.jeremie.server.port";
                int jeremiePort = PortNumber.strToint(this.getConfigProperties().getProperty(propertyName, "0"), propertyName);
                if (jeremiePort > 0) {
                    TraceCarol.infoCarol("Using Jeremie fixed server port number '" + jeremiePort + "'.");
                    System.setProperty("org.objectweb.jeremie.stub_factories.defaultport", String.valueOf(jeremiePort));
                }
            } else {
                TraceCarol.debugCarol("No properties 'carol.iiop.server.port' defined in carol.properties file.");
            }
        }
        try {
            if (!this.isStarted()) {
                if (this.getPort() >= 0) {
                    this.registry = LocateRegistry.createRegistry((int)this.getPort());
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        public void run() {
                            try {
                                JeremieRegistry.this.stop();
                            }
                            catch (Exception e) {
                                TraceCarol.error("JeremieRegistry ShutdownHook problem", e);
                            }
                        }
                    });
                } else if (TraceCarol.isDebugJndiCarol()) {
                    TraceCarol.debugJndiCarol("Can't start JeremieRegistry, port=" + this.getPort() + " is < 0");
                }
            } else if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("JeremieRegistry is already start on port:" + this.getPort());
            }
        }
        catch (Exception e) {
            throw new NameServiceException("can not start jeremie registry: " + e);
        }
    }

    public void stop() throws NameServiceException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("JeremieRegistry.stop()");
        }
        try {
            if (this.registry != null) {
                UnicastRemoteObject.unexportObject((Remote)this.registry, (boolean)true);
            }
            this.registry = null;
        }
        catch (Exception e) {
            throw new NameServiceException("can not stop jeremie registry: " + e);
        }
    }

    public boolean isStarted() {
        if (this.registry != null) {
            return true;
        }
        try {
            LocateRegistry.getRegistry((int)this.getPort()).list();
        }
        catch (RemoteException re) {
            return false;
        }
        return true;
    }
}

