/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.exoplatform.services.security.MembershipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Identity {
    private String userId;
    private Collection<MembershipEntry> memberships;
    private Subject subject;
    private Collection<String> roles;

    public Identity(String userId) {
        this(userId, new HashSet<MembershipEntry>(), new HashSet<String>());
    }

    public Identity(String userId, Collection<MembershipEntry> memberships) {
        this(userId, memberships, new HashSet<String>());
    }

    public Identity(String userId, Collection<MembershipEntry> memberships, Collection<String> roles) {
        this.userId = userId;
        this.memberships = memberships;
        this.roles = roles;
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean isMemberOf(String group, String membershipType) {
        return this.containsMembership(new MembershipEntry(group, membershipType));
    }

    public boolean isMemberOf(MembershipEntry me) {
        return this.containsMembership(me);
    }

    public boolean isMemberOf(String group) {
        return this.containsMembership(new MembershipEntry(group));
    }

    public Set<String> getGroups() {
        HashSet<String> groups = new HashSet<String>();
        for (MembershipEntry m : this.memberships) {
            groups.add(m.getGroup());
        }
        return groups;
    }

    public void setMemberships(Collection<MembershipEntry> memberships) {
        this.memberships = memberships;
    }

    public Collection<MembershipEntry> getMemberships() {
        return this.memberships;
    }

    public void setRoles(Collection<String> roles) {
        this.roles = roles;
    }

    public Collection<String> getRoles() {
        return this.roles;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    private boolean containsMembership(MembershipEntry checkMe) {
        for (MembershipEntry membership : this.memberships) {
            if (!checkMe.equals(membership)) continue;
            return true;
        }
        return false;
    }
}

