/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.extras;

import java.util.ArrayList;
import org.jibx.runtime.IAliasable;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshaller;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshaller;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.MarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;

public class ObjectArrayMapper
implements IMarshaller,
IUnmarshaller,
IAliasable {
    private static final Object[] DUMMY_ARRAY = new Object[0];
    private String m_uri;
    private int m_index;
    private String m_name;
    private ArrayList m_holder;

    public ObjectArrayMapper() {
        this.m_uri = null;
        this.m_index = 0;
        this.m_name = null;
    }

    public ObjectArrayMapper(String uri, int index, String name) {
        this.m_uri = uri;
        this.m_index = index;
        this.m_name = name;
    }

    public boolean isExtension(int index) {
        return false;
    }

    public void marshal(Object obj, IMarshallingContext ictx) throws JiBXException {
        if (obj == null) {
            if (this.m_name == null) {
                throw new JiBXException("null array not allowed without wrapper");
            }
        } else {
            if (!DUMMY_ARRAY.getClass().isInstance(obj)) {
                throw new JiBXException("Invalid object type for marshaller");
            }
            if (!(ictx instanceof MarshallingContext)) {
                throw new JiBXException("Invalid object type for marshaller");
            }
            MarshallingContext ctx = (MarshallingContext)ictx;
            Object[] array = (Object[])obj;
            if (this.m_name != null) {
                ctx.startTag(this.m_index, this.m_name);
            }
            for (int i = 0; i < array.length; ++i) {
                Object item = array[i];
                if (!(item instanceof IMarshallable)) {
                    if (item == null) {
                        throw new JiBXException("Null value at offset " + i + " not supported");
                    }
                    throw new JiBXException("Array value of type " + item.getClass().getName() + " at offset " + i + " is not marshallable");
                }
                ((IMarshallable)item).marshal((IMarshallingContext)ctx);
            }
            if (this.m_name != null) {
                ctx.endTag(this.m_index, this.m_name);
            }
        }
    }

    public boolean isPresent(IUnmarshallingContext ctx) throws JiBXException {
        return ctx.isAt(this.m_uri, this.m_name);
    }

    public Object unmarshal(Object obj, IUnmarshallingContext ictx) throws JiBXException {
        UnmarshallingContext ctx = (UnmarshallingContext)ictx;
        if (this.m_name != null) {
            if (ctx.isAt(this.m_uri, this.m_name)) {
                ctx.parsePastStartTag(this.m_uri, this.m_name);
            } else {
                return null;
            }
        }
        if (this.m_holder == null) {
            this.m_holder = new ArrayList();
        }
        while (!ctx.isEnd()) {
            Object item = ctx.unmarshalElement();
            this.m_holder.add(item);
        }
        if (this.m_name != null) {
            ctx.parsePastEndTag(this.m_uri, this.m_name);
        }
        Object[] result = this.m_holder.toArray();
        this.m_holder.clear();
        return result;
    }
}

