/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.util.Util;

public class TimedWriter {
    Thread thread = null;
    long timeout = 2000L;
    boolean completed = true;
    Exception write_ex = null;
    Socket sock = null;
    static Log log = LogFactory.getLog(TimedWriter.class);

    void start(InetAddress local, InetAddress remote, int peer_port) {
        this.stop();
        this.thread = new SocketCreator(local, remote, peer_port);
        this.thread.start();
    }

    void start(OutputStream out, byte[] buf) {
        this.stop();
        this.thread = new WriterThread(out, buf);
        this.thread.start();
    }

    void start(OutputStream out, int i) {
        this.stop();
        this.thread = new WriterThread(out, i);
        this.thread.start();
    }

    void stop() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
            try {
                this.thread.join(this.timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(OutputStream out, byte[] buf, long timeout) throws Exception, Timeout, InterruptedException {
        if (out == null || buf == null) {
            log.error((Object)"TimedWriter.write(): output stream or buffer is null, ignoring write");
            return;
        }
        try {
            this.timeout = timeout;
            this.completed = false;
            this.start(out, buf);
            if (this.thread == null) {
                return;
            }
            this.thread.join(timeout);
            if (!this.completed) {
                throw new Timeout();
            }
            if (this.write_ex != null) {
                Exception tmp = this.write_ex;
                this.write_ex = null;
                throw tmp;
            }
        }
        finally {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(OutputStream out, int i, long timeout) throws Exception, Timeout, InterruptedException {
        if (out == null) {
            log.error((Object)"TimedWriter.write(): output stream is null, ignoring write");
            return;
        }
        try {
            this.timeout = timeout;
            this.completed = false;
            this.start(out, i);
            if (this.thread == null) {
                return;
            }
            this.thread.join(timeout);
            if (!this.completed) {
                throw new Timeout();
            }
            if (this.write_ex != null) {
                Exception tmp = this.write_ex;
                this.write_ex = null;
                throw tmp;
            }
        }
        finally {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Socket createSocket(InetAddress local, InetAddress remote, int port, long timeout) throws Exception, Timeout, InterruptedException {
        try {
            this.timeout = timeout;
            this.completed = false;
            this.start(local, remote, port);
            if (this.thread == null) {
                Socket socket = null;
                return socket;
            }
            this.thread.join(timeout);
            if (!this.completed) {
                throw new Timeout();
            }
            if (this.write_ex != null) {
                Exception tmp = this.write_ex;
                this.write_ex = null;
                throw tmp;
            }
            Socket socket = this.sock;
            return socket;
        }
        finally {
            this.stop();
        }
    }

    public static void main(String[] args) {
        TimedWriter w = new TimedWriter();
        InetAddress local = null;
        InetAddress remote = null;
        int port = 0;
        Socket sock = null;
        if (args.length != 3) {
            log.error((Object)"TimedWriter <local host> <remote host> <remote port>");
            return;
        }
        try {
            local = InetAddress.getByName(args[0]);
            remote = InetAddress.getByName(args[1]);
            port = Integer.parseInt(args[2]);
        }
        catch (Exception e) {
            log.error((Object)("Could find host " + remote));
            return;
        }
        while (true) {
            try {
                while ((sock = w.createSocket(local, remote, port, 3000L)) == null) {
                }
                System.out.println("Connection created");
                return;
            }
            catch (Timeout t) {
                log.error((Object)"Timed out creating socket");
                continue;
            }
            catch (Exception io_ex) {
                log.error((Object)"Connection could not be created, retrying");
                Util.sleep(2000L);
                continue;
            }
            break;
        }
    }

    class SocketCreator
    extends Thread {
        InetAddress local = null;
        InetAddress remote = null;
        int peer_port = 0;

        public SocketCreator(InetAddress local, InetAddress remote, int peer_port) {
            this.local = local;
            this.remote = remote;
            this.peer_port = peer_port;
        }

        public void run() {
            TimedWriter.this.completed = false;
            TimedWriter.this.sock = null;
            try {
                TimedWriter.this.sock = new Socket(this.remote, this.peer_port, this.local, 0);
            }
            catch (IOException io_ex) {
                TimedWriter.this.write_ex = io_ex;
            }
            TimedWriter.this.completed = true;
        }
    }

    class WriterThread
    extends Thread {
        DataOutputStream out;
        byte[] buf;
        int i;

        public WriterThread(OutputStream out, byte[] buf) {
            super(Util.getGlobalThreadGroup(), "TimedWriter.WriterThread");
            this.out = null;
            this.buf = null;
            this.i = 0;
            this.out = new DataOutputStream(out);
            this.buf = buf;
        }

        public WriterThread(OutputStream out, int i) {
            super(Util.getGlobalThreadGroup(), "TimedWriter.WriterThread");
            this.out = null;
            this.buf = null;
            this.i = 0;
            this.out = new DataOutputStream(out);
            this.i = i;
        }

        public void run() {
            try {
                if (this.buf != null) {
                    this.out.write(this.buf);
                } else {
                    this.out.writeInt(this.i);
                }
            }
            catch (IOException e) {
                TimedWriter.this.write_ex = e;
            }
            TimedWriter.this.completed = true;
        }
    }

    static class Timeout
    extends Exception {
        Timeout() {
        }

        public String toString() {
            return "TimedWriter.Timeout";
        }
    }
}

