/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.stub;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.jmock.core.CoreMock;
import org.jmock.core.Formatting;
import org.jmock.core.Invocation;
import org.jmock.core.Stub;

public class DefaultResultStub
implements Stub {
    private Map resultValuesByType = new HashMap();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    public DefaultResultStub() {
        this.createDefaultResults();
    }

    public StringBuffer describeTo(StringBuffer stringBuffer) {
        return stringBuffer.append("returns a default value");
    }

    public void addResult(Class clazz, Object object) {
        this.resultValuesByType.put(clazz, object);
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Class<?> clazz = invocation.invokedMethod.getReturnType();
        if (this.resultValuesByType.containsKey(clazz)) {
            return this.resultValuesByType.get(clazz);
        }
        if (clazz.isArray()) {
            return Array.newInstance(clazz.getComponentType(), 0);
        }
        if (clazz.isInterface()) {
            CoreMock coreMock = new CoreMock(clazz, "null" + Formatting.classShortName(clazz));
            coreMock.setDefaultStub(this);
            return coreMock.proxy();
        }
        throw new AssertionFailedError(this.createErrorMessage(invocation));
    }

    public String createErrorMessage(Invocation invocation) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("unexpected result type: ");
        stringBuffer.append(invocation.invokedMethod.getReturnType().toString());
        stringBuffer.append("\n");
        if (this.resultValuesByType.isEmpty()) {
            stringBuffer.append("no result types are registered!");
        } else {
            stringBuffer.append("expected one of: ");
            Iterator iterator = this.resultValuesByType.keySet().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                if (bl) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(((Class)iterator.next()).getName());
                bl = true;
            }
        }
        return stringBuffer.toString();
    }

    protected void createDefaultResults() {
        this.addResult(Boolean.TYPE, Boolean.FALSE);
        this.addResult(Void.TYPE, null);
        this.addResult(Byte.TYPE, new Byte(0));
        this.addResult(Short.TYPE, new Short(0));
        this.addResult(Integer.TYPE, new Integer(0));
        this.addResult(Long.TYPE, new Long(0L));
        this.addResult(Character.TYPE, new Character('\u0000'));
        this.addResult(Float.TYPE, new Float(0.0f));
        this.addResult(Double.TYPE, new Double(0.0));
        this.addResult(class$java$lang$Boolean == null ? (class$java$lang$Boolean = DefaultResultStub.class$("java.lang.Boolean")) : class$java$lang$Boolean, Boolean.FALSE);
        this.addResult(class$java$lang$Byte == null ? (class$java$lang$Byte = DefaultResultStub.class$("java.lang.Byte")) : class$java$lang$Byte, new Byte(0));
        this.addResult(class$java$lang$Short == null ? (class$java$lang$Short = DefaultResultStub.class$("java.lang.Short")) : class$java$lang$Short, new Short(0));
        this.addResult(class$java$lang$Integer == null ? (class$java$lang$Integer = DefaultResultStub.class$("java.lang.Integer")) : class$java$lang$Integer, new Integer(0));
        this.addResult(class$java$lang$Long == null ? (class$java$lang$Long = DefaultResultStub.class$("java.lang.Long")) : class$java$lang$Long, new Long(0L));
        this.addResult(class$java$lang$Character == null ? (class$java$lang$Character = DefaultResultStub.class$("java.lang.Character")) : class$java$lang$Character, new Character('\u0000'));
        this.addResult(class$java$lang$Float == null ? (class$java$lang$Float = DefaultResultStub.class$("java.lang.Float")) : class$java$lang$Float, new Float(0.0f));
        this.addResult(class$java$lang$Double == null ? (class$java$lang$Double = DefaultResultStub.class$("java.lang.Double")) : class$java$lang$Double, new Double(0.0));
        this.addResult(class$java$lang$String == null ? (class$java$lang$String = DefaultResultStub.class$("java.lang.String")) : class$java$lang$String, "");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

