/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml;

import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.xppdom.Xpp3Dom;
import java.util.LinkedList;

public class XppDomReader
implements HierarchicalStreamReader {
    private Xpp3Dom current;
    private LinkedList pointers = new LinkedList();

    public XppDomReader(Xpp3Dom xpp3Dom) {
        this.current = xpp3Dom;
        this.pointers.addLast(new Pointer());
    }

    public String getNodeName() {
        return this.current.getName();
    }

    public String getValue() {
        String string = null;
        try {
            string = this.current.getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string == null ? "" : string;
    }

    public String getAttribute(String string) {
        String string2 = null;
        try {
            string2 = this.current.getAttribute(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public Object peekUnderlyingNode() {
        return this.current;
    }

    public boolean hasMoreChildren() {
        Pointer pointer = (Pointer)this.pointers.getLast();
        return pointer.v < this.current.getChildCount();
    }

    public void moveUp() {
        this.current = this.current.getParent();
        this.pointers.removeLast();
    }

    public void moveDown() {
        Pointer pointer = (Pointer)this.pointers.getLast();
        this.pointers.addLast(new Pointer());
        this.current = this.current.getChild(pointer.v);
        ++pointer.v;
    }

    public void appendErrors(ErrorWriter errorWriter) {
    }

    private class Pointer {
        public int v;

        private Pointer() {
        }
    }
}

