/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.ttf;

import java.io.EOFException;
import java.io.IOException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.pdfbox.pdmodel.common.PDStream;

public abstract class TTFDataStream {
    public float read32Fixed() throws IOException {
        float retval = 0.0f;
        retval = this.readSignedShort();
        return retval += (float)(this.readUnsignedShort() / 65536);
    }

    public String readString(int length) throws IOException {
        return this.readString(length, "ISO-8859-1");
    }

    public String readString(int length, String charset) throws IOException {
        byte[] buffer = this.read(length);
        return new String(buffer, charset);
    }

    public abstract int read() throws IOException;

    public abstract long readLong() throws IOException;

    public int readSignedByte() throws IOException {
        int signedByte = this.read();
        return signedByte < 127 ? signedByte : signedByte - 256;
    }

    public long readUnsignedInt() throws IOException {
        long byte1 = this.read();
        long byte2 = this.read();
        long byte3 = this.read();
        long byte4 = this.read();
        if (byte4 < 0L) {
            throw new EOFException();
        }
        return (byte1 << 24) + (byte2 << 16) + (byte3 << 8) + (byte4 << 0);
    }

    public abstract int readUnsignedShort() throws IOException;

    public int[] readUnsignedShortArray(int length) throws IOException {
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = this.readUnsignedShort();
        }
        return array;
    }

    public abstract short readSignedShort() throws IOException;

    public Calendar readInternationalDate() throws IOException {
        long secondsSince1904 = this.readLong();
        GregorianCalendar cal = new GregorianCalendar(1904, 0, 1);
        long millisFor1904 = cal.getTimeInMillis();
        cal.setTimeInMillis(millisFor1904 += secondsSince1904 * 1000L);
        return cal;
    }

    public abstract void close() throws IOException;

    public abstract void seek(long var1) throws IOException;

    public byte[] read(int numberOfBytes) throws IOException {
        byte[] data = new byte[numberOfBytes];
        int amountRead = 0;
        for (int totalAmountRead = 0; (amountRead = this.read(data, totalAmountRead, numberOfBytes - totalAmountRead)) != -1 && totalAmountRead < numberOfBytes; totalAmountRead += amountRead) {
        }
        return data;
    }

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public abstract long getCurrentPosition() throws IOException;

    public abstract PDStream getPDStream();
}

