/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.loader.custom.SQLQueryReturn;
import org.hibernate.loader.custom.SQLQueryScalarReturn;
import org.hibernate.util.ArrayHelper;

public class NativeSQLQuerySpecification {
    private final String queryString;
    private final SQLQueryReturn[] sqlQueryReturns;
    private final SQLQueryScalarReturn[] sqlQueryScalarReturns;
    private final Set querySpaces;
    private final int hashCode;

    public NativeSQLQuerySpecification(String queryString, SQLQueryReturn[] sqlQueryReturns, SQLQueryScalarReturn[] sqlQueryScalarReturns, Collection querySpaces) {
        this.queryString = queryString;
        this.sqlQueryReturns = sqlQueryReturns;
        this.sqlQueryScalarReturns = sqlQueryScalarReturns;
        if (querySpaces == null) {
            this.querySpaces = Collections.EMPTY_SET;
        } else {
            HashSet tmp = new HashSet();
            tmp.addAll(querySpaces);
            this.querySpaces = Collections.unmodifiableSet(tmp);
        }
        int hashCode = queryString.hashCode();
        hashCode = 29 * hashCode + ((Object)this.querySpaces).hashCode();
        if (this.sqlQueryReturns != null) {
            hashCode = 29 * hashCode + ((Object)ArrayHelper.toList(this.sqlQueryReturns)).hashCode();
        }
        if (this.sqlQueryScalarReturns != null) {
            hashCode = 29 * hashCode + ((Object)ArrayHelper.toList(this.sqlQueryScalarReturns)).hashCode();
        }
        this.hashCode = hashCode;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public SQLQueryReturn[] getSqlQueryReturns() {
        return this.sqlQueryReturns;
    }

    public SQLQueryScalarReturn[] getSqlQueryScalarReturns() {
        return this.sqlQueryScalarReturns;
    }

    public Set getQuerySpaces() {
        return this.querySpaces;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NativeSQLQuerySpecification that = (NativeSQLQuerySpecification)o;
        return ((Object)this.querySpaces).equals(that.querySpaces) && this.queryString.equals(that.queryString) && Arrays.equals(this.sqlQueryReturns, that.sqlQueryReturns) && Arrays.equals(this.sqlQueryScalarReturns, that.sqlQueryScalarReturns);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

