/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.BitSet;
import org.exoplatform.services.jcr.impl.core.query.lucene.ForeignSegmentDocId;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndexReader;

abstract class DocId {
    static final DocId NULL = new DocId(){

        final int getDocumentNumber(MultiIndexReader reader) {
            return -1;
        }

        final DocId applyOffset(int offset) {
            return this;
        }

        final boolean isValid(BitSet deleted) {
            return true;
        }
    };

    DocId() {
    }

    abstract int getDocumentNumber(MultiIndexReader var1) throws IOException;

    abstract DocId applyOffset(int var1);

    abstract boolean isValid(BitSet var1);

    static DocId create(int docNumber) {
        return new PlainDocId(docNumber);
    }

    static DocId create(String uuid) {
        return new UUIDDocId(uuid);
    }

    private static final class UUIDDocId
    extends DocId {
        private final String identifier;
        private ForeignSegmentDocId doc;

        UUIDDocId(String identifier) {
            this.identifier = identifier;
        }

        int getDocumentNumber(MultiIndexReader reader) throws IOException {
            int realDoc = -1;
            ForeignSegmentDocId segDocId = this.doc;
            if (segDocId != null) {
                realDoc = reader.getDocumentNumber(segDocId);
            }
            if (realDoc == -1 && (segDocId = reader.createDocId(this.identifier)) != null) {
                realDoc = reader.getDocumentNumber(segDocId);
                this.doc = segDocId;
            }
            return realDoc;
        }

        DocId applyOffset(int offset) {
            return this;
        }

        boolean isValid(BitSet deleted) {
            return true;
        }

        public String toString() {
            return this.identifier;
        }
    }

    private static final class PlainDocId
    extends DocId {
        private final int docNumber;

        PlainDocId(int docNumber) {
            this.docNumber = docNumber;
        }

        int getDocumentNumber(MultiIndexReader reader) {
            return this.docNumber;
        }

        DocId applyOffset(int offset) {
            return new PlainDocId(this.docNumber + offset);
        }

        boolean isValid(BitSet deleted) {
            return !deleted.get(this.docNumber);
        }

        public String toString() {
            return "PlainDocId(" + this.docNumber + ")";
        }
    }
}

