/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.spell.SuggestWordQueue;
import org.apache.lucene.search.spell.TRStringDistance;
import org.apache.lucene.store.Directory;

public class SpellChecker {
    public static final String F_WORD = "word";
    Directory spellIndex;
    private float bStart = 2.0f;
    private float bEnd = 1.0f;
    private IndexReader reader;
    private IndexSearcher searcher;
    private float minScore = 0.5f;

    public SpellChecker(Directory spellIndex) throws IOException {
        this.setSpellIndex(spellIndex);
    }

    public void setSpellIndex(Directory spellIndex) throws IOException {
        this.spellIndex = spellIndex;
        if (!IndexReader.indexExists((Directory)spellIndex)) {
            IndexWriter writer = new IndexWriter(spellIndex, null, true);
            writer.close();
        }
        if (this.searcher != null) {
            this.searcher.close();
        }
        this.searcher = new IndexSearcher(this.spellIndex);
    }

    public void setAccuracy(float minScore) {
        this.minScore = minScore;
    }

    public String[] suggestSimilar(String word, int numSug) throws IOException {
        return this.suggestSimilar(word, numSug, null, null, false);
    }

    public String[] suggestSimilar(String word, int numSug, IndexReader ir, String field, boolean morePopular) throws IOException {
        int goalFreq;
        float min = this.minScore;
        TRStringDistance sd = new TRStringDistance(word);
        int lengthWord = word.length();
        int n = goalFreq = morePopular && ir != null ? ir.docFreq(new Term(field, word)) : 0;
        if (!morePopular && goalFreq > 0) {
            return new String[]{word};
        }
        BooleanQuery query = new BooleanQuery();
        for (int ng = this.getMin(lengthWord); ng <= this.getMax(lengthWord); ++ng) {
            String key = "gram" + ng;
            String[] grams = SpellChecker.formGrams(word, ng);
            if (grams.length == 0) continue;
            if (this.bStart > 0.0f) {
                SpellChecker.add(query, "start" + ng, grams[0], this.bStart);
            }
            if (this.bEnd > 0.0f) {
                SpellChecker.add(query, "end" + ng, grams[grams.length - 1], this.bEnd);
            }
            for (int i = 0; i < grams.length; ++i) {
                SpellChecker.add(query, key, grams[i]);
            }
        }
        Hits hits = this.searcher.search((Query)query);
        SuggestWordQueue sugQueue = new SuggestWordQueue(numSug);
        int stop = Math.min(hits.length(), 10 * numSug);
        SuggestWord sugWord = new SuggestWord();
        for (int i = 0; i < stop; ++i) {
            sugWord.string = hits.doc(i).get(F_WORD);
            if (sugWord.string.equals(word)) continue;
            sugWord.score = 1.0f - (float)sd.getDistance(sugWord.string) / (float)Math.min(sugWord.string.length(), lengthWord);
            if (sugWord.score < min) continue;
            if (ir != null) {
                sugWord.freq = ir.docFreq(new Term(field, sugWord.string));
                if (morePopular && goalFreq > sugWord.freq || sugWord.freq < 1) continue;
            }
            sugQueue.insert(sugWord);
            if (sugQueue.size() == numSug) {
                min = ((SuggestWord)sugQueue.top()).score;
            }
            sugWord = new SuggestWord();
        }
        String[] list = new String[sugQueue.size()];
        for (int i = sugQueue.size() - 1; i >= 0; --i) {
            list[i] = ((SuggestWord)sugQueue.pop()).string;
        }
        return list;
    }

    private static void add(BooleanQuery q, String name, String value, float boost) {
        TermQuery tq = new TermQuery(new Term(name, value));
        tq.setBoost(boost);
        q.add(new BooleanClause((Query)tq, BooleanClause.Occur.SHOULD));
    }

    private static void add(BooleanQuery q, String name, String value) {
        q.add(new BooleanClause((Query)new TermQuery(new Term(name, value)), BooleanClause.Occur.SHOULD));
    }

    private static String[] formGrams(String text, int ng) {
        int len = text.length();
        String[] res = new String[len - ng + 1];
        for (int i = 0; i < len - ng + 1; ++i) {
            res[i] = text.substring(i, i + ng);
        }
        return res;
    }

    public void clearIndex() throws IOException {
        IndexReader.unlock((Directory)this.spellIndex);
        IndexWriter writer = new IndexWriter(this.spellIndex, null, true);
        writer.close();
    }

    public boolean exist(String word) throws IOException {
        if (this.reader == null) {
            this.reader = IndexReader.open((Directory)this.spellIndex);
        }
        return this.reader.docFreq(new Term(F_WORD, word)) > 0;
    }

    public void indexDictionary(Dictionary dict) throws IOException {
        IndexReader.unlock((Directory)this.spellIndex);
        IndexWriter writer = new IndexWriter(this.spellIndex, (Analyzer)new WhitespaceAnalyzer(), !IndexReader.indexExists((Directory)this.spellIndex));
        writer.setMergeFactor(300);
        writer.setMaxBufferedDocs(150);
        Iterator iter = dict.getWordsIterator();
        while (iter.hasNext()) {
            String word = (String)iter.next();
            int len = word.length();
            if (len < 3 || this.exist(word)) continue;
            Document doc = SpellChecker.createDocument(word, this.getMin(len), this.getMax(len));
            writer.addDocument(doc);
        }
        writer.optimize();
        writer.close();
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        this.searcher.close();
        this.searcher = new IndexSearcher(this.spellIndex);
    }

    private int getMin(int l) {
        if (l > 5) {
            return 3;
        }
        if (l == 5) {
            return 2;
        }
        return 1;
    }

    private int getMax(int l) {
        if (l > 5) {
            return 4;
        }
        if (l == 5) {
            return 3;
        }
        return 2;
    }

    private static Document createDocument(String text, int ng1, int ng2) {
        Document doc = new Document();
        doc.add((Fieldable)new Field(F_WORD, text, Field.Store.YES, Field.Index.UN_TOKENIZED));
        SpellChecker.addGram(text, doc, ng1, ng2);
        return doc;
    }

    private static void addGram(String text, Document doc, int ng1, int ng2) {
        int len = text.length();
        for (int ng = ng1; ng <= ng2; ++ng) {
            String key = "gram" + ng;
            String end = null;
            for (int i = 0; i < len - ng + 1; ++i) {
                String gram = text.substring(i, i + ng);
                doc.add((Fieldable)new Field(key, gram, Field.Store.NO, Field.Index.UN_TOKENIZED));
                if (i == 0) {
                    doc.add((Fieldable)new Field("start" + ng, gram, Field.Store.NO, Field.Index.UN_TOKENIZED));
                }
                end = gram;
            }
            if (end == null) continue;
            doc.add((Fieldable)new Field("end" + ng, end, Field.Store.NO, Field.Index.UN_TOKENIZED));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        finally {
            super.finalize();
        }
    }
}

