/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.helpers;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.SimpleCredentials;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.impl.core.SessionImpl;

public class QueryNodeLoader {
    private static final int NUMBER_OF_NODES = 10;

    public static void main(String[] args) {
        ManageableRepository repository = null;
        try {
            StandaloneContainer.addConfigurationPath((String)"../config/test-configuration-benchmark.xml");
            StandaloneContainer container = StandaloneContainer.getInstance();
            if (System.getProperty("java.security.auth.login.config") == null) {
                System.setProperty("java.security.auth.login.config", Thread.currentThread().getContextClassLoader().getResource("login.conf").toString());
            }
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            repository = repositoryService.getCurrentRepository();
            SimpleCredentials credentials = new SimpleCredentials("admin", "admin".toCharArray());
            SessionImpl session = (SessionImpl)repository.login((Credentials)credentials, "collaboration");
            Node rootNode = session.getRootNode().getNode("download").getNode("node0").getNode("node1").getNode("node2");
            for (int i = 0; i < 10; ++i) {
                Node nodeToAdd = rootNode.addNode("query-0-1-2-" + i + ".html", "nt:file");
                nodeToAdd.addMixin("dc:elementSet");
                nodeToAdd.setProperty("dc:title", new String[]{"Exoplatform"});
                Node contentNodeOfNodeToAdd = nodeToAdd.addNode("jcr:content", "nt:resource");
                contentNodeOfNodeToAdd.setProperty("jcr:data", (InputStream)new FileInputStream("../resources/query-0-1-2-" + i + ".html"));
                contentNodeOfNodeToAdd.setProperty("jcr:mimeType", "text/html");
                contentNodeOfNodeToAdd.setProperty("jcr:lastModified", Calendar.getInstance());
                session.save();
            }
            session.save();
            System.out.println("===Nodes for query tests loaded successfuly");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

