/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.registryservice;

import com.sun.japex.TestCase;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.security.ConversationState;

public abstract class AbstractRegistryServiceTest
extends JCRTestBase {
    protected StandaloneContainer container;
    protected RegistryService registryService;
    protected SessionProvider sessionProvider;
    private List<String> users = new ArrayList<String>();
    private int iteration = 0;
    protected int sumIterations = 0;
    protected static final String GENERIC_ENTRY = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><node-navigation><owner-type>portal</owner-type><owner-id>portalone</owner-id><access-permissions>*:/guest</access-permissions><page-nodes><node><uri>portalone::home</uri><name>home</name><label>Home</label><page-reference>portal::portalone::content</page-reference></node></page-nodes></node-navigation>";

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        super.doPrepare(tc, context);
        this.container = StandaloneContainer.getInstance();
        this.registryService = (RegistryService)this.container.getComponentInstanceOfType(RegistryService.class);
        this.sessionProvider = new SessionProvider(ConversationState.getCurrent());
        if (tc.hasParam("japex.runIterations") && tc.getIntParam("japex.runIterations") > 0) {
            this.sumIterations += tc.getIntParam("japex.runIterations");
        }
        if (tc.hasParam("japex.warmupIterations") && tc.getIntParam("japex.warmupIterations") > 0) {
            this.sumIterations += tc.getIntParam("japex.warmupIterations");
        }
        this.createContent(tc, context);
    }

    protected void createContent(TestCase tc, JCRTestContext context) throws Exception {
        RegistryEntry registryEntry = RegistryEntry.parse((byte[])GENERIC_ENTRY.getBytes());
        for (int i = 0; i <= this.sumIterations; ++i) {
            String name = context.generateUniqueName("username");
            this.addUser(name);
            this.registryService.createEntry(this.sessionProvider, "exo:users/" + name, registryEntry);
        }
    }

    public String nextUser() {
        return this.users.get(this.iteration++);
    }

    public void addUser(String name) {
        this.users.add(name);
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        super.doFinish(tc, context);
        this.registryService.getRegistry(this.sessionProvider).getNode().remove();
        context.getSession().save();
    }
}

