/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.organization.usecases;

import com.sun.japex.TestCase;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.jcr.benchmark.organization.AbstractOrganizationTest;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;

public class CreateNewUserTest
extends AbstractOrganizationTest {
    private List<User> users;

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        super.doPrepare(tc, context);
        this.users = new ArrayList<User>();
    }

    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        Date date = new Date();
        User user = this.uHandler.createUserInstance(context.generateUniqueName("User"));
        user.setEmail("user@localhost");
        user.setFirstName("FirstName");
        user.setLastName("LastName");
        user.setPassword("password");
        user.setLastLoginTime(date);
        user.setCreatedDate(date);
        this.users.add(user);
        this.uHandler.createUser(user, false);
        UserProfile up = this.upHandler.createUserProfileInstance();
        up.setUserName(user.getUserName());
        this.upHandler.saveUserProfile(up, false);
        Group group = this.gHandler.findGroupById("/platform/users");
        MembershipType mt = this.mtHandler.findMembershipType("member");
        this.mHandler.linkMembership(user, group, mt, false);
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        for (User user : this.users) {
            this.uHandler.removeUser(user.getUserName(), false);
        }
        super.doFinish(tc, context);
    }
}

