/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.ext.asyncrep;

import com.sun.japex.TestCase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.exoplatform.jcr.benchmark.ext.asyncrep.AsyncTestContext;
import org.exoplatform.services.log.ExoLogger;

public abstract class AsyncTestBase {
    protected static Log log = ExoLogger.getLogger((String)"jcr.benchmark.async");
    public final int COUNT_I = 50;
    public final int COUNT_J = 5;
    public File content;
    public int sc;
    public int fc;

    public void doPrepare(TestCase tc, AsyncTestContext context) throws Exception {
        String size = tc.getParam("ext.fileSizeInKb");
        int fileSize = size != null ? Integer.parseInt(size) : 102400;
        this.content = AsyncTestBase.createBLOBfile(fileSize);
        String si = tc.getParam("ext.savesCount");
        this.sc = si != null ? Integer.parseInt(si) : 50;
        String sj = tc.getParam("ext.filePerSaveCount");
        this.fc = sj != null ? Integer.parseInt(sj) : 5;
    }

    public void doFinish(TestCase tc, AsyncTestContext context) throws Exception {
        this.content.delete();
    }

    public abstract void doRun(TestCase var1, AsyncTestContext var2) throws Exception;

    public static File createBLOBfile(int sizeKb) throws IOException {
        byte[] data = new byte[1024];
        File testFile = File.createTempFile("asyncBenchmark", ".tmp");
        FileOutputStream tempOut = new FileOutputStream(testFile);
        Random random = new Random();
        for (int i = 0; i < sizeKb; ++i) {
            random.nextBytes(data);
            tempOut.write(data);
        }
        tempOut.close();
        testFile.deleteOnExit();
        log.info((Object)("Temp file created: " + testFile.getAbsolutePath() + " size: " + testFile.length()));
        return testFile;
    }
}

