/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.ext.asyncrep;

import com.sun.japex.TestCase;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.jcr.benchmark.ext.asyncrep.AsyncTestContext;
import org.exoplatform.jcr.benchmark.ext.asyncrep.ConflictSynchronizeTest;
import org.exoplatform.services.jcr.ext.replication.async.AsyncReplication;

public class ConflictSynchronizeAndDeleteTest
extends ConflictSynchronizeTest {
    public void doRun(TestCase tc, AsyncTestContext context) throws Exception {
        super.doRun(tc, context);
        Session s = context.getSession();
        log.info((Object)"Start Delete");
        String pr = tc.getParam("ext.nodePriority");
        if (pr.equalsIgnoreCase("high")) {
            for (int i = 0; i < this.sc / 2; ++i) {
                for (int j = 0; j < this.fc / 2; ++j) {
                    Node nodeToAdd = this.root.addNode("node_secadd_" + i + "_" + j, "nt:file");
                    Node contentNodeOfNodeToAdd = nodeToAdd.addNode("jcr:content", "nt:resource");
                    contentNodeOfNodeToAdd.setProperty("jcr:data", (InputStream)new FileInputStream(this.content));
                    contentNodeOfNodeToAdd.setProperty("jcr:mimeType", "plain/text");
                    contentNodeOfNodeToAdd.setProperty("jcr:lastModified", Calendar.getInstance());
                }
                s.save();
                log.info((Object)(i + " log saved"));
            }
        } else if (pr.equalsIgnoreCase("low")) {
            this.root = s.getRootNode().getNode("conflictFolder");
            this.root.remove();
            s.save();
        } else {
            throw new Exception("Invalid parameter ext.nodePriority [" + pr + "]");
        }
        AsyncReplication rep = context.getReplicationServer();
        rep.synchronize();
        log.info((Object)"Synchronize DELETE started.");
        while (rep.isActive()) {
            Thread.sleep(3000L);
        }
        log.info((Object)"Synchronization DELETE done");
    }

    public void doFinish(TestCase tc, AsyncTestContext context) throws Exception {
        super.doFinish(tc, context);
    }
}

