/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.jcrapi.session;

import com.sun.japex.TestCase;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;

public abstract class AbstractGetSessionTest
extends JCRTestBase {
    private List<Session> sessions = new ArrayList<Session>();
    private List<String> parentNames = new ArrayList<String>();
    private Node testRoot = null;

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        int i;
        int runIterations = tc.getIntParam("japex.runIterations");
        this.testRoot = context.getSession().getRootNode().addNode(context.generateUniqueName("testRoot"));
        context.getSession().save();
        String parentName = "";
        for (i = 0; i < runIterations; ++i) {
            if (i % 100 == 0) {
                parentName = this.testRoot.addNode(context.generateUniqueName("testParent")).getPath();
                context.getSession().save();
            }
            this.parentNames.add(parentName);
        }
        for (i = 0; i < runIterations; ++i) {
            Session session = context.getSession().getRepository().login();
            Node parentNode = (Node)session.getItem(this.parentNames.remove(0));
            parentNode.addNode(context.generateUniqueName("testNode"));
            this.sessions.add(session);
        }
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        this.testRoot.remove();
        context.getSession().save();
        this.sessions.clear();
        this.parentNames.clear();
    }

    protected Session nextSession() {
        return this.sessions.remove(0);
    }
}

