/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.organization;

import com.sun.japex.TestCase;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.jcr.benchmark.organization.AbstractOrganizationTest;
import org.exoplatform.services.organization.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUserTest
extends AbstractOrganizationTest {
    private List<User> users;
    private int index = 0;

    @Override
    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        super.doPrepare(tc, context);
        this.users = new ArrayList<User>();
        for (int i = 0; i < tc.getIntParam("japex.runIterations"); ++i) {
            User user = this.uHandler.createUserInstance(context.generateUniqueName("UserName"));
            user.setFirstName(context.generateUniqueName("First"));
            user.setLastName(context.generateUniqueName("Last"));
            user.setPassword(context.generateUniqueName("Password"));
            user.setEmail(context.generateUniqueName("Eemail"));
            this.users.add(user);
        }
    }

    protected void createContent() throws Exception {
        for (User user : this.users) {
            this.uHandler.createUser(user, false);
        }
        this.users.clear();
        List allUsers = this.uHandler.getUserPageList(10).getAll();
        for (int i = 0; i < allUsers.size(); ++i) {
            if (!((User)allUsers.get(i)).getUserName().startsWith("UserName")) continue;
            this.users.add((User)allUsers.get(i));
        }
    }

    protected List<User> getUsers() {
        return this.users;
    }

    protected User nextUser() {
        return this.users.get(this.index++);
    }

    @Override
    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        for (User user : this.users) {
            String name = user.getUserName();
            if ((user = this.uHandler.findUserByName(name)) == null) continue;
            this.uHandler.removeUser(name, false);
        }
        this.users.clear();
        this.users = null;
        super.doFinish(tc, context);
    }
}

