/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases.namespace;

import com.sun.japex.TestCase;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.NamespaceException;
import org.apache.commons.logging.Log;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.log.ExoLogger;

public abstract class AbstractNamespaceTest
extends JCRTestBase {
    private static final Log LOG = ExoLogger.getLogger(AbstractNamespaceTest.class);
    protected NamespaceRegistryImpl namespaceRegistry;
    protected List<String> namespaces = new ArrayList<String>();
    protected int iteration = 0;
    protected int runIterations;

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        super.doPrepare(tc, context);
        this.namespaceRegistry = (NamespaceRegistryImpl)context.getSession().getWorkspace().getNamespaceRegistry();
        if (tc.hasParam("japex.runIterations")) {
            this.runIterations = tc.getIntParam("japex.runIterations");
        }
        this.prepare(tc, context);
    }

    protected String nextNamespace() {
        return this.namespaces.get(this.iteration++);
    }

    public void doFinish(TestCase arg0, JCRTestContext arg1) throws Exception {
        super.doFinish(arg0, arg1);
        for (String ns : this.namespaces) {
            try {
                this.namespaceRegistry.getNamespaceURIByPrefix(ns);
                this.namespaceRegistry.unregisterNamespace(ns);
            }
            catch (NamespaceException e) {}
        }
        this.namespaces.clear();
    }

    public abstract void prepare(TestCase var1, JCRTestContext var2) throws Exception;
}

