/***************************************************************************
 * Copyright 2001-2008 The eXo Platform SAS          All rights reserved.  *
 * Please look at license.txt in info directory for more license detail.   *
 **************************************************************************/
package org.exoplatform.jcr.benchmark.jcrapi.lock;

import javax.jcr.Node;

import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.jcr.benchmark.jcrapi.AbstractGetItemTest;

import com.sun.japex.TestCase;

/**
 * Created by The eXo Platform SAS
 * 
 * @author Vitaliy Obmanyuk <br>
 */

public class NodeUnlockTest extends AbstractGetItemTest {

  @Override
  protected void createContent(Node parent, TestCase tc, JCRTestContext context) throws Exception {
    String lockNodeName = context.generateUniqueName("lockNode");
    Node lockNode = parent.addNode(lockNodeName);
    lockNode.addMixin("mix:lockable");
    context.getSession().save();
    lockNode.lock(true, true);
    addNode(lockNode);
  }

  @Override
  public void doRun(TestCase tc, JCRTestContext context) throws Exception {
    nextNode().unlock();
  }

}
