/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.organization;

import com.sun.japex.TestCase;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.jcr.benchmark.organization.AbstractOrganizationTest;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;

public abstract class AbstractUserProfileTest
extends AbstractOrganizationTest {
    private List<User> users;
    private List<UserProfile> userProfiles;
    private int indexUser = 0;
    private int indexUserProfile = 0;

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        super.doPrepare(tc, context);
        this.userProfiles = new ArrayList<UserProfile>();
        this.users = new ArrayList<User>();
        for (int i = 0; i < tc.getIntParam("japex.runIterations"); ++i) {
            User user = this.uHandler.createUserInstance(context.generateUniqueName("UserName"));
            user.setFirstName(context.generateUniqueName("First"));
            user.setLastName(context.generateUniqueName("Last"));
            user.setPassword(context.generateUniqueName("Password"));
            user.setEmail(context.generateUniqueName("Eemail"));
            this.users.add(user);
            UserProfile userProfile = this.upHandler.createUserProfileInstance(user.getUserName());
            userProfile.setAttribute("attr1", "value1");
            userProfile.setAttribute("attr2", "value2");
            userProfile.setAttribute("attr3", "value3");
            userProfile.setAttribute("attr4", "value4");
            userProfile.setAttribute("attr5", "value5");
            userProfile.setAttribute("attr6", "value6");
            userProfile.setAttribute("attr7", "value7");
            userProfile.setAttribute("attr8", "value8");
            userProfile.setAttribute("attr9", "value9");
            userProfile.setAttribute("attr10", "value10");
            this.userProfiles.add(userProfile);
        }
    }

    protected void createContent() throws Exception {
        for (User user : this.users) {
            this.uHandler.createUser(user, false);
        }
        for (UserProfile userProfile : this.userProfiles) {
            this.upHandler.saveUserProfile(userProfile, false);
        }
    }

    protected UserProfile nextUserProfile() {
        return this.userProfiles.get(this.indexUserProfile++);
    }

    protected UserProfile nextUser() {
        return this.userProfiles.get(this.indexUser++);
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        for (User user : this.users) {
            String name = user.getUserName();
            if ((user = this.uHandler.findUserByName(name)) == null) continue;
            this.uHandler.removeUser(name, false);
        }
        this.users.clear();
        this.users = null;
        this.userProfiles.clear();
        this.userProfiles = null;
        super.doFinish(tc, context);
    }
}

