/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.jcrapi.version;

import com.sun.japex.TestCase;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.version.Version;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.jcr.benchmark.jcrapi.AbstractGetItemTest;

public class NodeRestoreToRelPathTest
extends AbstractGetItemTest {
    private List<Version> versions = new ArrayList<Version>();
    private List<String> names = new ArrayList<String>();

    protected void createContent(Node parent, TestCase tc, JCRTestContext context) throws Exception {
        Node vnode = parent.addNode(context.generateUniqueName("versionableNode"));
        vnode.addMixin("mix:versionable");
        parent.save();
        vnode.checkin();
        vnode.checkout();
        vnode.setProperty("Property", "property of subnode");
        vnode.save();
        this.versions.add(vnode.checkin());
        vnode.checkout();
        vnode.setProperty("Property", "property of subnode, v.3");
        vnode.save();
        vnode.checkin();
        vnode.checkout();
        this.addNode(vnode);
        Node rnode = parent.addNode(context.generateUniqueName("restoredNode"));
        parent.save();
        this.names.add("../" + rnode.getName() + "/" + vnode.getName() + "_restored");
    }

    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        int iter = this.getCurrentIteration();
        String relPath = this.names.get(iter);
        Node n = this.nextNode();
        n.restore(this.versions.get(iter), relPath, true);
    }
}

