/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.aws.storage.sdb;

import com.amazonaws.sdb.AmazonSimpleDB;
import com.amazonaws.sdb.AmazonSimpleDBClient;
import com.amazonaws.sdb.AmazonSimpleDBConfig;
import com.amazonaws.sdb.AmazonSimpleDBException;
import com.amazonaws.sdb.model.Attribute;
import com.amazonaws.sdb.model.CreateDomainRequest;
import com.amazonaws.sdb.model.CreateDomainResponse;
import com.amazonaws.sdb.model.DeleteAttributesRequest;
import com.amazonaws.sdb.model.DeleteAttributesResponse;
import com.amazonaws.sdb.model.DeleteDomainRequest;
import com.amazonaws.sdb.model.DeleteDomainResponse;
import com.amazonaws.sdb.model.GetAttributesRequest;
import com.amazonaws.sdb.model.GetAttributesResponse;
import com.amazonaws.sdb.model.GetAttributesResult;
import com.amazonaws.sdb.model.Item;
import com.amazonaws.sdb.model.ListDomainsRequest;
import com.amazonaws.sdb.model.ListDomainsResponse;
import com.amazonaws.sdb.model.ListDomainsResult;
import com.amazonaws.sdb.model.PutAttributesRequest;
import com.amazonaws.sdb.model.PutAttributesResponse;
import com.amazonaws.sdb.model.QueryWithAttributesRequest;
import com.amazonaws.sdb.model.QueryWithAttributesResponse;
import com.amazonaws.sdb.model.QueryWithAttributesResult;
import com.amazonaws.sdb.model.ReplaceableAttribute;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.apache.ws.commons.util.Base64;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.aws.storage.sdb.SDBAttributeValueCorruptedException;
import org.exoplatform.services.jcr.aws.storage.sdb.SDBAttributeValueFormatException;
import org.exoplatform.services.jcr.aws.storage.sdb.SDBConstants;
import org.exoplatform.services.jcr.aws.storage.sdb.SDBRepositoryException;
import org.exoplatform.services.jcr.aws.storage.sdb.SDBStorageException;
import org.exoplatform.services.jcr.aws.storage.sdb.SDBValueNumberFormatException;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedNodeData;
import org.exoplatform.services.jcr.dataflow.persistent.PersistedPropertyData;
import org.exoplatform.services.jcr.datamodel.IllegalACLException;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.persistent.ByteArrayPersistedValueData;
import org.exoplatform.services.jcr.impl.storage.JCRInvalidItemStateException;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.jcr.storage.value.ValueIOChannel;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDBWorkspaceStorageConnection
implements WorkspaceStorageConnection,
SDBConstants {
    protected static final Log LOG = ExoLogger.getLogger((String)"jcr.SDBWorkspaceStorageConnection");
    protected static final int SDB_OPERATION_TIMEOUT = 5000;
    protected static final int SDB_OPERATION_COUNT = 3;
    protected static final String ITEM_DELETE = "delete".intern();
    protected static final String ITEM_UPDATE = "update".intern();
    protected static final String QUERY_GET_ITEM_BY_ID = "['ID' = '%s']";
    protected static final String QUERY_GET_ITEM_BY_NAME = "['PID' = '%s'] intersection ['Name' = '%s'] intersection ['ID' != 'D']";
    protected static final String QUERY_GET_ITEM_BY_NAME_OR_ID = "['PID' = '%s'] intersection ['Name' = '%s'] intersection ['ID' != 'D'] union ['ID' = '%s']";
    protected static final String QUERY_GET_CHILDNODES = "['PID' = '%s'] intersection ['IClass' = '1'] intersection ['ID' != 'D']";
    protected static final String QUERY_GET_CHILDPROPERTIES = "['PID' = '%s'] intersection ['IClass' = '2'] intersection ['ID' != 'D']";
    protected static final String QUERY_GET_REFERENCES = "['Reference' = '%s'] intersection ['ID' != 'D']";
    protected final AmazonSimpleDB sdbService;
    protected final String domainName;
    protected final List<WriteOperation> changes;
    protected final Set<String> changedItems;
    protected final int maxBufferSize;
    protected final ValueStoragePluginProvider valueStorageProvider;

    public SDBWorkspaceStorageConnection(String accessKey, String secretKey, String domainName, int maxBufferSize, ValueStoragePluginProvider valueStorageProvider) throws RepositoryException {
        AmazonSimpleDBConfig config = new AmazonSimpleDBConfig();
        config.setSignatureVersion("0");
        this.sdbService = new AmazonSimpleDBClient(accessKey, secretKey, config);
        this.domainName = domainName;
        this.maxBufferSize = maxBufferSize;
        this.valueStorageProvider = valueStorageProvider;
        this.changes = new ArrayList<WriteOperation>();
        this.changedItems = new HashSet<String>();
    }

    String initStorage(String containerName, String version) throws RepositoryException {
        try {
            Set<String> domains = this.getDomainsList();
            if (!domains.contains(this.domainName)) {
                this.createDomain(this.sdbService, this.domainName);
                int iter = 5;
                boolean notInitilizer = true;
                do {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        LOG.error((Object)("Init storage sleep error " + e), (Throwable)e);
                    }
                } while (notInitilizer = !(domains = this.getDomainsList()).contains(this.domainName) && --iter > 0);
                if (notInitilizer) {
                    LOG.warn((Object)("SimpleDB domain '" + this.domainName + "' created but still not available."));
                }
            } else {
                String userContainer = null;
                String userVersion = null;
                GetAttributesResponse resp = this.readItem(this.sdbService, this.domainName, "$EXO_STORAGE_VERSION");
                if (resp.isSetGetAttributesResult()) {
                    GetAttributesResult res = resp.getGetAttributesResult();
                    List attributeList = res.getAttribute();
                    for (Attribute attr : attributeList) {
                        if (attr.getName().equals("Version")) {
                            if (attr.isSetValue()) {
                                userVersion = attr.getValue();
                                continue;
                            }
                            throw new SDBRepositoryException("FATAL Storage Version Item attribute Version doesn't contains information.");
                        }
                        if (!attr.getName().equals("Container")) continue;
                        if (attr.isSetValue()) {
                            userContainer = attr.getValue();
                            continue;
                        }
                        throw new SDBRepositoryException("FATAL Storage Version Item attribute Container doesn't contains information.");
                    }
                } else {
                    throw new SDBRepositoryException("FATAL Storage domain (" + this.domainName + ") exists but Version Item not found " + "$EXO_STORAGE_VERSION" + ".");
                }
                if (userContainer != null && userVersion != null) {
                    if (!containerName.equals(userContainer)) {
                        LOG.warn((Object)("Storage in use by another Workspace container '" + userContainer + "'. User container name and current should be same. User storage version is " + userVersion + "."));
                    }
                    return userVersion;
                }
            }
        }
        catch (AmazonSimpleDBException e) {
            throw new SDBRepositoryException("Can not create SDB domain " + this.domainName, e);
        }
        ArrayList<ReplaceableAttribute> list = new ArrayList<ReplaceableAttribute>();
        list.add(new ReplaceableAttribute("Version", version, Boolean.valueOf(false)));
        list.add(new ReplaceableAttribute("Container", containerName, Boolean.valueOf(false)));
        try {
            this.createReplaceItem(this.sdbService, this.domainName, "$EXO_STORAGE_VERSION", list);
            return version;
        }
        catch (AmazonSimpleDBException e) {
            throw new SDBStorageException("(init) Storage initialization fails " + (Object)((Object)e), e);
        }
    }

    void runCleanup() {
        ArrayList<String> names = new ArrayList<String>();
        try {
            String nextToken = null;
            do {
                String query = String.format(QUERY_GET_ITEM_BY_ID, "D");
                QueryWithAttributesRequest request = new QueryWithAttributesRequest().withDomainName(this.domainName).withQueryExpression(query).withNextToken(nextToken).withAttributeName(new String[]{"IClass"});
                QueryWithAttributesResponse resp = this.invokeQuery(this.sdbService, request);
                if (!resp.isSetQueryWithAttributesResult()) continue;
                QueryWithAttributesResult res = resp.getQueryWithAttributesResult();
                nextToken = res.getNextToken();
                for (Item item : res.getItem()) {
                    names.add(item.getName());
                }
            } while (nextToken != null);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("(cleanup) " + names.size() + " items to delete"));
            }
        }
        catch (AmazonSimpleDBException e) {
            LOG.error((Object)("(cleaner) Error of deleted Items request " + (Object)((Object)e)), (Throwable)e);
        }
        for (String name : names) {
            try {
                this.deleteItem(this.sdbService, this.domainName, name);
            }
            catch (AmazonSimpleDBException e) {
                LOG.error((Object)("(cleaner) Item " + name + " delete error " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }

    protected Set<String> getDomainsList() throws AmazonSimpleDBException {
        HashSet<String> names = new HashSet<String>();
        String nextToken = null;
        do {
            ListDomainsResult result;
            if ((result = this.getDomains(this.sdbService, nextToken, 20)) == null) continue;
            List domainNamesList = result.getDomainName();
            names.addAll(domainNamesList);
            nextToken = result.getNextToken();
        } while (nextToken != null);
        return names;
    }

    protected ListDomainsResult getDomains(AmazonSimpleDB service, String nextToken, int maxDomains) throws AmazonSimpleDBException {
        ListDomainsRequest request = new ListDomainsRequest(Integer.valueOf(maxDomains), nextToken);
        ListDomainsResponse response = service.listDomains(request);
        if (response.isSetListDomainsResult()) {
            return response.getListDomainsResult();
        }
        return null;
    }

    protected CreateDomainResponse createDomain(AmazonSimpleDB service, String domainName) throws AmazonSimpleDBException {
        CreateDomainRequest request = new CreateDomainRequest(domainName);
        return service.createDomain(request);
    }

    protected DeleteDomainResponse deleteDomain(AmazonSimpleDB service, String domainName) throws AmazonSimpleDBException {
        DeleteDomainRequest request = new DeleteDomainRequest(domainName);
        return service.deleteDomain(request);
    }

    protected PutAttributesResponse createReplaceItem(AmazonSimpleDB service, String domainName, String itemName, List<ReplaceableAttribute> list) throws AmazonSimpleDBException {
        PutAttributesRequest request = new PutAttributesRequest().withDomainName(domainName).withItemName(itemName);
        request.setAttribute(list);
        return service.putAttributes(request);
    }

    protected GetAttributesResponse readItem(AmazonSimpleDB service, String domainName, String itemName) throws AmazonSimpleDBException {
        GetAttributesRequest request = new GetAttributesRequest().withDomainName(domainName).withItemName(itemName);
        return service.getAttributes(request);
    }

    protected DeleteAttributesResponse deleteItem(AmazonSimpleDB service, String domainName, String itemName) throws AmazonSimpleDBException {
        DeleteAttributesRequest request = new DeleteAttributesRequest().withDomainName(domainName).withItemName(itemName);
        return service.deleteAttributes(request);
    }

    protected QueryWithAttributesResponse queryItemAttrByID(AmazonSimpleDB service, String domainName, String itemId, String ... attributes) throws AmazonSimpleDBException {
        String query = String.format(QUERY_GET_ITEM_BY_ID, itemId);
        QueryWithAttributesRequest request = new QueryWithAttributesRequest().withDomainName(domainName).withQueryExpression(query);
        if (attributes != null) {
            request.withAttributeName(attributes);
        }
        return this.invokeQuery(service, request);
    }

    protected QueryWithAttributesResponse queryItemAttrByName(AmazonSimpleDB service, String domainName, String parentId, String name, String ... attributes) throws AmazonSimpleDBException {
        String query = String.format(QUERY_GET_ITEM_BY_NAME, parentId, name);
        QueryWithAttributesRequest request = new QueryWithAttributesRequest().withDomainName(domainName).withQueryExpression(query);
        if (attributes != null) {
            request.withAttributeName(attributes);
        }
        return this.invokeQuery(service, request);
    }

    protected QueryWithAttributesResponse queryItemAttrByNameOrID(AmazonSimpleDB service, String domainName, String parentId, String name, String itemId, String ... attributes) throws AmazonSimpleDBException {
        String query = String.format(QUERY_GET_ITEM_BY_NAME_OR_ID, parentId, name, itemId);
        QueryWithAttributesRequest request = new QueryWithAttributesRequest().withDomainName(domainName).withQueryExpression(query);
        if (attributes != null) {
            request.withAttributeName(attributes);
        }
        return this.invokeQuery(service, request);
    }

    protected QueryWithAttributesResponse queryChildNodesAttr(AmazonSimpleDB service, String domainName, String itemId, String ... attributes) throws AmazonSimpleDBException {
        String query = String.format(QUERY_GET_CHILDNODES, itemId);
        QueryWithAttributesRequest request = new QueryWithAttributesRequest().withDomainName(domainName).withQueryExpression(query).withAttributeName(attributes);
        return this.invokeQuery(service, request);
    }

    private QueryWithAttributesResponse invokeQuery(AmazonSimpleDB service, QueryWithAttributesRequest request) throws AmazonSimpleDBException {
        int cycle = 0;
        AmazonSimpleDBException ce = null;
        block4: while (true) {
            try {
                return service.queryWithAttributes(request);
            }
            catch (AmazonSimpleDBException e) {
                ce = e;
                for (Throwable c = e.getCause(); c != null; c = c.getCause()) {
                    if (!(c instanceof SocketTimeoutException)) continue;
                    ++cycle;
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e1) {
                        LOG.error((Object)("Connection thread interrupted " + e1), (Throwable)e1);
                    }
                    if (cycle < 3) continue block4;
                }
                throw new AmazonSimpleDBException((Throwable)ce);
            }
            break;
        }
    }

    protected QueryWithAttributesResponse queryChildPropertiesAttr(AmazonSimpleDB service, String domainName, String itemId, String ... attributes) throws AmazonSimpleDBException {
        String query = String.format(QUERY_GET_CHILDPROPERTIES, itemId);
        QueryWithAttributesRequest request = new QueryWithAttributesRequest().withDomainName(domainName).withQueryExpression(query).withAttributeName(attributes);
        return this.invokeQuery(service, request);
    }

    protected QueryWithAttributesResponse queryReferencesAttr(AmazonSimpleDB service, String domainName, String nodeId, String ... attributes) throws AmazonSimpleDBException {
        String query = String.format(QUERY_GET_REFERENCES, nodeId);
        QueryWithAttributesRequest request = new QueryWithAttributesRequest().withDomainName(domainName).withQueryExpression(query).withAttributeName(attributes);
        return this.invokeQuery(service, request);
    }

    protected String formatIData(NodeData node) {
        StringBuilder idata = new StringBuilder();
        idata.append(node.getPersistedVersion());
        idata.append("|");
        idata.append(node.getOrderNumber());
        idata.append("|");
        idata.append(node.getPrimaryTypeName().getAsString());
        boolean isPrivilegeable = false;
        boolean isOwneable = false;
        for (InternalQName mixin : node.getMixinTypeNames()) {
            idata.append("|");
            idata.append("NM");
            idata.append(mixin.getAsString());
            if (Constants.EXO_PRIVILEGEABLE.equals((Object)mixin)) {
                isPrivilegeable = true;
                continue;
            }
            if (!Constants.EXO_OWNEABLE.equals((Object)mixin)) continue;
            isOwneable = true;
        }
        AccessControlList acl = node.getACL();
        if (acl != null) {
            boolean root = Constants.ROOT_PATH.equals((Object)node.getQPath());
            if (isPrivilegeable || root) {
                for (AccessControlEntry ace : node.getACL().getPermissionEntries()) {
                    idata.append("|");
                    idata.append("AP");
                    idata.append(ace.getAsString());
                }
            }
            if (isOwneable || root) {
                idata.append("|");
                idata.append("AO");
                idata.append(node.getACL().getOwner());
            }
        }
        return idata.toString();
    }

    protected String formatIData(PropertyData property) {
        StringBuilder idata = new StringBuilder();
        idata.append(property.getPersistedVersion());
        idata.append("|");
        idata.append(property.getType());
        idata.append("|");
        idata.append(property.isMultiValued());
        return idata.toString();
    }

    protected NodeIData parseNodeIData(String field, AccessControlList parentACL) throws IllegalNameException, IllegalACLException, SDBValueNumberFormatException {
        String[] fs = field.split("\\|");
        NodeIData idata = new NodeIData();
        ArrayList<AccessControlEntry> aclPermissions = null;
        String aclOwner = null;
        for (int i = 0; i < fs.length; ++i) {
            String s = fs[i];
            if (i == 0) {
                try {
                    idata.setVersion(Integer.valueOf(s));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SDBValueNumberFormatException("Node persisted version contains wrong value '" + s + "'. Error " + e, e);
                }
            }
            if (i == 1) {
                try {
                    idata.setOrderNumber(Integer.valueOf(s));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SDBValueNumberFormatException("Node order number contains wrong value '" + s + "'. Error " + e, e);
                }
            }
            if (i == 2) {
                try {
                    idata.setPrimaryType(InternalQName.parse((String)s));
                    continue;
                }
                catch (IllegalNameException e) {
                    throw new IllegalNameException("Node jcr:primaryType contains wrong value '" + s + "'. Error " + (Object)((Object)e), (Throwable)e);
                }
            }
            String value = s.substring(2);
            if (s.startsWith("NM")) {
                try {
                    idata.addMixinType(InternalQName.parse((String)value));
                    continue;
                }
                catch (IllegalNameException e) {
                    throw new IllegalNameException("Node jcr:mixinTypes contains wrong value '" + value + "'. Error " + (Object)((Object)e), (Throwable)e);
                }
            }
            if (s.startsWith("AP")) {
                String[] aclp = value.split(" ");
                if (aclp.length != 2) {
                    throw new IllegalACLException("Node ACL permission contains wrong value '" + value + "'. ACL string format is 'IDENTITY PERMISSION'");
                }
                if (aclPermissions == null) {
                    aclPermissions = new ArrayList<AccessControlEntry>();
                }
                aclPermissions.add(new AccessControlEntry(aclp[0], aclp[1]));
                continue;
            }
            if (!s.startsWith("AO")) continue;
            aclOwner = value;
        }
        if (aclOwner != null || aclPermissions != null) {
            Object acl = aclOwner != null && aclPermissions != null ? new AccessControlList(aclOwner, aclPermissions) : (aclOwner != null && aclPermissions == null ? (parentACL != null && parentACL.hasPermissions() ? new AccessControlList(aclOwner, parentACL.getPermissionEntries()) : new AccessControlList(aclOwner, null)) : (aclOwner == null && aclPermissions != null ? (parentACL != null ? new AccessControlList(parentACL.getOwner(), aclPermissions) : new AccessControlList(null, aclPermissions)) : (parentACL != null ? new AccessControlList(parentACL.getOwner(), parentACL.hasPermissions() ? parentACL.getPermissionEntries() : null) : null)));
            idata.setAcl((AccessControlList)acl);
        }
        return idata;
    }

    protected PropertyIData parsePropertyIData(String field) {
        String[] fs = field.split("\\|");
        PropertyIData idata = new PropertyIData();
        for (int i = 0; i < fs.length; ++i) {
            String s = fs[i];
            if (i == 0) {
                try {
                    idata.setVersion(Integer.valueOf(s));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SDBValueNumberFormatException("Property persisted version contains wrong value '" + s + "'. Error " + e, e);
                }
            }
            if (i == 1) {
                try {
                    idata.setPtype(Integer.valueOf(s));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new SDBValueNumberFormatException("Property type contains wrong value '" + s + "'. Error " + e, e);
                }
            }
            if (i != 2) continue;
            idata.setMultivalued(Boolean.valueOf(s));
        }
        return idata;
    }

    protected String[] addValues(PropertyData data) throws IOException, SDBRepositoryException {
        List vdata = data.getValues();
        if ((long)vdata.size() > 100L) {
            throw new SDBRepositoryException("Property " + data.getQPath().getAsString() + " can has only " + 100L + " Values (SimpleDB request limit).");
        }
        String[] vseq = new String[vdata.size()];
        for (int i = 0; i < vdata.size(); ++i) {
            String v;
            ValueIOChannel channel;
            char[] vprefix;
            ValueData vd = (ValueData)vdata.get(i);
            vd.setOrderNumber(i);
            if (data.isMultiValued()) {
                vprefix = new char[4];
                char[] orderNum = String.valueOf(i).toCharArray();
                int oi = orderNum.length - 1;
                for (int ci = vprefix.length - 1; ci > 0; --ci) {
                    vprefix[ci] = oi >= 0 ? orderNum[oi--] : 48;
                }
            } else {
                vprefix = new char[1];
            }
            if ((channel = this.valueStorageProvider.getApplicableChannel(data, i)) == null) {
                vprefix[0] = 68;
                if (data.getType() == 2) {
                    byte[] ba = vd.getAsByteArray();
                    v = new String(vprefix) + Base64.encode((byte[])ba, (int)0, (int)ba.length, (int)1024, (String)"\n");
                } else {
                    v = new String(vprefix) + new String(vd.getAsByteArray(), "UTF-8");
                }
            } else {
                channel.write(data.getIdentifier(), vd);
                vprefix[0] = 83;
                v = new String(vprefix) + channel.getStorageId();
            }
            vseq[i] = v;
        }
        return vseq;
    }

    protected String getAttribute(List<Attribute> atts, String attrName) {
        for (Attribute attr : atts) {
            if (!attr.getName().equals(attrName)) continue;
            return attr.getValue();
        }
        return null;
    }

    protected String[] getAttributes(List<Attribute> atts, String attrName) {
        ArrayList<String> vals = new ArrayList<String>();
        for (Attribute attr : atts) {
            if (!attr.getName().equals(attrName)) continue;
            vals.add(attr.getValue());
        }
        return vals.toArray(new String[vals.size()]);
    }

    protected void validateItemAdd(ItemData data) throws ItemExistsException, SDBRepositoryException, JCRInvalidItemStateException {
        String itemClass = data.isNode() ? "Node" : "Property";
        try {
            QueryWithAttributesResult res;
            List items;
            QueryWithAttributesResponse resp = this.queryItemAttrByNameOrID(this.sdbService, this.domainName, data.getParentIdentifier(), data.getQPath().getEntries()[data.getQPath().getEntries().length - 1].getAsString(true), data.getIdentifier(), "ID");
            if (resp.isSetQueryWithAttributesResult() && (items = (res = resp.getQueryWithAttributesResult()).getItem()).size() > 0) {
                StringBuilder inames = new StringBuilder();
                for (Item i : items) {
                    inames.append(i.getName());
                    inames.append(" ");
                }
                throw new ItemExistsException("(add) " + itemClass + " already exists (" + inames + "). New item " + data.getQPath().getAsString() + " " + data.getIdentifier());
            }
            if (data.getParentIdentifier() != null && !this.changedItems.contains(data.getParentIdentifier()) && (resp = this.queryItemAttrByID(this.sdbService, this.domainName, data.getParentIdentifier(), "ID")).isSetQueryWithAttributesResult()) {
                res = resp.getQueryWithAttributesResult();
                items = res.getItem();
                if (items.size() > 1) {
                    StringBuilder inames = new StringBuilder();
                    for (Item i : items) {
                        inames.append(i.getName());
                        inames.append(" ");
                    }
                    throw new SDBRepositoryException("(add) FATAL Storage contains more of one Item with ID: " + data.getParentIdentifier() + ". Check of " + itemClass + " " + data.getQPath().getAsString() + " Item parent. Duplicates: " + inames);
                }
                if (items.size() <= 0) {
                    throw new JCRInvalidItemStateException("(add) " + itemClass + " " + data.getQPath().getAsString() + " parent not found " + data.getParentIdentifier() + ".", data.getParentIdentifier(), 1);
                }
            }
        }
        catch (AmazonSimpleDBException e) {
            throw new SDBStorageException("(add) " + itemClass + " " + data.getIdentifier() + " (" + data.getQPath().getAsString() + ") read request fails " + (Object)((Object)e), e);
        }
    }

    protected void validateItemChange(ItemData data, String modification) throws SDBRepositoryException, InvalidItemStateException {
        if (this.changedItems.contains(data.getIdentifier())) {
            return;
        }
        String itemClass = data.isNode() ? "Node" : "Property";
        try {
            QueryWithAttributesResponse resp = this.queryItemAttrByID(this.sdbService, this.domainName, data.getIdentifier(), "IData");
            if (resp.isSetQueryWithAttributesResult()) {
                QueryWithAttributesResult res = resp.getQueryWithAttributesResult();
                List items = res.getItem();
                if (items.size() <= 0) {
                    throw new JCRInvalidItemStateException("(" + modification + ") " + itemClass + " not found " + data.getQPath().getAsString() + " " + data.getIdentifier() + ". Probably was deleted by another session ", data.getIdentifier(), modification == ITEM_DELETE ? 4 : 2);
                }
                if (items.size() > 1) {
                    StringBuilder inames = new StringBuilder();
                    for (Item i : items) {
                        inames.append(i.getName());
                        inames.append(" ");
                    }
                    throw new SDBRepositoryException("(" + modification + ") FATAL Storage contains more of one Item with ID: " + data.getIdentifier() + ". " + itemClass + " " + data.getQPath().getAsString() + ". Duplicates: " + inames);
                }
            }
        }
        catch (AmazonSimpleDBException e) {
            throw new SDBStorageException("(" + modification + ") " + itemClass + " " + data.getIdentifier() + " (" + data.getQPath().getAsString() + ") read request fails " + (Object)((Object)e), e);
        }
    }

    private QPath traverseQPath(String itemId) throws InvalidItemStateException, IllegalNameException, SDBRepositoryException, AmazonSimpleDBException {
        ArrayList<QPathEntry> qrpath = new ArrayList<QPathEntry>();
        String ancestorId = itemId;
        do {
            QueryWithAttributesResponse resp;
            if (!(resp = this.queryItemAttrByID(this.sdbService, this.domainName, ancestorId, "PID", "Name", "IClass")).isSetQueryWithAttributesResult()) continue;
            QueryWithAttributesResult res = resp.getQueryWithAttributesResult();
            List items = res.getItem();
            if (items.size() == 1) {
                List atts = ((Item)items.get(0)).getAttribute();
                String iclass = this.getAttribute(atts, "IClass");
                if ("1".equals(iclass)) {
                    ancestorId = this.getAttribute(atts, "PID");
                    qrpath.add(QPathEntry.parse((String)this.getAttribute(atts, "Name")));
                    continue;
                }
                throw new SDBRepositoryException("(item) FATAL Item with Id " + ancestorId + " shoudl be a Node but " + ("2".equals(iclass) ? "Property found." : "Undefined type found."));
            }
            if (items.size() > 0) {
                StringBuilder inames = new StringBuilder();
                for (Item i : items) {
                    inames.append(i.getName());
                    inames.append(" ");
                }
                throw new SDBRepositoryException("(item) FATAL Id '" + ancestorId + "' match multiple items in storage: " + inames);
            }
            throw new JCRInvalidItemStateException("(item) Parent not found, Id " + ancestorId, ancestorId);
        } while (!ancestorId.equals(Constants.ROOT_PARENT_UUID));
        QPathEntry[] qentries = new QPathEntry[qrpath.size()];
        int qi = 0;
        for (int i = qrpath.size() - 1; i >= 0; --i) {
            qentries[qi++] = (QPathEntry)qrpath.get(i);
        }
        return new QPath(qentries);
    }

    protected NodeData loadNodeData(QPath parentPath, AccessControlList parentACL, List<Attribute> atts) throws NumberFormatException, IllegalNameException, IllegalACLException, InvalidItemStateException, SDBRepositoryException, AmazonSimpleDBException {
        String parentId;
        QPath qpath;
        String pid = this.getAttribute(atts, "PID");
        try {
            if (parentPath != null) {
                qpath = QPath.makeChildPath((QPath)parentPath, (QPathEntry)QPathEntry.parse((String)this.getAttribute(atts, "Name")));
                parentId = pid;
            } else if (Constants.ROOT_PARENT_UUID.equals(pid)) {
                qpath = Constants.ROOT_PATH;
                parentId = null;
            } else {
                qpath = QPath.makeChildPath((QPath)this.traverseQPath(pid), (QPathEntry)QPathEntry.parse((String)this.getAttribute(atts, "Name")));
                parentId = pid;
            }
        }
        catch (IllegalNameException e) {
            throw new IllegalNameException("Node name contains wrong value '" + this.getAttribute(atts, "Name") + "'. Error " + (Object)((Object)e), (Throwable)e);
        }
        NodeIData idata = this.parseNodeIData(this.getAttribute(atts, "IData"), parentACL);
        return new PersistedNodeData(this.getAttribute(atts, "ID"), qpath, parentId, idata.getVersion(), idata.getOrderNumber(), idata.getPrimaryType(), idata.getMixinTypes().toArray(new InternalQName[idata.getMixinTypes().size()]), idata.getACL());
    }

    protected PropertyData loadPropertyData(QPath parentPath, List<Attribute> atts, boolean withValues) throws NumberFormatException, IllegalNameException, AmazonSimpleDBException, RepositoryException {
        String pid = this.getAttribute(atts, "PID");
        PropertyIData idata = this.parsePropertyIData(this.getAttribute(atts, "IData"));
        PersistedPropertyData property = new PersistedPropertyData(this.getAttribute(atts, "ID"), QPath.makeChildPath((QPath)(parentPath == null ? this.traverseQPath(pid) : parentPath), (QPathEntry)QPathEntry.parse((String)this.getAttribute(atts, "Name"))), pid, idata.getVersion(), idata.getType(), idata.isMultivalued());
        if (withValues) {
            String[] vals = this.getAttributes(atts, "Data");
            ArrayList<Object> values = new ArrayList<Object>(vals.length);
            for (int i = 0; i < vals.length; ++i) {
                int orderNum;
                String value;
                char vp = vals[i].charAt(0);
                if (property.isMultiValued()) {
                    value = vals[i].substring(4);
                    StringBuilder on = new StringBuilder();
                    for (char ch : vals[i].substring(1, 4).toCharArray()) {
                        if (ch == '0' && on.length() <= 0) continue;
                        on.append(ch);
                    }
                    orderNum = on.length() <= 0 ? 0 : Integer.parseInt(on.toString());
                } else {
                    value = vals[i].substring(1);
                    orderNum = 0;
                }
                if (vp == 'D') {
                    if (property.getType() == 2) {
                        try {
                            values.add(new ByteArrayPersistedValueData(Base64.decode((String)value), orderNum));
                            continue;
                        }
                        catch (Base64.DecodingException e) {
                            throw new SDBAttributeValueCorruptedException("Property " + property.getQPath().getName().getAsString() + " value[" + orderNum + "] decoding error " + (Object)((Object)e), (Exception)((Object)e));
                        }
                    }
                    try {
                        values.add(new ByteArrayPersistedValueData(value.getBytes("UTF-8"), orderNum));
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new SDBAttributeValueFormatException("Property " + property.getQPath().getName().getAsString() + " value[" + orderNum + "] decoding error " + e, e);
                    }
                }
                if (vp != 'S') continue;
                try {
                    ValueIOChannel channel = this.valueStorageProvider.getChannel(value);
                    values.add(channel.read(property.getIdentifier(), orderNum, this.maxBufferSize));
                    continue;
                }
                catch (IOException e) {
                    throw new RepositoryException("Property " + property.getQPath().getName().getAsString() + " value[" + orderNum + "] read I/O error " + e, (Throwable)e);
                }
            }
            if (values.size() > 1) {
                Collections.sort(values, new ValueDataComparator());
            }
            property.setValues(values);
        } else {
            property.setValues(new ArrayList(0));
        }
        return property;
    }

    public void add(NodeData data) throws ItemExistsException, RepositoryException {
        this.changes.add(new AddNodeOperation(data));
    }

    public void add(PropertyData data) throws ItemExistsException, RepositoryException {
        this.changes.add(new AddPropertyOperation(data));
    }

    public void commit() throws IllegalStateException, RepositoryException {
        Iterator<WriteOperation> iter = this.changes.iterator();
        while (iter.hasNext()) {
            iter.next().execute();
        }
        this.changes.clear();
        this.changedItems.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, RepositoryException {
        try {
            for (int i = this.changes.size() - 1; i >= 0; --i) {
                WriteOperation o = this.changes.get(i);
                if (!o.executed()) continue;
                o.rollback();
            }
        }
        finally {
            this.changes.clear();
            this.changedItems.clear();
        }
    }

    public void delete(NodeData data) throws RepositoryException, InvalidItemStateException {
        this.changes.add(new DeleteNodeOperation(data));
    }

    public void delete(PropertyData data) throws RepositoryException, InvalidItemStateException {
        this.changes.add(new DeletePropertyOperation(data));
    }

    public void update(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.changes.add(new UpdateNodeOperation(data));
    }

    public void update(PropertyData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.changes.add(new UpdatePropertyOperation(data));
    }

    public void rename(NodeData data) throws RepositoryException, UnsupportedOperationException, InvalidItemStateException, IllegalStateException {
        this.changes.add(new UpdateNodeOperation(data));
    }

    public List<NodeData> getChildNodesData(NodeData parent) throws RepositoryException, IllegalStateException {
        try {
            QueryWithAttributesResponse resp = this.queryChildNodesAttr(this.sdbService, this.domainName, parent.getIdentifier(), "ID", "PID", "Name", "IClass", "IData");
            ArrayList<NodeData> childItems = new ArrayList<NodeData>();
            if (resp.isSetQueryWithAttributesResult()) {
                for (Item item : resp.getQueryWithAttributesResult().getItem()) {
                    childItems.add(this.loadNodeData(parent.getQPath(), parent.getACL(), item.getAttribute()));
                }
            }
            if (childItems.size() > 1) {
                Collections.sort(childItems, new NodeDataComparator());
            }
            return childItems;
        }
        catch (AmazonSimpleDBException e) {
            throw new SDBStorageException("(child nodes) Parent " + parent.getQPath().getAsString() + " " + parent.getIdentifier() + ". Read request fails " + (Object)((Object)e), e);
        }
        catch (NumberFormatException e) {
            throw new SDBRepositoryException("(child nodes) Parent " + parent.getQPath().getAsString() + " " + parent.getIdentifier() + ". Read request fails " + e, e);
        }
        catch (IllegalNameException e) {
            throw new SDBRepositoryException("(child nodes) Parent " + parent.getQPath().getAsString() + " " + parent.getIdentifier() + ". Read request fails " + (Object)((Object)e), e);
        }
        catch (IllegalACLException e) {
            throw new SDBRepositoryException("(child nodes) Parent " + parent.getQPath().getAsString() + " " + parent.getIdentifier() + ". Read request fails " + (Object)((Object)e), e);
        }
    }

    public List<PropertyData> getChildPropertiesData(NodeData parent) throws RepositoryException, IllegalStateException {
        try {
            ArrayList<PropertyData> childItems = new ArrayList<PropertyData>();
            int cycle = 0;
            do {
                QueryWithAttributesResponse resp;
                if ((resp = this.queryChildPropertiesAttr(this.sdbService, this.domainName, parent.getIdentifier(), "ID", "PID", "Name", "IClass", "IData", "Data")).isSetQueryWithAttributesResult()) {
                    for (Item item : resp.getQueryWithAttributesResult().getItem()) {
                        childItems.add(this.loadPropertyData(parent.getQPath(), item.getAttribute(), true));
                    }
                }
                if (childItems.size() != 0) break;
                LOG.warn((Object)("(child properties) Parent " + parent.getQPath().getAsString() + " " + parent.getIdentifier() + " returns EMPTY list. Retry..."));
                ++cycle;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    LOG.error((Object)("Connection thread interrupted " + e), (Throwable)e);
                    break;
                }
            } while (cycle < 3);
            if (cycle >= 3) {
                LOG.warn((Object)("(child properties) Parent " + parent.getQPath().getAsString() + " " + parent.getIdentifier() + " returns EMPTY list."));
            }
            return childItems;
        }
        catch (AmazonSimpleDBException e) {
            throw new SDBStorageException("(child properties) Parent " + parent.getQPath().getAsString() + " " + parent.getIdentifier() + ". Read request fails " + (Object)((Object)e), e);
        }
        catch (NumberFormatException e) {
            throw new SDBRepositoryException("(child properties) Parent " + parent.getQPath().getAsString() + " " + parent.getIdentifier() + ". Read request fails " + e, e);
        }
        catch (IllegalNameException e) {
            throw new SDBRepositoryException("(child properties) Parent " + parent.getQPath().getAsString() + " " + parent.getIdentifier() + ". Read request fails " + (Object)((Object)e), e);
        }
    }

    public List<PropertyData> listChildPropertiesData(NodeData parent) throws RepositoryException, IllegalStateException {
        try {
            ArrayList<PropertyData> childItems = new ArrayList<PropertyData>();
            int cycle = 0;
            do {
                QueryWithAttributesResponse resp;
                if ((resp = this.queryChildPropertiesAttr(this.sdbService, this.domainName, parent.getIdentifier(), "ID", "PID", "Name", "IClass", "IData")).isSetQueryWithAttributesResult()) {
                    for (Item item : resp.getQueryWithAttributesResult().getItem()) {
                        childItems.add(this.loadPropertyData(parent.getQPath(), item.getAttribute(), false));
                    }
                }
                if (childItems.size() != 0) break;
                LOG.warn((Object)("(list child properties) Parent " + parent.getQPath().getAsString() + " " + parent.getIdentifier() + " returns EMPTY list. Retry..."));
                ++cycle;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    LOG.error((Object)("Connection thread interrupted " + e), (Throwable)e);
                    break;
                }
            } while (cycle < 3);
            if (cycle >= 3) {
                LOG.warn((Object)("(list child properties) Parent " + parent.getQPath().getAsString() + " " + parent.getIdentifier() + " returns EMPTY list."));
            }
            return childItems;
        }
        catch (AmazonSimpleDBException e) {
            throw new SDBStorageException("(list child properties) Parent " + parent.getQPath().getAsString() + " " + parent.getIdentifier() + ". Read request fails " + (Object)((Object)e), e);
        }
        catch (NumberFormatException e) {
            throw new SDBRepositoryException("(list child properties) Parent " + parent.getQPath().getAsString() + " " + parent.getIdentifier() + ". Read request fails " + e, e);
        }
        catch (IllegalNameException e) {
            throw new SDBRepositoryException("(list child properties) Parent " + parent.getQPath().getAsString() + " " + parent.getIdentifier() + ". Read request fails " + (Object)((Object)e), e);
        }
    }

    public ItemData getItemData(NodeData parent, QPathEntry qname) throws RepositoryException, IllegalStateException {
        String parentId = parent.getIdentifier();
        String name = qname.getAsString(true);
        try {
            QueryWithAttributesResponse resp = this.queryItemAttrByName(this.sdbService, this.domainName, parentId, name, null);
            if (resp.isSetQueryWithAttributesResult()) {
                QueryWithAttributesResult res = resp.getQueryWithAttributesResult();
                List items = res.getItem();
                if (items.size() == 1) {
                    List atts = ((Item)items.get(0)).getAttribute();
                    String iclass = this.getAttribute(atts, "IClass");
                    if ("1".equals(iclass)) {
                        return this.loadNodeData(parent.getQPath(), parent.getACL(), atts);
                    }
                    if ("2".equals(iclass)) {
                        return this.loadPropertyData(parent.getQPath(), atts, true);
                    }
                    throw new SDBRepositoryException("(item) FATAL Item " + parent.getQPath().getAsString() + name + " (parentId=" + parentId + ") has undefined type (" + "IClass" + "=" + iclass + ")");
                }
                if (items.size() > 0) {
                    StringBuilder inames = new StringBuilder();
                    for (Item i : items) {
                        inames.append(i.getName());
                        inames.append(" ");
                    }
                    throw new SDBRepositoryException("(item) FATAL Location " + parent.getQPath().getAsString() + name + " (parentId=" + parentId + ") match multiple items in storage: " + inames);
                }
            }
        }
        catch (AmazonSimpleDBException e) {
            throw new SDBStorageException("(item) " + parent.getQPath().getAsString() + name + " (parentId=" + parentId + "). Read request fails " + (Object)((Object)e), e);
        }
        catch (NumberFormatException e) {
            throw new SDBRepositoryException("(item) " + parent.getQPath().getAsString() + name + " (parentId=" + parentId + "). Read request fails " + e, e);
        }
        catch (IllegalNameException e) {
            throw new SDBRepositoryException("(item) " + parent.getQPath().getAsString() + name + " (parentId=" + parentId + "). Read request fails " + (Object)((Object)e), e);
        }
        catch (IllegalACLException e) {
            throw new SDBRepositoryException("(item) " + parent.getQPath().getAsString() + name + " (parentId=" + parentId + "). Read request fails " + (Object)((Object)e), e);
        }
        return null;
    }

    public ItemData getItemData(String identifier) throws RepositoryException, IllegalStateException {
        try {
            QueryWithAttributesResponse resp = this.queryItemAttrByID(this.sdbService, this.domainName, identifier, null);
            if (resp.isSetQueryWithAttributesResult()) {
                QueryWithAttributesResult res = resp.getQueryWithAttributesResult();
                List items = res.getItem();
                if (items.size() == 1) {
                    List atts = ((Item)items.get(0)).getAttribute();
                    String iclass = this.getAttribute(atts, "IClass");
                    if ("1".equals(iclass)) {
                        return this.loadNodeData(null, null, atts);
                    }
                    if ("2".equals(iclass)) {
                        return this.loadPropertyData(null, atts, true);
                    }
                    throw new SDBRepositoryException("(item) FATAL Item with Id " + identifier + " has undefined type (" + "IClass" + "=" + iclass + ")");
                }
                if (items.size() > 0) {
                    StringBuilder inames = new StringBuilder();
                    for (Item i : items) {
                        inames.append(i.getName());
                        inames.append(" ");
                    }
                    throw new SDBRepositoryException("(item) FATAL Id " + identifier + " match multiple items in storage: " + inames);
                }
            }
        }
        catch (AmazonSimpleDBException e) {
            throw new SDBStorageException("(item) Id " + identifier + ". Read request fails " + (Object)((Object)e), e);
        }
        catch (NumberFormatException e) {
            throw new SDBRepositoryException("(item) Id " + identifier + ". Read request fails " + e, e);
        }
        catch (IllegalNameException e) {
            throw new SDBRepositoryException("(item) Id " + identifier + ". Read request fails " + (Object)((Object)e), e);
        }
        catch (IllegalACLException e) {
            throw new SDBRepositoryException("(item) Id " + identifier + ". Read request fails " + (Object)((Object)e), e);
        }
        return null;
    }

    public List<PropertyData> getReferencesData(String nodeIdentifier) throws RepositoryException, IllegalStateException, UnsupportedOperationException {
        try {
            QueryWithAttributesResponse resp = this.queryReferencesAttr(this.sdbService, this.domainName, nodeIdentifier, "ID", "PID", "Name", "IClass", "IData", "Data");
            ArrayList<PropertyData> refProps = new ArrayList<PropertyData>();
            if (resp.isSetQueryWithAttributesResult()) {
                QueryWithAttributesResult res = resp.getQueryWithAttributesResult();
                List items = res.getItem();
                for (Item item : items) {
                    refProps.add(this.loadPropertyData(null, item.getAttribute(), true));
                }
            }
            return refProps;
        }
        catch (AmazonSimpleDBException e) {
            throw new SDBStorageException("(references) Node Id " + nodeIdentifier + ". Read request fails " + (Object)((Object)e), e);
        }
        catch (NumberFormatException e) {
            throw new SDBRepositoryException("(references) Node Id " + nodeIdentifier + ". Read request fails " + e, e);
        }
        catch (IllegalNameException e) {
            throw new SDBRepositoryException("(references) Node Id " + nodeIdentifier + ". Read request fails " + (Object)((Object)e), e);
        }
    }

    public boolean isOpened() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValueDataComparator
    implements Comparator<ValueData> {
        ValueDataComparator() {
        }

        @Override
        public int compare(ValueData o1, ValueData o2) {
            return o1.getOrderNumber() - o2.getOrderNumber();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PropertyDataComparator
    implements Comparator<PropertyData> {
        PropertyDataComparator() {
        }

        @Override
        public int compare(PropertyData o1, PropertyData o2) {
            if (Constants.JCR_PRIMARYTYPE.equals((Object)o1.getQPath().getName())) {
                return Integer.MIN_VALUE;
            }
            if (Constants.JCR_MIXINTYPES.equals((Object)o1.getQPath().getName())) {
                return -2147483647;
            }
            if (Constants.JCR_UUID.equals((Object)o1.getQPath().getName())) {
                return -2147483646;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class NodeDataComparator
    implements Comparator<NodeData> {
        NodeDataComparator() {
        }

        @Override
        public int compare(NodeData o1, NodeData o2) {
            return o1.getOrderNumber() - o2.getOrderNumber();
        }
    }

    class DeletePropertyOperation
    extends WriteOperation {
        final PropertyData property;

        DeletePropertyOperation(PropertyData property) {
            this.property = property;
        }

        QPath getPath() {
            return this.property.getQPath();
        }

        Object execute() throws RepositoryException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("(delete) Property " + this.property.getQPath().getAsString() + " " + this.property.getIdentifier()));
            }
            SDBWorkspaceStorageConnection.this.validateItemChange((ItemData)this.property, ITEM_DELETE);
            ArrayList<ReplaceableAttribute> list = new ArrayList<ReplaceableAttribute>();
            list.add(new ReplaceableAttribute("ID", "D", Boolean.valueOf(true)));
            try {
                PutAttributesResponse putAttributesResponse = SDBWorkspaceStorageConnection.this.createReplaceItem(SDBWorkspaceStorageConnection.this.sdbService, SDBWorkspaceStorageConnection.this.domainName, this.property.getIdentifier(), list);
                return putAttributesResponse;
            }
            catch (AmazonSimpleDBException e) {
                throw new SDBStorageException("(delete) Property " + this.property.getQPath().getAsString() + " " + this.property.getIdentifier() + " delete fails " + (Object)((Object)e), e);
            }
            finally {
                this.markExecuted();
            }
        }

        Object rollback() throws RepositoryException {
            ArrayList<ReplaceableAttribute> list = new ArrayList<ReplaceableAttribute>();
            list.add(new ReplaceableAttribute("ID", this.property.getIdentifier(), Boolean.valueOf(false)));
            try {
                return SDBWorkspaceStorageConnection.this.createReplaceItem(SDBWorkspaceStorageConnection.this.sdbService, SDBWorkspaceStorageConnection.this.domainName, this.property.getIdentifier(), list);
            }
            catch (AmazonSimpleDBException e) {
                throw new SDBStorageException("(delete) Property " + this.property.getQPath().getAsString() + " " + this.property.getIdentifier() + " delete rollback fails " + (Object)((Object)e), e);
            }
        }
    }

    class DeleteNodeOperation
    extends WriteOperation {
        final NodeData node;

        DeleteNodeOperation(NodeData node) {
            this.node = node;
        }

        QPath getPath() {
            return this.node.getQPath();
        }

        Object execute() throws RepositoryException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("(delete) Node " + this.node.getQPath().getAsString() + " " + this.node.getIdentifier()));
            }
            SDBWorkspaceStorageConnection.this.validateItemChange((ItemData)this.node, ITEM_DELETE);
            ArrayList<ReplaceableAttribute> list = new ArrayList<ReplaceableAttribute>();
            list.add(new ReplaceableAttribute("ID", "D", Boolean.valueOf(true)));
            try {
                PutAttributesResponse putAttributesResponse = SDBWorkspaceStorageConnection.this.createReplaceItem(SDBWorkspaceStorageConnection.this.sdbService, SDBWorkspaceStorageConnection.this.domainName, this.node.getIdentifier(), list);
                return putAttributesResponse;
            }
            catch (AmazonSimpleDBException e) {
                throw new SDBStorageException("(delete) Node " + this.node.getQPath().getAsString() + " " + this.node.getIdentifier() + " delete fails " + (Object)((Object)e), e);
            }
            finally {
                this.markExecuted();
            }
        }

        Object rollback() throws RepositoryException {
            ArrayList<ReplaceableAttribute> list = new ArrayList<ReplaceableAttribute>();
            list.add(new ReplaceableAttribute("ID", this.node.getIdentifier(), Boolean.valueOf(false)));
            try {
                return SDBWorkspaceStorageConnection.this.createReplaceItem(SDBWorkspaceStorageConnection.this.sdbService, SDBWorkspaceStorageConnection.this.domainName, this.node.getIdentifier(), list);
            }
            catch (AmazonSimpleDBException e) {
                throw new SDBStorageException("(delete) Node " + this.node.getQPath().getAsString() + " " + this.node.getIdentifier() + " delete rollback fails " + (Object)((Object)e), e);
            }
        }
    }

    class UpdatePropertyOperation
    extends WriteOperation {
        final PropertyData property;
        PropertyData prevProperty;

        UpdatePropertyOperation(PropertyData property) {
            this.property = property;
        }

        QPath getPath() {
            return this.property.getQPath();
        }

        Object execute() throws RepositoryException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("(update) Property " + this.property.getQPath().getAsString() + " " + this.property.getIdentifier()));
            }
            SDBWorkspaceStorageConnection.this.validateItemChange((ItemData)this.property, ITEM_UPDATE);
            this.prevProperty = (PropertyData)SDBWorkspaceStorageConnection.this.getItemData(this.property.getIdentifier());
            try {
                String[] values = SDBWorkspaceStorageConnection.this.addValues(this.property);
                ArrayList<ReplaceableAttribute> list = new ArrayList<ReplaceableAttribute>();
                list.add(new ReplaceableAttribute("PID", this.property.getParentIdentifier(), Boolean.valueOf(true)));
                list.add(new ReplaceableAttribute("Name", this.property.getQPath().getEntries()[this.property.getQPath().getEntries().length - 1].getAsString(true), Boolean.valueOf(true)));
                list.add(new ReplaceableAttribute("IData", SDBWorkspaceStorageConnection.this.formatIData(this.property), Boolean.valueOf(true)));
                for (String value : values) {
                    list.add(new ReplaceableAttribute("Data", value, Boolean.valueOf(true)));
                }
                if (this.property.getType() == 9) {
                    for (ValueData value : this.property.getValues()) {
                        list.add(new ReplaceableAttribute("Reference", new String(value.getAsByteArray()), Boolean.valueOf(true)));
                    }
                }
                try {
                    PutAttributesResponse res = SDBWorkspaceStorageConnection.this.createReplaceItem(SDBWorkspaceStorageConnection.this.sdbService, SDBWorkspaceStorageConnection.this.domainName, this.property.getIdentifier(), list);
                    SDBWorkspaceStorageConnection.this.changedItems.add(this.property.getIdentifier());
                    PutAttributesResponse putAttributesResponse = res;
                    return putAttributesResponse;
                }
                catch (AmazonSimpleDBException e) {
                    try {
                        throw new SDBStorageException("(update) Property " + this.property.getQPath().getAsString() + " " + this.property.getIdentifier() + " update fails " + (Object)((Object)e), e);
                    }
                    catch (IOException e2) {
                        throw new SDBRepositoryException("(update) Property " + this.property.getQPath().getAsString() + " " + this.property.getIdentifier() + " add fails with I/O error " + e2, e2);
                    }
                }
            }
            finally {
                this.markExecuted();
            }
        }

        Object rollback() throws RepositoryException {
            try {
                String[] values = SDBWorkspaceStorageConnection.this.addValues(this.prevProperty);
                ArrayList<ReplaceableAttribute> list = new ArrayList<ReplaceableAttribute>();
                list.add(new ReplaceableAttribute("PID", this.prevProperty.getParentIdentifier(), Boolean.valueOf(true)));
                list.add(new ReplaceableAttribute("Name", this.prevProperty.getQPath().getEntries()[this.prevProperty.getQPath().getEntries().length - 1].getAsString(true), Boolean.valueOf(true)));
                list.add(new ReplaceableAttribute("IData", SDBWorkspaceStorageConnection.this.formatIData(this.prevProperty), Boolean.valueOf(true)));
                for (String value : values) {
                    list.add(new ReplaceableAttribute("Data", value, Boolean.valueOf(true)));
                }
                if (this.property.getType() == 9) {
                    for (ValueData value : this.prevProperty.getValues()) {
                        list.add(new ReplaceableAttribute("Reference", new String(value.getAsByteArray()), Boolean.valueOf(true)));
                    }
                }
                try {
                    return SDBWorkspaceStorageConnection.this.createReplaceItem(SDBWorkspaceStorageConnection.this.sdbService, SDBWorkspaceStorageConnection.this.domainName, this.prevProperty.getIdentifier(), list);
                }
                catch (AmazonSimpleDBException e) {
                    throw new SDBStorageException("(update) Property " + this.property.getQPath().getAsString() + " " + this.property.getIdentifier() + " rollback fails " + (Object)((Object)e), e);
                }
            }
            catch (IOException e) {
                throw new SDBRepositoryException("(update) Property " + this.property.getQPath().getAsString() + " " + this.property.getIdentifier() + " rollback fails with I/O error " + e, e);
            }
        }
    }

    class UpdateNodeOperation
    extends WriteOperation {
        final NodeData node;
        NodeData prevNode;

        UpdateNodeOperation(NodeData node) {
            this.node = node;
        }

        QPath getPath() {
            return this.node.getQPath();
        }

        Object execute() throws RepositoryException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("(update) Node " + this.node.getQPath().getAsString() + " " + this.node.getIdentifier()));
            }
            SDBWorkspaceStorageConnection.this.validateItemChange((ItemData)this.node, ITEM_UPDATE);
            this.prevNode = (NodeData)SDBWorkspaceStorageConnection.this.getItemData(this.node.getIdentifier());
            ArrayList<ReplaceableAttribute> list = new ArrayList<ReplaceableAttribute>();
            list.add(new ReplaceableAttribute("PID", this.node.getParentIdentifier(), Boolean.valueOf(true)));
            list.add(new ReplaceableAttribute("Name", this.node.getQPath().getEntries()[this.node.getQPath().getEntries().length - 1].getAsString(true), Boolean.valueOf(true)));
            list.add(new ReplaceableAttribute("IData", SDBWorkspaceStorageConnection.this.formatIData(this.node), Boolean.valueOf(true)));
            try {
                PutAttributesResponse res = SDBWorkspaceStorageConnection.this.createReplaceItem(SDBWorkspaceStorageConnection.this.sdbService, SDBWorkspaceStorageConnection.this.domainName, this.node.getIdentifier(), list);
                SDBWorkspaceStorageConnection.this.changedItems.add(this.node.getIdentifier());
                PutAttributesResponse putAttributesResponse = res;
                return putAttributesResponse;
            }
            catch (AmazonSimpleDBException e) {
                throw new SDBStorageException("(update) Node " + this.node.getQPath().getAsString() + " " + this.node.getIdentifier() + " update fails " + (Object)((Object)e), e);
            }
            finally {
                this.markExecuted();
            }
        }

        Object rollback() throws RepositoryException {
            ArrayList<ReplaceableAttribute> list = new ArrayList<ReplaceableAttribute>();
            list.add(new ReplaceableAttribute("PID", this.prevNode.getParentIdentifier(), Boolean.valueOf(true)));
            list.add(new ReplaceableAttribute("Name", this.prevNode.getQPath().getEntries()[this.prevNode.getQPath().getEntries().length - 1].getAsString(true), Boolean.valueOf(true)));
            list.add(new ReplaceableAttribute("IData", SDBWorkspaceStorageConnection.this.formatIData(this.prevNode), Boolean.valueOf(true)));
            try {
                return SDBWorkspaceStorageConnection.this.createReplaceItem(SDBWorkspaceStorageConnection.this.sdbService, SDBWorkspaceStorageConnection.this.domainName, this.prevNode.getIdentifier(), list);
            }
            catch (AmazonSimpleDBException e) {
                throw new SDBStorageException("(update) Node " + this.node.getQPath().getAsString() + " " + this.node.getIdentifier() + " rollback fails " + (Object)((Object)e), e);
            }
        }
    }

    class AddPropertyOperation
    extends WriteOperation {
        final PropertyData property;

        AddPropertyOperation(PropertyData property) {
            this.property = property;
        }

        QPath getPath() {
            return this.property.getQPath();
        }

        Object execute() throws RepositoryException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("(add) Property " + this.property.getQPath().getAsString() + " " + this.property.getIdentifier()));
            }
            SDBWorkspaceStorageConnection.this.validateItemAdd((ItemData)this.property);
            try {
                String[] values = SDBWorkspaceStorageConnection.this.addValues(this.property);
                ArrayList<ReplaceableAttribute> list = new ArrayList<ReplaceableAttribute>();
                list.add(new ReplaceableAttribute("ID", this.property.getIdentifier(), Boolean.valueOf(false)));
                list.add(new ReplaceableAttribute("PID", this.property.getParentIdentifier(), Boolean.valueOf(false)));
                list.add(new ReplaceableAttribute("Name", this.property.getQPath().getEntries()[this.property.getQPath().getEntries().length - 1].getAsString(true), Boolean.valueOf(false)));
                list.add(new ReplaceableAttribute("IClass", "2", Boolean.valueOf(false)));
                list.add(new ReplaceableAttribute("IData", SDBWorkspaceStorageConnection.this.formatIData(this.property), Boolean.valueOf(false)));
                for (String value : values) {
                    list.add(new ReplaceableAttribute("Data", value, Boolean.valueOf(false)));
                }
                if (this.property.getType() == 9) {
                    for (ValueData value : this.property.getValues()) {
                        list.add(new ReplaceableAttribute("Reference", new String(value.getAsByteArray()), Boolean.valueOf(false)));
                    }
                }
                try {
                    PutAttributesResponse res = SDBWorkspaceStorageConnection.this.createReplaceItem(SDBWorkspaceStorageConnection.this.sdbService, SDBWorkspaceStorageConnection.this.domainName, this.property.getIdentifier(), list);
                    SDBWorkspaceStorageConnection.this.changedItems.add(this.property.getIdentifier());
                    PutAttributesResponse putAttributesResponse = res;
                    return putAttributesResponse;
                }
                catch (AmazonSimpleDBException e) {
                    try {
                        throw new SDBStorageException("(add) Property " + this.property.getQPath().getAsString() + " " + this.property.getIdentifier() + " add fails " + (Object)((Object)e), e);
                    }
                    catch (IOException e2) {
                        throw new SDBRepositoryException("(add) Property " + this.property.getQPath().getAsString() + " " + this.property.getIdentifier() + " add fails with I/O error " + e2, e2);
                    }
                }
            }
            finally {
                this.markExecuted();
            }
        }

        Object rollback() throws RepositoryException {
            try {
                return SDBWorkspaceStorageConnection.this.deleteItem(SDBWorkspaceStorageConnection.this.sdbService, SDBWorkspaceStorageConnection.this.domainName, this.property.getIdentifier());
            }
            catch (AmazonSimpleDBException e) {
                throw new SDBStorageException("(add) Property " + this.property.getQPath().getAsString() + " " + this.property.getIdentifier() + " rollback fails " + (Object)((Object)e), e);
            }
        }
    }

    class AddNodeOperation
    extends WriteOperation {
        final NodeData node;

        AddNodeOperation(NodeData node) {
            this.node = node;
        }

        QPath getPath() {
            return this.node.getQPath();
        }

        Object execute() throws RepositoryException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("(add) Node " + this.node.getQPath().getAsString() + " " + this.node.getIdentifier()));
            }
            SDBWorkspaceStorageConnection.this.validateItemAdd((ItemData)this.node);
            ArrayList<ReplaceableAttribute> list = new ArrayList<ReplaceableAttribute>();
            list.add(new ReplaceableAttribute("ID", this.node.getIdentifier(), Boolean.valueOf(false)));
            list.add(new ReplaceableAttribute("PID", this.node.getParentIdentifier() == null ? Constants.ROOT_PARENT_UUID : this.node.getParentIdentifier(), Boolean.valueOf(false)));
            list.add(new ReplaceableAttribute("Name", this.node.getQPath().getEntries()[this.node.getQPath().getEntries().length - 1].getAsString(true), Boolean.valueOf(false)));
            list.add(new ReplaceableAttribute("IClass", "1", Boolean.valueOf(false)));
            list.add(new ReplaceableAttribute("IData", SDBWorkspaceStorageConnection.this.formatIData(this.node), Boolean.valueOf(false)));
            try {
                PutAttributesResponse resp = SDBWorkspaceStorageConnection.this.createReplaceItem(SDBWorkspaceStorageConnection.this.sdbService, SDBWorkspaceStorageConnection.this.domainName, this.node.getIdentifier(), list);
                SDBWorkspaceStorageConnection.this.changedItems.add(this.node.getIdentifier());
                PutAttributesResponse putAttributesResponse = resp;
                return putAttributesResponse;
            }
            catch (AmazonSimpleDBException e) {
                throw new SDBStorageException("(add) Node " + this.node.getQPath().getAsString() + " " + this.node.getIdentifier() + " add fails " + (Object)((Object)e), e);
            }
            finally {
                this.markExecuted();
            }
        }

        Object rollback() throws RepositoryException {
            try {
                return SDBWorkspaceStorageConnection.this.deleteItem(SDBWorkspaceStorageConnection.this.sdbService, SDBWorkspaceStorageConnection.this.domainName, this.node.getIdentifier());
            }
            catch (AmazonSimpleDBException e) {
                throw new SDBStorageException("(add) Node " + this.node.getQPath().getAsString() + " " + this.node.getIdentifier() + " rollback fails " + (Object)((Object)e), e);
            }
        }
    }

    abstract class WriteOperation {
        private boolean executed = false;

        WriteOperation() {
        }

        abstract Object rollback() throws RepositoryException;

        abstract Object execute() throws RepositoryException;

        abstract QPath getPath();

        void markExecuted() {
            this.executed = true;
        }

        boolean executed() {
            return this.executed;
        }
    }

    public class PropertyIData {
        private int version;
        private int ptype;
        private boolean multivalued;
        private String storageKey;

        int getVersion() {
            return this.version;
        }

        int getType() {
            return this.ptype;
        }

        boolean isMultivalued() {
            return this.multivalued;
        }

        void setVersion(int version) {
            this.version = version;
        }

        void setPtype(int ptype) {
            this.ptype = ptype;
        }

        void setMultivalued(boolean multivalued) {
            this.multivalued = multivalued;
        }

        String getStorageKey() {
            return this.storageKey;
        }

        void setStorageKey(String storageKey) {
            this.storageKey = storageKey;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class NodeIData {
        private int version;
        private int orderNumber;
        private InternalQName primaryType;
        private final List<InternalQName> mixinTypes = new ArrayList<InternalQName>();
        private AccessControlList acl;

        int getVersion() {
            return this.version;
        }

        int getOrderNumber() {
            return this.orderNumber;
        }

        InternalQName getPrimaryType() {
            return this.primaryType;
        }

        List<InternalQName> getMixinTypes() {
            return this.mixinTypes;
        }

        void addMixinType(InternalQName mixin) {
            this.mixinTypes.add(mixin);
        }

        AccessControlList getACL() {
            return this.acl;
        }

        void setVersion(int version) {
            this.version = version;
        }

        void setOrderNumber(int orderNumber) {
            this.orderNumber = orderNumber;
        }

        void setPrimaryType(InternalQName primaryType) {
            this.primaryType = primaryType;
        }

        void setAcl(AccessControlList acl) {
            this.acl = acl;
        }
    }
}

