/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.server;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Arrays;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.ItemExistsException;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cifs.server.auth.Client;
import org.exoplatform.services.cifs.server.auth.NTLMv1;
import org.exoplatform.services.cifs.server.auth.NTLanManAuthContext;
import org.exoplatform.services.cifs.server.core.ShareType;
import org.exoplatform.services.cifs.server.core.SharedDevice;
import org.exoplatform.services.cifs.server.filesys.DiskInfo;
import org.exoplatform.services.cifs.server.filesys.FileAccess;
import org.exoplatform.services.cifs.server.filesys.FileAction;
import org.exoplatform.services.cifs.server.filesys.FileInfo;
import org.exoplatform.services.cifs.server.filesys.FileOpenParams;
import org.exoplatform.services.cifs.server.filesys.JCRDriver;
import org.exoplatform.services.cifs.server.filesys.JCRNetworkFile;
import org.exoplatform.services.cifs.server.filesys.NameCoder;
import org.exoplatform.services.cifs.server.filesys.NetworkFile;
import org.exoplatform.services.cifs.server.filesys.SearchContext;
import org.exoplatform.services.cifs.server.filesys.TooManyConnectionsException;
import org.exoplatform.services.cifs.server.filesys.TooManyFilesException;
import org.exoplatform.services.cifs.server.filesys.TreeConnection;
import org.exoplatform.services.cifs.server.filesys.UnsupportedInfoLevelException;
import org.exoplatform.services.cifs.server.filesys.VolumeInfo;
import org.exoplatform.services.cifs.smb.InvalidUNCPathException;
import org.exoplatform.services.cifs.smb.PCShare;
import org.exoplatform.services.cifs.smb.SMBDate;
import org.exoplatform.services.cifs.smb.server.CoreProtocolHandler;
import org.exoplatform.services.cifs.smb.server.DiskInfoPacker;
import org.exoplatform.services.cifs.smb.server.FindInfoPacker;
import org.exoplatform.services.cifs.smb.server.IPCHandler;
import org.exoplatform.services.cifs.smb.server.QueryInfoPacker;
import org.exoplatform.services.cifs.smb.server.SMBServer;
import org.exoplatform.services.cifs.smb.server.SMBSrvException;
import org.exoplatform.services.cifs.smb.server.SMBSrvPacket;
import org.exoplatform.services.cifs.smb.server.SMBSrvSession;
import org.exoplatform.services.cifs.smb.server.SMBSrvTransPacket;
import org.exoplatform.services.cifs.smb.server.SrvTransactBuffer;
import org.exoplatform.services.cifs.smb.server.VirtualCircuit;
import org.exoplatform.services.cifs.util.DataBuffer;
import org.exoplatform.services.cifs.util.DataPacker;
import org.exoplatform.services.jcr.core.CredentialsImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.organization.User;

public class LanManProtocolHandler
extends CoreProtocolHandler {
    private static final Log logger = ExoLogger.getLogger((String)"org.exoplatform.services.cifs.smb.server.LanManProtocolHandler");
    protected static final int LockShared = 1;
    protected static final int LockOplockRelease = 2;
    protected static final int LockChangeType = 4;
    protected static final int LockCancel = 8;
    protected static final int LockLargeFiles = 16;

    public LanManProtocolHandler() {
    }

    public LanManProtocolHandler(SMBSrvSession sess) {
        super(sess);
    }

    public String getName() {
        return "LanMan";
    }

    protected final int procAndXCommands(SMBSrvPacket outPkt) {
        logger.debug((Object)":procAndXCommands");
        int andxCmd = this.m_smbPkt.getAndXCommand();
        int andxOff = this.m_smbPkt.getParameter(1) + 4;
        outPkt.setAndXCommand(andxCmd);
        outPkt.setParameter(1, andxOff - 4);
        int paramBlk = 36;
        int endOfPkt = outPkt.getByteOffset() + outPkt.getByteCount();
        boolean andxErr = false;
        while (andxCmd != 255 && !andxErr) {
            int prevEndOfPkt = endOfPkt;
            switch (andxCmd) {
                case 117: {
                    endOfPkt = this.procChainedTreeConnectAndX(andxOff, outPkt, endOfPkt);
                }
            }
            andxCmd = this.m_smbPkt.getAndXParameter(andxOff, 0) & 0xFF;
            andxOff = this.m_smbPkt.getAndXParameter(andxOff, 1);
            outPkt.setAndXCommand(prevEndOfPkt, andxCmd);
            outPkt.setAndXParameter(paramBlk, 1, prevEndOfPkt - 4);
            paramBlk = prevEndOfPkt;
            if (outPkt.getErrorCode() == 0) continue;
            andxErr = true;
        }
        return endOfPkt;
    }

    protected final int procChainedTreeConnectAndX(int cmdOff, SMBSrvPacket outPkt, int endOff) {
        String uncPath;
        logger.debug((Object)":procChainedTreeConnectAndX");
        int flags = this.m_smbPkt.getAndXParameter(cmdOff, 2);
        int pwdLen = this.m_smbPkt.getAndXParameter(cmdOff, 3);
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(this.m_smbPkt.getUserId());
        if (vc == null) {
            outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741811, 1, 2);
            return endOff;
        }
        int dataPos = this.m_smbPkt.getAndXByteOffset(cmdOff);
        int dataLen = this.m_smbPkt.getAndXByteCount(cmdOff);
        byte[] buf = this.m_smbPkt.getBuffer();
        String pwd = null;
        if (pwdLen > 0) {
            pwd = new String(buf, dataPos, pwdLen);
            dataPos += pwdLen;
            dataLen -= pwdLen;
        }
        if ((uncPath = DataPacker.getString(buf, dataPos, dataLen)) == null) {
            outPkt.setError(13, 1);
            return endOff;
        }
        String service = DataPacker.getString(buf, dataPos += uncPath.length() + 1, dataLen -= uncPath.length() + 1);
        if (service == null) {
            outPkt.setError(13, 1);
            return endOff;
        }
        int servType = ShareType.ServiceAsType(service);
        if (servType == -1 && service.compareTo("?????") != 0) {
            outPkt.setError(13, 1);
            return endOff;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(8)) {
            logger.debug((Object)("ANDX Tree Connect AndX - " + uncPath + ", " + service));
        }
        PCShare share = null;
        try {
            share = new PCShare(uncPath);
        }
        catch (InvalidUNCPathException ex) {
            outPkt.setError(13, 1);
            return endOff;
        }
        if (servType == 2 && share.getShareName().compareTo("IPC$") == 0) {
            servType = 3;
        }
        SharedDevice shareDev = null;
        try {
            shareDev = this.m_sess.getSMBServer().findShare(share.getShareName(), servType, this.getSession());
        }
        catch (Exception ex) {
            outPkt.setError(6, 2);
            return endOff;
        }
        if (shareDev == null || servType != -1 && shareDev.getType() != servType) {
            outPkt.setError(15, 1);
            return endOff;
        }
        int sharePerm = 2;
        try {
            int treeId = vc.addTreeConnection(shareDev);
            outPkt.setTreeId(treeId);
            TreeConnection tree = vc.findTreeConnection(treeId);
            SessionImpl s = null;
            if (shareDev.getType() == 0) {
                CredentialsImpl credentials = new CredentialsImpl(vc.getClientInfo().getUsername(), vc.getClientInfo().getPassword().toCharArray());
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Create JCR-session: login admin");
                    }
                    s = (SessionImpl)this.m_sess.getSMBServer().getRepository().login((Credentials)credentials, shareDev.getName());
                    sharePerm = 0;
                    try {
                        s.checkPermission("/", "read");
                        sharePerm = 1;
                        logger.debug((Object)"share permission - read");
                    }
                    catch (AccessControlException e) {
                        // empty catch block
                    }
                    try {
                        s.checkPermission("/", "add_node");
                        s.checkPermission("/", "set_property");
                        sharePerm = 2;
                        logger.debug((Object)"share permission - writable");
                    }
                    catch (AccessControlException e) {}
                }
                catch (LoginException e) {
                    outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741715, 5, 1);
                    return endOff;
                }
                catch (NoSuchWorkspaceException e) {
                    outPkt.setError(this.m_smbPkt.isLongErrorCode(), -1073741620, 6, 2);
                    return endOff;
                }
                catch (RepositoryException e) {
                    e.printStackTrace();
                    outPkt.setError(65, 2);
                    return endOff;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    outPkt.setError(65, 2);
                    return endOff;
                }
            }
            tree.setSession((Session)s);
            tree.setPermission(sharePerm);
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(8)) {
                logger.debug((Object)("ANDX Tree Connect AndX - Allocated Tree Id = " + treeId));
            }
        }
        catch (TooManyConnectionsException ex) {
            outPkt.setError(89, 2);
            return endOff;
        }
        outPkt.setAndXParameterCount(endOff, 2);
        outPkt.setAndXParameter(endOff, 0, 255);
        outPkt.setAndXParameter(endOff, 1, 0);
        int pos = outPkt.getAndXByteOffset(endOff);
        byte[] outBuf = outPkt.getBuffer();
        pos = DataPacker.putString(ShareType.TypeAsService(servType), outBuf, pos, true);
        int bytLen = pos - outPkt.getAndXByteOffset(endOff);
        outPkt.setAndXByteCount(endOff, bytLen);
        return pos;
    }

    protected final void procFindClose(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procFindClose");
        if (!this.m_smbPkt.checkPacketIsValid(1, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(this.m_smbPkt.getUserId());
        TreeConnection conn = vc.findTreeConnection(this.m_smbPkt.getTreeId());
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        int searchId = this.m_smbPkt.getParameter(0);
        SearchContext ctx = vc.getSearchContext(searchId);
        if (ctx == null) {
            this.m_sess.sendSuccessResponseSMB();
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
            logger.debug((Object)("Close trans search [" + searchId + "]"));
        }
        vc.deallocateSearchSlot(searchId);
        this.m_sess.sendSuccessResponseSMB();
    }

    protected final void procLockingAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procLockingAndX");
        if (!this.m_smbPkt.checkPacketIsValid(8, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(-1073741790, 5, 1);
            return;
        }
        int fid = this.m_smbPkt.getParameter(2);
        int lockType = this.m_smbPkt.getParameter(3);
        long lockTmo = this.m_smbPkt.getParameterLong(4);
        int lockCnt = this.m_smbPkt.getParameter(6);
        int unlockCnt = this.m_smbPkt.getParameter(7);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(4096)) {
            logger.debug((Object)("File Lock [" + netFile.getFileId() + "] : type=0x" + Integer.toHexString(lockType) + ", tmo=" + lockTmo + ", locks=" + lockCnt + ", unlocks=" + unlockCnt));
        }
        outPkt.setParameterCount(2);
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, 0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected final void procLogoffAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procLogoffAndX");
        if (!this.m_smbPkt.checkPacketIsValid(15, 1)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        this.m_sess.sendSuccessResponseSMB();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void procOpenAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procOpenAndX");
        if (!this.m_smbPkt.checkPacketIsValid(15, 1)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, outPkt);
            return;
        }
        if (conn.getSharedDevice().getType() != 0) {
            this.m_sess.sendErrorResponseSMB(65535, 2);
            return;
        }
        int access = this.m_smbPkt.getParameter(3);
        int srchAttr = this.m_smbPkt.getParameter(4);
        int fileAttr = this.m_smbPkt.getParameter(5);
        int crTime = this.m_smbPkt.getParameter(6);
        int crDate = this.m_smbPkt.getParameter(7);
        int openFunc = this.m_smbPkt.getParameter(8);
        int allocSiz = this.m_smbPkt.getParameterLong(9);
        String fileName = this.m_smbPkt.unpackString(this.m_smbPkt.isUnicode());
        if (fileName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        logger.debug((Object)("\n fileName [" + fileName + "] TEMPLATE"));
        if (fileName.equals("")) {
            fileName = "/";
        } else {
            StringBuffer path = new StringBuffer(fileName);
            for (int i = 0; i < path.length(); ++i) {
                if (path.charAt(i) != '\\') continue;
                path.setCharAt(i, '/');
            }
            fileName = path.toString();
        }
        String temp = fileName;
        String stream = null;
        int pos = temp.indexOf(":");
        if (pos == -1) {
            fileName = NameCoder.DecodeName(temp);
        } else {
            this.m_sess.sendErrorResponseSMB(2, 1);
        }
        SMBDate crDateTime = null;
        if (crTime > 0 && crDate > 0) {
            crDateTime = new SMBDate(crDate, crTime);
        }
        FileOpenParams params = new FileOpenParams(fileName, stream, openFunc, access, srchAttr, fileAttr, allocSiz, crDateTime.getTime());
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File Open AndX [" + this.m_smbPkt.getTreeId() + "] params=" + params));
        }
        int responseAction = 0;
        int fid = -1;
        NetworkFile file = null;
        try {
            if (!conn.getSession().itemExists(fileName)) {
                if (!FileAction.createNotExists(openFunc)) {
                    this.m_sess.sendErrorResponseSMB(2, 1);
                    return;
                }
                if (!conn.hasWriteAccess()) {
                    this.m_sess.sendErrorResponseSMB(5, 1);
                    return;
                }
                logger.debug((Object)"trying to create file TEMPLATE");
                file = JCRDriver.createFile(conn, params);
                responseAction = 2;
            } else {
                if (!FileAction.openIfExists(openFunc) && !FileAction.truncateExistingFile(openFunc)) {
                    this.m_sess.sendErrorResponseSMB(80, 1);
                    return;
                }
                file = JCRDriver.openFile(conn, params);
                responseAction = FileAction.truncateExistingFile(openFunc) ? 3 : 1;
            }
            if (file != null) {
                fid = conn.addFile(file, this.getSession());
            }
        }
        catch (PathNotFoundException e) {
            this.m_sess.sendErrorResponseSMB(2, 1);
            return;
        }
        catch (AccessDeniedException e) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        catch (LockException e) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        catch (RepositoryException e) {
            this.m_sess.sendErrorResponseSMB(65, 2);
            return;
        }
        catch (TooManyFilesException ex) {
            this.m_sess.sendErrorResponseSMB(4, 1);
            return;
        }
        catch (Exception e) {
            this.m_sess.sendErrorResponseSMB(65, 2);
            return;
        }
        logger.debug((Object)("resp Action " + FileAction.asString(responseAction) + ", fid = " + fid + " TEMPORARY"));
        outPkt.setParameterCount(15);
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, fid);
        int attr = file != null ? file.getFileAttributes() : 0;
        outPkt.setParameter(3, attr);
        SMBDate modDate = null;
        modDate = file != null ? new SMBDate(file.getModifyDate()) : null;
        outPkt.setParameter(4, modDate != null ? modDate.asSMBTime() : 0);
        outPkt.setParameter(5, modDate != null ? modDate.asSMBDate() : 0);
        int size = file != null ? file.getFileSizeInt() : 0;
        outPkt.setParameterLong(6, size);
        int acc = file != null ? file.getGrantedAccess() : 0;
        outPkt.setParameter(8, acc);
        outPkt.setParameter(9, 0);
        outPkt.setParameter(10, 0);
        outPkt.setParameter(11, responseAction);
        outPkt.setParameter(12, 0);
        outPkt.setParameter(13, 0);
        outPkt.setParameter(14, 0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected final void procReadAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procReadAndX");
        if (!this.m_smbPkt.checkPacketIsValid(10, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, outPkt);
            return;
        }
        int fid = this.m_smbPkt.getParameter(2);
        int offset = this.m_smbPkt.getParameterLong(3);
        int maxCount = this.m_smbPkt.getParameter(5);
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
            logger.debug((Object)("File Read AndX [" + netFile.getFileId() + "] : Size=" + maxCount + " ,Pos=" + offset));
        }
        byte[] buf = outPkt.getBuffer();
        int dataPos = 0;
        int rdlen = 0;
        try {
            outPkt.setParameterCount(12);
            dataPos = outPkt.getByteOffset();
            int dataLen = buf.length - dataPos;
            if (dataLen < maxCount) {
                maxCount = dataLen;
            }
            rdlen = ((JCRNetworkFile)netFile).read(buf, dataPos, maxCount, offset);
        }
        catch (AccessDeniedException ex) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
                logger.debug((Object)("File Read Error [" + netFile.getFileId() + "] : " + ex.toString()));
            }
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        catch (IOException ex) {
            logger.error((Object)("File Read Error [" + netFile.getFileId() + "] : "), (Throwable)ex);
            this.m_sess.sendErrorResponseSMB(30, 3);
            return;
        }
        catch (RepositoryException ex) {
            ex.printStackTrace();
            this.m_sess.sendErrorResponseSMB(65, 2);
            return;
        }
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, 0);
        outPkt.setParameter(3, 0);
        outPkt.setParameter(4, 0);
        outPkt.setParameter(5, rdlen);
        outPkt.setParameter(6, dataPos - 4);
        for (int i = 7; i < 12; ++i) {
            outPkt.setParameter(i, 0);
        }
        outPkt.setByteCount(dataPos + rdlen - outPkt.getByteOffset());
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procRenameFile(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int i;
        logger.debug((Object)":procRenameFile");
        if (!this.m_smbPkt.checkPacketIsValid(1, 4)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(15, 1);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        boolean isUni = this.m_smbPkt.isUnicode();
        this.m_smbPkt.resetBytePointer();
        if (this.m_smbPkt.unpackByte() != 4) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        String oldName = this.m_smbPkt.unpackString(isUni);
        if (oldName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (this.m_smbPkt.unpackByte() != 4) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        String newName = this.m_smbPkt.unpackString(isUni);
        if (oldName == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (oldName.equals("")) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        StringBuffer path = new StringBuffer(oldName);
        for (i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '\\') continue;
            path.setCharAt(i, '/');
        }
        oldName = NameCoder.DecodeName(path.toString());
        if (newName.equals("")) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        path = new StringBuffer(newName);
        for (i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '\\') continue;
            path.setCharAt(i, '/');
        }
        newName = NameCoder.DecodeName(path.toString());
        String oldNamePath = oldName.substring(0, oldName.lastIndexOf("/") + 1);
        String newNamePath = newName.substring(0, newName.lastIndexOf("/") + 1);
        Session sess = conn.getSession();
        try {
            if (!sess.itemExists(oldNamePath)) {
                this.m_sess.sendErrorResponseSMB(3, 1);
                return;
            }
        }
        catch (RepositoryException e) {
            this.m_sess.sendErrorResponseSMB(65, 2);
            return;
        }
        try {
            if (!sess.itemExists(newNamePath)) {
                this.m_sess.sendErrorResponseSMB(3, 1);
                return;
            }
        }
        catch (RepositoryException e) {
            this.m_sess.sendErrorResponseSMB(65, 2);
            return;
        }
        try {
            if (!sess.itemExists(oldName)) {
                this.m_sess.sendErrorResponseSMB(2, 1);
                return;
            }
        }
        catch (RepositoryException e) {
            this.m_sess.sendErrorResponseSMB(65, 2);
            return;
        }
        try {
            if (sess.itemExists(newName)) {
                this.m_sess.sendErrorResponseSMB(80, 1);
                return;
            }
        }
        catch (RepositoryException e) {
            this.m_sess.sendErrorResponseSMB(65, 2);
            return;
        }
        if (newName.indexOf("[") != -1 || newName.indexOf("]") != -1) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(64)) {
            logger.debug((Object)("File Rename [" + this.m_smbPkt.getTreeId() + "] old name=" + oldName + ", new name=" + newName));
        }
        try {
            sess.move(oldName, newName);
            sess.save();
        }
        catch (AccessDeniedException e) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        catch (ConstraintViolationException e) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (PathNotFoundException e) {
            this.m_sess.sendErrorResponseSMB(2, 1);
            return;
        }
        catch (ItemExistsException e) {
            this.m_sess.sendErrorResponseSMB(80, 1);
            return;
        }
        catch (VersionException e) {
            this.m_sess.sendErrorResponseSMB(65, 2);
            return;
        }
        catch (RepositoryException e) {
            this.m_sess.sendErrorResponseSMB(65, 2);
            return;
        }
        outPkt.setParameterCount(0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected void procSessionSetup(SMBSrvPacket outPkt) throws SMBSrvException, IOException, TooManyConnectionsException {
        String user;
        logger.debug((Object)":procSessionSetup");
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        int maxBufSize = this.m_smbPkt.getParameter(2);
        int maxMpx = this.m_smbPkt.getParameter(3);
        int vcNum = this.m_smbPkt.getParameter(4);
        byte[] pwd = null;
        int pwdLen = this.m_smbPkt.getParameter(7);
        boolean isplaintext = false;
        if (pwdLen > 0) {
            pwd = new byte[pwdLen];
            for (int i = 0; i < pwdLen; ++i) {
                pwd[i] = buf[dataPos + i];
                if (buf[dataPos + i] != 0) continue;
                isplaintext = true;
            }
            dataPos += pwdLen;
            dataLen -= pwdLen;
        }
        if ((user = DataPacker.getString(buf, dataPos, dataLen)) == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        dataPos += user.length() + 1;
        String domain = "";
        if ((dataLen -= user.length() + 1) > 0) {
            domain = DataPacker.getString(buf, dataPos, dataLen);
            if (domain == null) {
                this.m_sess.sendErrorResponseSMB(13, 1);
                return;
            }
            dataLen -= domain.length() + 1;
            dataPos += domain.length() + 1;
        }
        String clientOS = "";
        if (dataLen > 0 && (clientOS = DataPacker.getString(buf, dataPos, dataLen)) == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(4)) {
            logger.debug((Object)("Session setup from user=" + user + ", password=" + pwd + ", domain=" + domain + ", os=" + clientOS + ", VC=" + vcNum + ", maxBuf=" + maxBufSize + ", maxMpx=" + maxMpx));
        }
        this.m_sess.setClientMaximumBufferSize(maxBufSize);
        this.m_sess.setClientMaximumMultiplex(maxMpx);
        boolean authenticated = false;
        Client client = null;
        try {
            if (user.length() == 0 && pwdLen <= 1) {
                client = new Client("", "");
                client.setLogonType(2);
                authenticated = true;
            } else if (user.equals("__anonim")) {
                authenticated = ((SMBServer)this.getSession().getServer()).getOrgainzationService().getUserHandler().authenticate(user, null);
                client = new Client(user, "");
                client.setGuest(false);
            } else {
                User ushnd = ((SMBServer)this.getSession().getServer()).getOrgainzationService().getUserHandler().findUserByName(user);
                if (ushnd != null) {
                    String pass = ushnd.getPassword();
                    if (pass != null) {
                        NTLMv1 enc = new NTLMv1();
                        NTLanManAuthContext cont = (NTLanManAuthContext)this.m_sess.getAuthenticationContext();
                        byte[] encPwd = enc.computeLMHash(pass, cont.getChallenge());
                        authenticated = Arrays.equals(encPwd, pwd);
                    }
                    client = new Client(user, pass);
                    client.setGuest(false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        if (!authenticated) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        logger.debug((Object)("User [" + client.getUsername() + "] pass[" + client.getPassword() + "] authenticated"));
        VirtualCircuit vc = new VirtualCircuit(vcNum, client);
        int uid = this.m_sess.addVirtualCircuit(vc);
        if (uid == -1) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(4)) {
                logger.debug((Object)("Failed to allocate UID for virtual circuit, " + vc));
            }
            throw new SMBSrvException(5, 1);
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(4)) {
            logger.debug((Object)("Allocated UID=" + uid + " for VC=" + vc));
        }
        this.getSession().setLoggedOn(true);
        outPkt.setParameterCount(3);
        outPkt.setParameter(0, 0);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, client.isGuest() ? 1 : 0);
        outPkt.setByteCount(0);
        outPkt.setTreeId(0);
        outPkt.setUserId(0);
        int flags = outPkt.getFlags();
        outPkt.setFlags(flags &= 0xFFFFFFF7);
        outPkt.setFlags2(1);
        int pos = outPkt.getByteOffset();
        buf = outPkt.getBuffer();
        pos = DataPacker.putString("Java", buf, pos, true);
        pos = DataPacker.putString("JLAN Server " + this.m_sess.getServer().isVersion(), buf, pos, true);
        pos = DataPacker.putString(this.m_sess.getServer().getConfiguration().getDomainName(), buf, pos, true);
        outPkt.setByteCount(pos - outPkt.getByteOffset());
        if (this.m_smbPkt.hasAndXCommand() && dataPos < this.m_smbPkt.getReceivedLength()) {
            pos = this.procAndXCommands(outPkt);
        } else {
            outPkt.setAndXCommand(255);
        }
        this.m_sess.sendResponseSMB(outPkt, pos);
        this.m_sess.setState(3);
        this.m_sess.getSMBServer().sessionLoggedOn(this.m_sess);
    }

    protected void procTransact2(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procTransact2");
        if (!this.m_smbPkt.checkPacketIsValid(15, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 6);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(this.m_smbPkt.getUserId());
        TreeConnection conn = vc.findTreeConnection(this.m_smbPkt.getTreeId());
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 6);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        SMBSrvTransPacket tranPkt = new SMBSrvTransPacket(this.m_smbPkt.getBuffer());
        SrvTransactBuffer transBuf = null;
        int subCmd = tranPkt.getSubFunction();
        if (tranPkt.getTotalParameterCount() == tranPkt.getParameterBlockCount() && tranPkt.getTotalDataCount() == tranPkt.getDataBlockCount()) {
            transBuf = new SrvTransactBuffer(tranPkt);
        } else {
            transBuf = new SrvTransactBuffer(tranPkt.getSetupCount(), tranPkt.getTotalParameterCount(), tranPkt.getTotalDataCount());
            transBuf.setType(tranPkt.getCommand());
            transBuf.setFunction(subCmd);
            byte[] buf = tranPkt.getBuffer();
            transBuf.appendSetup(buf, tranPkt.getSetupOffset(), tranPkt.getSetupCount() * 2);
            transBuf.appendParameter(buf, tranPkt.getParameterBlockOffset(), tranPkt.getParameterBlockCount());
            transBuf.appendData(buf, tranPkt.getDataBlockOffset(), tranPkt.getDataBlockCount());
        }
        transBuf.setReturnLimits(tranPkt.getMaximumReturnSetupCount(), tranPkt.getMaximumReturnParameterCount(), tranPkt.getMaximumReturnDataCount());
        if (transBuf.isMultiPacket()) {
            this.m_sess.setTransaction(transBuf);
            this.m_sess.sendSuccessResponseSMB();
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.procTransaction(vc, transBuf, this.m_sess, outPkt);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
            logger.debug((Object)("Transaction [" + this.m_smbPkt.getTreeId() + "] tbuf=" + transBuf));
        }
        this.processTransactionBuffer(transBuf, outPkt);
    }

    protected void procTransact2Secondary(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        int dlen;
        logger.debug((Object)":procTransact2Secondary");
        if (!this.m_smbPkt.checkPacketIsValid(8, 0)) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 6);
            return;
        }
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(this.m_smbPkt.getUserId());
        TreeConnection conn = vc.findTreeConnection(this.m_smbPkt.getTreeId());
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 6);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        if (!this.m_sess.hasTransaction() || this.m_sess.getTransaction().isType() == 37 && this.m_smbPkt.getCommand() != 38 || this.m_sess.getTransaction().isType() == 50 && this.m_smbPkt.getCommand() != 51) {
            this.m_sess.sendErrorResponseSMB(1, 2);
            return;
        }
        SMBSrvTransPacket tpkt = new SMBSrvTransPacket(this.m_smbPkt.getBuffer());
        byte[] buf = tpkt.getBuffer();
        SrvTransactBuffer transBuf = this.m_sess.getTransaction();
        int plen = tpkt.getSecondaryParameterBlockCount();
        if (plen > 0) {
            DataBuffer paramBuf = transBuf.getParameterBuffer();
            paramBuf.appendData(buf, tpkt.getSecondaryParameterBlockOffset(), plen);
        }
        if ((dlen = tpkt.getSecondaryDataBlockCount()) > 0) {
            DataBuffer dataBuf = transBuf.getDataBuffer();
            dataBuf.appendData(buf, tpkt.getSecondaryDataBlockOffset(), dlen);
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
            logger.debug((Object)("Transaction Secondary [" + this.m_smbPkt.getTreeId() + "] paramLen=" + plen + ", dataLen=" + dlen));
        }
        int totParam = tpkt.getTotalParameterCount();
        int totData = tpkt.getTotalDataCount();
        int paramDisp = tpkt.getParameterBlockDisplacement();
        int dataDisp = tpkt.getDataBlockDisplacement();
        if (paramDisp + plen == totParam && dataDisp + dlen == totData) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
                logger.debug((Object)"Transaction complete, processing ...");
            }
            this.m_sess.setTransaction(null);
            if (conn.getSharedDevice().getType() == 3) {
                IPCHandler.procTransaction(vc, transBuf, this.m_sess, outPkt);
                return;
            }
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(256)) {
                logger.debug((Object)("Transaction second [" + this.m_smbPkt.getTreeId() + "] tbuf=" + transBuf));
            }
            this.processTransactionBuffer(transBuf, outPkt);
        } else {
            this.m_sess.sendSuccessResponseSMB();
        }
    }

    protected void procTreeConnectAndX(SMBSrvPacket outPkt) throws SMBSrvException, TooManyConnectionsException, IOException {
        String uncPath;
        logger.debug((Object)":procTreeConnectAndX");
        if (!this.m_smbPkt.checkPacketIsValid(4, 3)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        int flags = this.m_smbPkt.getParameter(2);
        int pwdLen = this.m_smbPkt.getParameter(3);
        int dataPos = this.m_smbPkt.getByteOffset();
        int dataLen = this.m_smbPkt.getByteCount();
        byte[] buf = this.m_smbPkt.getBuffer();
        String pwd = null;
        if (pwdLen > 0) {
            pwd = new String(buf, dataPos, pwdLen);
            dataPos += pwdLen;
            dataLen -= pwdLen;
        }
        if ((uncPath = DataPacker.getString(buf, dataPos, dataLen)) == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        String service = DataPacker.getString(buf, dataPos += uncPath.length() + 1, dataLen -= uncPath.length() + 1);
        if (service == null) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        int servType = ShareType.ServiceAsType(service);
        if (servType == -1 && service.compareTo("?????") != 0) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(8)) {
            logger.debug((Object)("Tree Connect AndX - " + uncPath + ", " + service));
        }
        PCShare share = null;
        try {
            share = new PCShare(uncPath);
        }
        catch (InvalidUNCPathException ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        if (servType == 2 && share.getShareName().compareTo("IPC$") == 0) {
            servType = 3;
        }
        SharedDevice shareDev = null;
        try {
            shareDev = this.m_sess.getSMBServer().findShare(share.getShareName(), servType, this.getSession());
        }
        catch (Exception ex) {
            this.m_sess.sendErrorResponseSMB(6, 2);
            return;
        }
        if (shareDev == null || servType != -1 && shareDev.getType() != servType) {
            this.m_sess.sendErrorResponseSMB(67, 4);
            return;
        }
        int sharePerm = 2;
        try {
            VirtualCircuit vc = this.m_sess.findVirtualCircuit(this.m_smbPkt.getUserId());
            int treeId = vc.addTreeConnection(shareDev);
            outPkt.setTreeId(treeId);
            TreeConnection tree = vc.findTreeConnection(treeId);
            SessionImpl s = null;
            if (shareDev.getType() == 0) {
                CredentialsImpl credentials = new CredentialsImpl(vc.getClientInfo().getUsername(), vc.getClientInfo().getPassword().toCharArray());
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Create JCR-session: login admin");
                    }
                    s = (SessionImpl)this.m_sess.getSMBServer().getRepository().login((Credentials)credentials, shareDev.getName());
                    sharePerm = 0;
                    try {
                        s.checkPermission("/", "read");
                        sharePerm = 1;
                        logger.debug((Object)"share permission - read");
                    }
                    catch (AccessControlException e) {
                        // empty catch block
                    }
                    try {
                        s.checkPermission("/", "add_node");
                        s.checkPermission("/", "set_property");
                        sharePerm = 2;
                        logger.debug((Object)"share permission - writable");
                    }
                    catch (AccessControlException e) {}
                }
                catch (LoginException e) {
                    this.m_sess.sendErrorResponseSMB(5, 1);
                    return;
                }
                catch (NoSuchWorkspaceException e) {
                    this.m_sess.sendErrorResponseSMB(6, 2);
                    return;
                }
                catch (RepositoryException e) {
                    e.printStackTrace();
                    this.m_sess.sendErrorResponseSMB(65, 2);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.m_sess.sendErrorResponseSMB(65, 2);
                    return;
                }
            }
            tree.setSession((Session)s);
            tree.setPermission(sharePerm);
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(8)) {
                logger.debug((Object)("Tree Connect AndX - Allocated Tree Id = " + treeId + ", Permission = " + FileAccess.asString(sharePerm)));
            }
        }
        catch (TooManyConnectionsException ex) {
            this.m_sess.sendErrorResponseSMB(89, 2);
            return;
        }
        outPkt.setParameterCount(3);
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, 0);
        int pos = outPkt.getByteOffset();
        pos = DataPacker.putString(ShareType.TypeAsService(shareDev.getType()), buf, pos, true);
        outPkt.setByteCount(pos - outPkt.getByteOffset());
        this.m_sess.sendResponseSMB(outPkt);
    }

    protected final void procWriteAndX(SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procWriteAndX");
        if (!this.m_smbPkt.checkPacketIsValid(12, 0)) {
            this.m_sess.sendErrorResponseSMB(64, 2);
            return;
        }
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        if (!conn.hasWriteAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        if (conn.getSharedDevice().getType() == 3) {
            IPCHandler.processIPCRequest(this.m_sess, outPkt);
            return;
        }
        int fid = this.m_smbPkt.getParameter(2);
        int offset = this.m_smbPkt.getParameterLong(3);
        int dataLen = this.m_smbPkt.getParameter(10);
        int dataPos = this.m_smbPkt.getParameter(11) + 4;
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null) {
            this.m_sess.sendErrorResponseSMB(6, 1);
            return;
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
            logger.debug((Object)("File Write AndX [" + netFile.getFileId() + "] : Size=" + dataLen + " ,Pos=" + offset));
        }
        byte[] buf = this.m_smbPkt.getBuffer();
        int wrtlen = dataLen;
        try {
            ((JCRNetworkFile)netFile).updateFile(new ByteArrayInputStream(buf, dataPos, dataLen), dataLen, offset);
            logger.debug((Object)(dataLen + " writed to binvalue"));
        }
        catch (AccessDeniedException ex) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(128)) {
                logger.debug((Object)("File Write Error [" + netFile.getFileId() + "] : " + ex.toString()));
            }
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        catch (RepositoryException ex) {
            ex.printStackTrace();
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        outPkt.setParameterCount(6);
        outPkt.setAndXCommand(255);
        outPkt.setParameter(1, 0);
        outPkt.setParameter(2, wrtlen);
        outPkt.setParameter(3, 0);
        outPkt.setParameter(4, 0);
        outPkt.setParameter(5, 0);
        outPkt.setByteCount(0);
        this.m_sess.sendResponseSMB(outPkt);
    }

    public boolean runProtocol() throws IOException, SMBSrvException, TooManyConnectionsException {
        if (this.m_smbPkt == null) {
            this.m_smbPkt = this.m_sess.getReceivePacket();
        }
        if (!this.m_smbPkt.checkPacketSignature()) {
            throw new IOException("Invalid SMB signature");
        }
        SMBSrvPacket outPkt = this.m_smbPkt;
        boolean chainedCmd = this.hasChainedCommand(this.m_smbPkt);
        if (chainedCmd) {
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(2)) {
                logger.debug((Object)("AndX Command = 0x" + Integer.toHexString(this.m_smbPkt.getAndXCommand())));
            }
            outPkt = new SMBSrvPacket(this.m_smbPkt);
        }
        this.m_smbPkt.resetBytePointer();
        boolean handledOK = true;
        switch (this.m_smbPkt.getCommand()) {
            case 115: {
                this.procSessionSetup(outPkt);
                break;
            }
            case 117: {
                this.procTreeConnectAndX(outPkt);
                break;
            }
            case 37: 
            case 50: {
                this.procTransact2(outPkt);
                break;
            }
            case 38: 
            case 51: {
                this.procTransact2Secondary(outPkt);
                break;
            }
            case 52: {
                this.procFindClose(outPkt);
                break;
            }
            case 45: {
                this.procOpenAndX(outPkt);
                break;
            }
            case 46: {
                this.procReadAndX(outPkt);
                break;
            }
            case 47: {
                this.procWriteAndX(outPkt);
                break;
            }
            case 113: {
                this.procTreeDisconnect(outPkt);
                break;
            }
            case 36: {
                this.procLockingAndX(outPkt);
                break;
            }
            case 116: {
                this.procLogoffAndX(outPkt);
                break;
            }
            case 112: {
                super.runProtocol();
                break;
            }
            case 7: {
                this.procRenameFile(outPkt);
                break;
            }
            case 43: {
                super.procEcho(outPkt);
                break;
            }
            default: {
                TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
                if (conn == null) break;
                if (conn.getSharedDevice().getType() == 0 || conn.getSharedDevice().getType() == 1) {
                    handledOK = super.runProtocol();
                    break;
                }
                if (conn.getSharedDevice().getType() != 3) break;
                IPCHandler.processIPCRequest(this.m_sess, outPkt);
                handledOK = true;
            }
        }
        return handledOK;
    }

    private final void processTransactionBuffer(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        switch (tbuf.getFunction()) {
            case 1: {
                this.procTrans2FindFirst(tbuf, outPkt);
                break;
            }
            case 2: {
                this.procTrans2FindNext(tbuf, outPkt);
                break;
            }
            case 3: {
                this.procTrans2QueryFileSys(tbuf, outPkt);
                break;
            }
            case 5: {
                this.procTrans2QueryPath(tbuf, outPkt);
                break;
            }
            default: {
                this.m_sess.sendErrorResponseSMB(64, 2);
            }
        }
    }

    protected final void procTrans2FindFirst(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procTrans2FindFirst");
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(this.m_smbPkt.getUserId());
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = vc.findTreeConnection(treeId);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int srchAttr = paramBuf.getShort();
        int maxFiles = paramBuf.getShort();
        int srchFlag = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        paramBuf.skipBytes(4);
        String srchPath = paramBuf.getString(tbuf.isUnicode());
        StringBuilder path = new StringBuilder(srchPath);
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) != '\\') continue;
            path.setCharAt(i, '/');
        }
        srchPath = NameCoder.DecodeName(path.toString());
        if (srchPath == null || srchPath.length() == 0) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
        SearchContext ctx = null;
        int searchId = -1;
        try {
            searchId = vc.allocateSearchSlot();
            if (searchId == -1) {
                this.m_sess.sendErrorResponseSMB(89, 2);
                return;
            }
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                logger.debug((Object)("Start trans search [" + searchId + "] - " + srchPath + ", attr=0x" + Integer.toHexString(srchAttr) + ", maxFiles=" + maxFiles + ", infoLevel=" + infoLevl + ", flags=0x" + Integer.toHexString(srchFlag)));
            }
            if ((ctx = JCRDriver.startSearch(conn, srchPath, srchAttr)) == null) {
                this.m_sess.sendErrorResponseSMB(2, 1);
                return;
            }
            ctx.setTreeId(treeId);
            ctx.setMaximumFiles(maxFiles);
            vc.setSearchContext(searchId, ctx);
            SrvTransactBuffer replyBuf = new SrvTransactBuffer(tbuf);
            DataBuffer dataBuf = replyBuf.getDataBuffer();
            int maxLen = replyBuf.getReturnDataLimit();
            boolean resumeReq = (srchFlag & 4) != 0;
            int fileCnt = 0;
            int packLen = 0;
            int lastNameOff = 0;
            boolean pktDone = false;
            boolean searchDone = false;
            FileInfo info = new FileInfo();
            while (!pktDone && fileCnt < maxFiles) {
                if (!ctx.nextFileInfo(info)) {
                    pktDone = true;
                    searchDone = true;
                    continue;
                }
                if (FindInfoPacker.calcInfoSize(info, infoLevl, false, true) <= maxLen) {
                    if (resumeReq) {
                        dataBuf.putZeros(4);
                        maxLen -= 4;
                    }
                    lastNameOff = dataBuf.getPosition();
                    packLen = FindInfoPacker.packInfo(info, dataBuf, infoLevl, tbuf.isUnicode());
                    ++fileCnt;
                    maxLen -= packLen;
                    continue;
                }
                pktDone = true;
            }
            paramBuf = replyBuf.getParameterBuffer();
            paramBuf.putShort(searchId);
            paramBuf.putShort(fileCnt);
            paramBuf.putShort(ctx.hasMoreFiles() ? 0 : 1);
            paramBuf.putShort(0);
            paramBuf.putShort(lastNameOff);
            SMBSrvTransPacket tpkt = new SMBSrvTransPacket(outPkt.getBuffer());
            tpkt.doTransactionResponse(this.m_sess, replyBuf);
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                logger.debug((Object)("Search [" + searchId + "] Returned " + fileCnt + " files, moreFiles=" + ctx.hasMoreFiles()));
            }
            if (searchDone) {
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                    logger.debug((Object)("End start search [" + searchId + "] (Search complete)"));
                }
                vc.deallocateSearchSlot(searchId);
            }
        }
        catch (FileNotFoundException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(18, 1);
        }
        catch (UnsupportedInfoLevelException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(65535, 2);
        }
        catch (Exception e) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(65, 2);
        }
    }

    protected final void procTrans2FindNext(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procTrans2FindNext");
        VirtualCircuit vc = this.m_sess.findVirtualCircuit(this.m_smbPkt.getUserId());
        TreeConnection conn = vc.findTreeConnection(this.m_smbPkt.getTreeId());
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int searchId = paramBuf.getShort();
        int maxFiles = paramBuf.getShort();
        int infoLevl = paramBuf.getShort();
        int reskey = paramBuf.getInt();
        int srchFlag = paramBuf.getShort();
        String resumeName = paramBuf.getString(tbuf.isUnicode());
        SearchContext ctx = null;
        try {
            ctx = vc.getSearchContext(searchId);
            if (ctx == null) {
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                    logger.debug((Object)("Search context null - [" + searchId + "]"));
                }
                this.m_sess.sendErrorResponseSMB(18, 1);
                return;
            }
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                logger.debug((Object)("Continue search [" + searchId + "] - " + resumeName + ", maxFiles=" + maxFiles + ", infoLevel=" + infoLevl + ", flags=0x" + Integer.toHexString(srchFlag)));
            }
            SrvTransactBuffer replyBuf = new SrvTransactBuffer(tbuf);
            DataBuffer dataBuf = replyBuf.getDataBuffer();
            int maxLen = replyBuf.getReturnDataLimit();
            boolean resumeReq = (srchFlag & 4) != 0;
            int fileCnt = 0;
            int packLen = 0;
            int lastNameOff = 0;
            boolean pktDone = false;
            boolean searchDone = false;
            FileInfo info = new FileInfo();
            while (!pktDone && fileCnt < maxFiles) {
                if (!ctx.nextFileInfo(info)) {
                    pktDone = true;
                    searchDone = true;
                    continue;
                }
                if (FindInfoPacker.calcInfoSize(info, infoLevl, false, true) <= maxLen) {
                    if (resumeReq) {
                        dataBuf.putZeros(4);
                    }
                    lastNameOff = dataBuf.getPosition();
                    packLen = FindInfoPacker.packInfo(info, dataBuf, infoLevl, tbuf.isUnicode());
                    ++fileCnt;
                    maxLen -= packLen;
                    continue;
                }
                pktDone = true;
            }
            paramBuf = replyBuf.getParameterBuffer();
            paramBuf.putShort(fileCnt);
            paramBuf.putShort(ctx.hasMoreFiles() ? 0 : 1);
            paramBuf.putShort(0);
            paramBuf.putShort(lastNameOff);
            SMBSrvTransPacket tpkt = new SMBSrvTransPacket(outPkt.getBuffer());
            tpkt.doTransactionResponse(this.m_sess, replyBuf);
            if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                logger.debug((Object)("Search [" + searchId + "] Returned " + fileCnt + " files, moreFiles=" + ctx.hasMoreFiles()));
            }
            if (searchDone) {
                if (logger.isDebugEnabled() && this.m_sess.hasDebug(16)) {
                    logger.debug((Object)("End start search [" + searchId + "] (Search complete)"));
                }
                vc.deallocateSearchSlot(searchId);
            }
        }
        catch (FileNotFoundException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(18, 1);
        }
        catch (UnsupportedInfoLevelException ex) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(65535, 2);
        }
        catch (RepositoryException e) {
            if (searchId != -1) {
                vc.deallocateSearchSlot(searchId);
            }
            this.m_sess.sendErrorResponseSMB(65, 2);
        }
    }

    protected final void procTrans2QueryFileSys(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procTrans2QueryFileSys");
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(5, 2);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int infoLevl = paramBuf.getShort();
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(32)) {
            logger.debug((Object)("Query File System Info - level = 0x" + Integer.toHexString(infoLevl)));
        }
        try {
            int prmPos;
            outPkt.setParameterCount(10);
            byte[] buf = outPkt.getBuffer();
            int dataPos = prmPos = DataPacker.longwordAlign(outPkt.getByteOffset());
            DataBuffer replyBuf = new DataBuffer(buf, dataPos, buf.length - dataPos);
            DiskInfo diskInfo = null;
            VolumeInfo volInfo = null;
            switch (infoLevl) {
                case 1: {
                    diskInfo = conn.getSharedDevice().getDiskInformation();
                    DiskInfoPacker.packStandardInfo(diskInfo, replyBuf);
                    break;
                }
                case 2: {
                    volInfo = conn.getSharedDevice().getVolumeInformation();
                    DiskInfoPacker.packVolumeInfo(volInfo, replyBuf, tbuf.isUnicode());
                    break;
                }
                case 258: {
                    volInfo = conn.getSharedDevice().getVolumeInformation();
                    DiskInfoPacker.packFsVolumeInformation(volInfo, replyBuf, tbuf.isUnicode());
                    break;
                }
                case 259: {
                    diskInfo = conn.getSharedDevice().getDiskInformation();
                    DiskInfoPacker.packFsSizeInformation(diskInfo, replyBuf);
                    break;
                }
                case 260: {
                    DiskInfoPacker.packFsDevice(0, 0, replyBuf);
                    break;
                }
                case 261: {
                    DiskInfoPacker.packFsAttribute(0, 255, "JLAN", tbuf.isUnicode(), replyBuf);
                }
            }
            if (replyBuf.getPosition() == dataPos) {
                this.m_sess.sendErrorResponseSMB(65535, 2);
                return;
            }
            int dataLen = replyBuf.getLength();
            SMBSrvTransPacket.initTransactReply(outPkt, 0, prmPos, dataLen, dataPos);
            outPkt.setByteCount(replyBuf.getPosition() - outPkt.getByteOffset());
            this.m_sess.sendResponseSMB(outPkt);
        }
        catch (Exception ex) {
            this.m_sess.sendErrorResponseSMB(13, 1);
            return;
        }
    }

    protected final void procTrans2QueryPath(SrvTransactBuffer tbuf, SMBSrvPacket outPkt) throws IOException, SMBSrvException {
        logger.debug((Object)":procTrans2QueryPath");
        int treeId = this.m_smbPkt.getTreeId();
        TreeConnection conn = this.m_sess.findTreeConnection(this.m_smbPkt);
        if (conn == null) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 6);
            return;
        }
        if (!conn.hasReadAccess()) {
            this.m_sess.sendErrorResponseSMB(5, 1);
            return;
        }
        DataBuffer paramBuf = tbuf.getParameterBuffer();
        int infoLevl = paramBuf.getShort();
        paramBuf.skipBytes(4);
        String path = paramBuf.getString(tbuf.isUnicode());
        if (path.equals("")) {
            path = "/";
        } else {
            StringBuffer pathb = new StringBuffer(path);
            for (int i = 0; i < path.length(); ++i) {
                if (pathb.charAt(i) != '\\') continue;
                pathb.setCharAt(i, '/');
            }
            path = NameCoder.DecodeName(path.toString());
        }
        if (logger.isDebugEnabled() && this.m_sess.hasDebug(32)) {
            logger.debug((Object)("Query Path - level = 0x" + Integer.toHexString(infoLevl) + ", path = " + path));
        }
        try {
            int prmPos;
            outPkt.setParameterCount(10);
            byte[] buf = outPkt.getBuffer();
            int dataPos = prmPos = DataPacker.longwordAlign(outPkt.getByteOffset());
            DataBuffer replyBuf = new DataBuffer(buf, dataPos, buf.length - dataPos);
            Node node = (Node)conn.getSession().getItem(path);
            FileInfo fileInfo = JCRDriver.getFileInformation(node);
            if (fileInfo == null) {
                this.m_sess.sendErrorResponseSMB(-1073741772, 6);
                return;
            }
            int dataLen = QueryInfoPacker.packInfo(fileInfo, replyBuf, infoLevl, true);
            if (dataLen == 0) {
                this.m_sess.sendErrorResponseSMB(-1073741811, 6);
                return;
            }
            SMBSrvTransPacket.initTransactReply(outPkt, 0, prmPos, dataLen, dataPos);
            outPkt.setByteCount(replyBuf.getPosition() - outPkt.getByteOffset());
            this.m_sess.sendResponseSMB(outPkt);
        }
        catch (FileNotFoundException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741772, 6);
            return;
        }
        catch (UnsupportedInfoLevelException ex) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 6);
            return;
        }
        catch (Exception ex) {
            this.m_sess.sendErrorResponseSMB(-1073741811, 6);
            return;
        }
    }
}

