/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.server;

import javax.jcr.Node;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cifs.server.SrvSession;
import org.exoplatform.services.cifs.server.filesys.NetworkFile;
import org.exoplatform.services.cifs.server.filesys.TreeConnection;
import org.exoplatform.services.cifs.smb.NTIOCtl;
import org.exoplatform.services.cifs.smb.SMBException;
import org.exoplatform.services.cifs.smb.server.IOControlNotImplementedException;
import org.exoplatform.services.cifs.util.DataBuffer;
import org.exoplatform.services.log.ExoLogger;

public class IOControlHandler {
    private static Log logger = ExoLogger.getLogger((String)"org.exoplatform.services.cifs.smb.server.IOControlHandler");
    public static final int CmdProbe = 2048;
    public static final int CmdFileStatus = 2049;
    public static final int CmdGetActionInfo = 2052;
    public static final int CmdRunAction = 2053;
    public static final int CmdGetAuthTicket = 2054;
    public static final String Signature = "EXOPLATFORM";

    public static DataBuffer processIOControl(SrvSession sess, TreeConnection conn, int ctrlCode, int fid, DataBuffer dataBuf, boolean isFSCtrl, int filter) throws SMBException, IOControlNotImplementedException {
        NetworkFile netFile = conn.findFile(fid);
        if (netFile == null || !netFile.isDirectory()) {
            throw new SMBException(6, -1073741811);
        }
        int devType = NTIOCtl.getDeviceType(ctrlCode);
        int ioFunc = NTIOCtl.getFunctionCode(ctrlCode);
        if (devType == 9 && ioFunc == 48) {
            return null;
        }
        if (devType != 9 || dataBuf == null) {
            throw new IOControlNotImplementedException();
        }
        if (dataBuf.getLength() < Signature.length()) {
            throw new IOControlNotImplementedException("Bad request length");
        }
        String sig = dataBuf.getString(Signature.length(), false);
        if (sig == null || sig.compareTo(Signature) != 0) {
            throw new IOControlNotImplementedException("Bad request signature");
        }
        Node rootNode = null;
        try {
            rootNode = conn.getSession().getRootNode();
        }
        catch (Exception e) {
            throw new SMBException(6, -1073741790);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("IO control func=0x" + Integer.toHexString(ioFunc) + ", fid=" + fid + ", buffer=" + dataBuf));
        }
        DataBuffer retBuffer = null;
        switch (ioFunc) {
            case 2048: {
                retBuffer = new DataBuffer(Signature.length());
                retBuffer.putFixedString(Signature, Signature.length());
                retBuffer.putInt(0);
                retBuffer.putInt(2);
                break;
            }
            case 2049: {
                retBuffer = IOControlHandler.procIOFileStatus(sess, conn, dataBuf, rootNode);
                break;
            }
            case 2052: {
                retBuffer = IOControlHandler.procGetActionInfo(sess, conn, dataBuf, rootNode, netFile);
                break;
            }
            case 2053: {
                retBuffer = IOControlHandler.procRunAction(sess, conn, dataBuf, rootNode, netFile);
                break;
            }
            default: {
                throw new IOControlNotImplementedException();
            }
        }
        return retBuffer;
    }

    private static final DataBuffer procIOFileStatus(SrvSession sess, TreeConnection tree, DataBuffer reqBuf, Node folderNode) throws SMBException {
        String fName = reqBuf.getString(true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("  File status, fname=" + fName));
        }
        DataBuffer respBuf = new DataBuffer(256);
        respBuf.putFixedString(Signature, Signature.length());
        Node childNode = null;
        try {
            childNode = folderNode.getNode(fName);
        }
        catch (Exception ex) {
            respBuf.putInt(2);
            return respBuf;
        }
        try {
            if (!childNode.isNodeType("nt:file")) {
                respBuf.putInt(0);
                respBuf.putInt(1);
            } else {
                respBuf.putInt(0);
                respBuf.putInt(0);
                respBuf.putInt(0);
                String strLockType = null;
                if (strLockType == null) {
                    respBuf.putInt(0);
                } else {
                    if (strLockType == "READONLY") {
                        respBuf.putInt(strLockType.equalsIgnoreCase("READONLY") ? 1 : 0);
                    }
                    respBuf.putString("", true, true);
                }
                respBuf.putInt(0);
            }
        }
        catch (Exception e) {
            throw new SMBException(65, 2);
        }
        return respBuf;
    }

    private static final DataBuffer procGetActionInfo(SrvSession sess, TreeConnection tree, DataBuffer reqBuf, Node folderNode, NetworkFile netFile) {
        String exeName = reqBuf.getString(true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("  Get action info, exe=" + exeName));
        }
        DataBuffer respBuf = new DataBuffer(256);
        respBuf.putFixedString(Signature, Signature.length());
        respBuf.putInt(6);
        return respBuf;
    }

    private static final DataBuffer procRunAction(SrvSession sess, TreeConnection tree, DataBuffer reqBuf, Node folderNode, NetworkFile netFile) {
        String actionName = reqBuf.getString(true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("  Run action, name=" + actionName));
        }
        DataBuffer respBuf = new DataBuffer(256);
        respBuf.putFixedString(Signature, Signature.length());
        respBuf.putInt(6);
        respBuf.putString("", true);
        return respBuf;
    }

    private static final DataBuffer procGetAuthTicket(SrvSession sess, TreeConnection tree, DataBuffer reqBuf, Node folderNode, NetworkFile netFile) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"  Get Auth Ticket");
        }
        DataBuffer respBuf = new DataBuffer(256);
        respBuf.putFixedString(Signature, Signature.length());
        return respBuf;
    }
}

