/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.server;

import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.exoplatform.services.cifs.ServerConfiguration;
import org.exoplatform.services.cifs.smb.mailslot.TcpipNetBIOSHostAnnouncer;
import org.exoplatform.services.cifs.smb.server.NetBIOSPacketHandler;
import org.exoplatform.services.cifs.smb.server.SMBServer;
import org.exoplatform.services.cifs.smb.server.SMBSrvSession;
import org.exoplatform.services.cifs.smb.server.SessionSocketHandler;

public class NetBIOSSessionSocketHandler
extends SessionSocketHandler {
    private static final ThreadGroup THREAD_GROUP_SESSION = new ThreadGroup("NETBIOS_SESSION_GROUP");

    public NetBIOSSessionSocketHandler(SMBServer srv, int port, InetAddress bindAddr, boolean debug) {
        super("NetBIOS", srv, port, bindAddr, debug);
    }

    public void run() {
        block10: {
            try {
                this.clearShutdown();
                while (!this.hasShutdown()) {
                    if (logger.isDebugEnabled() && this.hasDebug()) {
                        logger.debug((Object)"Waiting for NetBIOS session request ...");
                    }
                    Socket sessSock = this.getSocket().accept();
                    if (logger.isDebugEnabled() && this.hasDebug()) {
                        logger.debug((Object)("NetBIOS session request received from " + sessSock.getInetAddress().getHostAddress()));
                    }
                    try {
                        NetBIOSPacketHandler pktHandler = new NetBIOSPacketHandler(sessSock);
                        SMBSrvSession srvSess = new SMBSrvSession(pktHandler, this.getServer());
                        srvSess.setSessionId(this.getNextSessionId());
                        srvSess.setUniqueId(pktHandler.getShortName() + srvSess.getSessionId());
                        this.getServer().addSession(srvSess);
                        Thread srvThread = new Thread(THREAD_GROUP_SESSION, srvSess);
                        srvThread.setDaemon(true);
                        srvThread.setName("Sess_N" + srvSess.getSessionId() + "_" + sessSock.getInetAddress().getHostAddress());
                        srvThread.start();
                    }
                    catch (Exception ex) {
                        logger.error((Object)"NetBIOS Failed to create session, ", (Throwable)ex);
                    }
                }
            }
            catch (SocketException ex) {
                if (!this.hasShutdown()) {
                    logger.error((Object)"NetBIOS Socket error : ", (Throwable)ex);
                }
            }
            catch (Exception ex) {
                if (this.hasShutdown()) break block10;
                logger.error((Object)"NetBIOS Server error : ", (Throwable)ex);
            }
        }
        if (logger.isDebugEnabled() && this.hasDebug()) {
            logger.debug((Object)"NetBIOS session handler closed");
        }
    }

    public static final void createSessionHandlers(SMBServer server, boolean sockDbg) throws Exception {
        ServerConfiguration config = server.getConfiguration();
        NetBIOSSessionSocketHandler sessHandler = new NetBIOSSessionSocketHandler(server, config.getNetBIOSSessionPort(), config.getSMBBindAddress(), sockDbg);
        sessHandler.initialize();
        server.addSessionHandler(sessHandler);
        Thread nbThread = new Thread(sessHandler);
        nbThread.setName("NetBIOS_Handler");
        nbThread.start();
        if (logger.isDebugEnabled() && sockDbg) {
            logger.debug((Object)("TCP NetBIOS session handler created on port " + config.getNetBIOSSessionPort()));
        }
        if (config.hasEnableAnnouncer()) {
            TcpipNetBIOSHostAnnouncer announcer = new TcpipNetBIOSHostAnnouncer();
            announcer.addHostName(config.getServerName());
            announcer.setDomain(config.getDomainName());
            announcer.setComment(config.getComment());
            announcer.setBindAddress(config.getSMBBindAddress());
            announcer.setPort(config.getNetBIOSDatagramPort());
            if (config.getHostAnnounceInterval() > 0) {
                announcer.setInterval(config.getHostAnnounceInterval());
            }
            try {
                announcer.setBroadcastAddress(config.getBroadcastMask());
            }
            catch (Exception ex) {
                // empty catch block
            }
            announcer.setServerType(config.getServerType());
            announcer.setDebug(true);
            server.addHostAnnouncer(announcer);
            announcer.start();
            if (logger.isDebugEnabled() && sockDbg) {
                logger.debug((Object)("TCP NetBIOS host announcer created on port " + config.getNetBIOSDatagramPort()));
            }
        }
    }
}

