/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.server.core;

import org.exoplatform.services.cifs.server.core.ShareType;
import org.exoplatform.services.cifs.server.filesys.DiskInfo;
import org.exoplatform.services.cifs.server.filesys.VolumeInfo;

public class SharedDevice {
    public static final int ADMIN = 1;
    public static final int HIDDEN = 2;
    public static final int READONLY = 4;
    public static final int TEMPORARY = 8;
    private String name;
    private int type;
    private String comments;
    private int attrib;
    private int maxUses = -1;
    private int curUses = 0;
    private DiskInfo diskinfo;
    private VolumeInfo volinfo;

    public SharedDevice() {
    }

    public SharedDevice(String name, int type) {
        this.name = name;
        this.type = type;
    }

    public void setName(String s) {
        this.name = s;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setComments(String com) {
        this.comments = com;
    }

    public void setAttributes(int i) {
        this.attrib = i;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public String getComments() {
        return this.comments;
    }

    public int getAttributes() {
        return this.attrib;
    }

    public final boolean isAdmin() {
        return (this.attrib & 1) != 0;
    }

    public final boolean isHidden() {
        return (this.attrib & 2) != 0;
    }

    public final boolean isReadOnly() {
        return (this.attrib & 4) != 0;
    }

    public final boolean isTemporary() {
        return (this.attrib & 8) != 0;
    }

    public synchronized void incrementConnectionCount() {
        ++this.curUses;
    }

    public synchronized void decrementConnectionCount() {
        --this.curUses;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getName());
        str.append(",");
        str.append(ShareType.TypeAsString(this.getType()));
        str.append(",");
        if (this.isAdmin()) {
            str.append(",Admin");
        }
        if (this.isHidden()) {
            str.append(",Hidden");
        }
        if (this.isReadOnly()) {
            str.append(",ReadOnly");
        }
        if (this.isTemporary()) {
            str.append(",Temp");
        }
        str.append("]");
        return str.toString();
    }

    public DiskInfo getDiskInformation() {
        return this.diskinfo;
    }

    public VolumeInfo getVolumeInformation() {
        return this.volinfo;
    }

    public void setDiskInfo(DiskInfo di) {
        this.diskinfo = di;
    }

    public void setVolumeInfo(VolumeInfo vi) {
        this.volinfo = vi;
    }
}

