/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.server;

import org.exoplatform.services.cifs.util.DataPacker;

public class NTParameterPacker {
    private byte[] m_buf;
    private int m_pos;

    public NTParameterPacker(byte[] buf) {
        this.m_buf = buf;
        this.m_pos = 37;
    }

    public NTParameterPacker(byte[] buf, int pos) {
        this.m_buf = buf;
        this.m_pos = pos;
    }

    public final void packByte(byte val) {
        this.m_buf[this.m_pos++] = val;
    }

    public final void packByte(int val) {
        this.m_buf[this.m_pos++] = (byte)val;
    }

    public final void packWord(int val) {
        DataPacker.putIntelShort(val, this.m_buf, this.m_pos);
        this.m_pos += 2;
    }

    public final void packInt(int val) {
        DataPacker.putIntelInt(val, this.m_buf, this.m_pos);
        this.m_pos += 4;
    }

    public final void packLong(long val) {
        DataPacker.putIntelLong(val, this.m_buf, this.m_pos);
        this.m_pos += 8;
    }

    public final int getPosition() {
        return this.m_pos;
    }

    public final byte[] getBuffer() {
        return this.m_buf;
    }

    public final int unpackByte() {
        return this.m_buf[this.m_pos++];
    }

    public final int unpackWord() {
        int val = DataPacker.getIntelShort(this.m_buf, this.m_pos);
        this.m_pos += 2;
        return val;
    }

    public final int unpackInt() {
        int val = DataPacker.getIntelInt(this.m_buf, this.m_pos);
        this.m_pos += 4;
        return val;
    }

    public final long unpackLong() {
        long val = DataPacker.getIntelLong(this.m_buf, this.m_pos);
        this.m_pos += 8;
        return val;
    }

    public final void reset(byte[] buf, int pos) {
        this.m_buf = buf;
        this.m_pos = pos;
    }
}

