/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.mailslot;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.exoplatform.services.cifs.netbios.NetBIOSDatagram;
import org.exoplatform.services.cifs.netbios.NetBIOSDatagramSocket;
import org.exoplatform.services.cifs.netbios.NetworkSettings;
import org.exoplatform.services.cifs.smb.mailslot.HostAnnouncer;

public class TcpipNetBIOSHostAnnouncer
extends HostAnnouncer {
    public static final int PORT = 138;
    public static final int INTERVAL = 1;
    private InetAddress m_bindAddress;
    private int m_port;
    private InetAddress m_bcastAddr;
    private NetBIOSDatagram m_nbdgram;

    public TcpipNetBIOSHostAnnouncer() {
        this.setPort(138);
        this.setInterval(1);
    }

    public TcpipNetBIOSHostAnnouncer(String name, String domain, int intval, int port) {
        this.addHostName(name);
        this.setDomain(domain);
        this.setInterval(intval);
        if (port == 0) {
            this.setPort(138);
        } else {
            this.setPort(port);
        }
    }

    public final InetAddress getBindAddress() {
        return this.m_bindAddress;
    }

    public final int getPort() {
        return this.m_port;
    }

    public final boolean hasBindAddress() {
        return this.m_bindAddress != null;
    }

    public final void setBroadcastAddress(String addr) throws UnknownHostException {
        this.m_bcastAddr = InetAddress.getByName(addr);
    }

    public final void setBroadcastAddress(String addr, int port) throws UnknownHostException {
        this.m_bcastAddr = InetAddress.getByName(addr);
        this.m_port = port;
    }

    protected void initialize() throws Exception {
        if (!this.hasBindAddress()) {
            this.setName("TCPHostAnnouncer");
        } else {
            this.setName("TCPHostAnnouncer_" + this.getBindAddress().getHostAddress());
        }
        if (this.numberOfNames() == 0) {
            this.addHostName(InetAddress.getLocalHost().getHostName());
        }
        this.m_nbdgram = new NetBIOSDatagram(512);
        if (this.m_bcastAddr == null) {
            this.m_bcastAddr = InetAddress.getByName(NetworkSettings.GenerateBroadcastMask(null));
        }
    }

    public boolean isNetworkEnabled() {
        return true;
    }

    protected void sendAnnouncement(String hostName, byte[] buf, int offset, int len) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Send NetBIOS host announcement to " + this.m_bcastAddr.getHostAddress() + ", used port " + this.getPort()));
        }
        this.m_nbdgram.SendDatagram(18, hostName, ' ', this.getDomain(), '\u001d', buf, len, offset, this.m_bcastAddr, this.getPort());
    }

    public final void setBindAddress(InetAddress addr) {
        this.m_bindAddress = addr;
        NetBIOSDatagramSocket.setBindAddress(addr);
    }

    public final void setPort(int port) {
        this.m_port = port;
        NetBIOSDatagramSocket.setDefaultPort(port);
    }
}

