/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cifs.netbios.NetBIOSException;
import org.exoplatform.services.cifs.netbios.NetBIOSPacket;
import org.exoplatform.services.cifs.netbios.NetBIOSSession;
import org.exoplatform.services.cifs.server.SrvSession;
import org.exoplatform.services.cifs.server.auth.NTLanManAuthContext;
import org.exoplatform.services.cifs.server.core.SharedDevice;
import org.exoplatform.services.cifs.server.filesys.DiskInfo;
import org.exoplatform.services.cifs.server.filesys.TooManyConnectionsException;
import org.exoplatform.services.cifs.server.filesys.TreeConnection;
import org.exoplatform.services.cifs.server.filesys.VolumeInfo;
import org.exoplatform.services.cifs.smb.Dialect;
import org.exoplatform.services.cifs.smb.DialectSelector;
import org.exoplatform.services.cifs.smb.NTTime;
import org.exoplatform.services.cifs.smb.SMBDate;
import org.exoplatform.services.cifs.smb.SMBErrorText;
import org.exoplatform.services.cifs.smb.server.NTParameterPacker;
import org.exoplatform.services.cifs.smb.server.PacketHandler;
import org.exoplatform.services.cifs.smb.server.ProtocolFactory;
import org.exoplatform.services.cifs.smb.server.ProtocolHandler;
import org.exoplatform.services.cifs.smb.server.SMBServer;
import org.exoplatform.services.cifs.smb.server.SMBSrvException;
import org.exoplatform.services.cifs.smb.server.SMBSrvPacket;
import org.exoplatform.services.cifs.smb.server.SMBSrvSessionState;
import org.exoplatform.services.cifs.smb.server.SrvTransactBuffer;
import org.exoplatform.services.cifs.smb.server.VirtualCircuit;
import org.exoplatform.services.cifs.util.DataPacker;
import org.exoplatform.services.cifs.util.StringList;
import org.exoplatform.services.log.ExoLogger;

public class SMBSrvSession
extends SrvSession
implements Runnable {
    private static Log logger = ExoLogger.getLogger((String)"org.exoplatform.services.cifs.smb.server.SMBSrvSession");
    public static final int DefaultBufferSize = 65540;
    public static final int LanManBufferSize = 8192;
    public static final int DefaultCircuits = 4;
    public static final int MaxCircuits = 16;
    private static final int UIdMask = 65535;
    public static final int LanManMaxMultiplexed = 1;
    public static final int NTMaxMultiplexed = 4;
    private Hashtable<Integer, VirtualCircuit> vcircuits;
    private int nextUID;
    private PacketHandler m_pktHandler;
    private byte[] m_buf;
    private int m_rxlen;
    private SMBSrvPacket m_smbPkt;
    private ProtocolHandler m_handler;
    private int m_state = 0;
    private int m_dialect = -1;
    private String m_callerNBName;
    private String m_targetNBName;
    private SrvTransactBuffer m_transact;
    private int m_defFlags;
    private int m_defFlags2;
    private Vector<SMBSrvPacket> m_asynchQueue;
    private int m_maxBufSize;
    private int m_maxMultiplex;
    private int m_clientCaps;
    private Object m_setupObject;
    public static final int DBG_NETBIOS = 1;
    public static final int DBG_STATE = 2;
    public static final int DBG_NEGOTIATE = 4;
    public static final int DBG_TREE = 8;
    public static final int DBG_SEARCH = 16;
    public static final int DBG_INFO = 32;
    public static final int DBG_FILE = 64;
    public static final int DBG_FILEIO = 128;
    public static final int DBG_TRAN = 256;
    public static final int DBG_ECHO = 512;
    public static final int DBG_ERROR = 1024;
    public static final int DBG_IPC = 2048;
    public static final int DBG_LOCK = 4096;
    public static final int DBG_PKTTYPE = 8192;
    public static final int DBG_DCERPC = 16384;
    public static final int DBG_STATECACHE = 32768;
    public static final int DBG_NOTIFY = 65536;
    public static final int DBG_STREAMS = 131072;
    public static final int DBG_SOCKET = 262144;

    public SMBSrvSession(PacketHandler handler, SMBServer srv) {
        super(-1, srv, handler.isProtocolName(), null);
        this.m_pktHandler = handler;
        this.m_buf = new byte[65540];
        this.m_smbPkt = new SMBSrvPacket(this.m_buf);
        if (this.isProtocol() == 1 || this.isProtocol() == 2) {
            this.setState(1);
            if (handler.hasClientName()) {
                this.m_callerNBName = handler.getClientName();
            }
        }
    }

    public final int isProtocol() {
        return this.m_pktHandler.isProtocol();
    }

    public final TreeConnection findTreeConnection(SMBSrvPacket smbPkt) {
        TreeConnection tree = null;
        VirtualCircuit vc = this.findVirtualCircuit(smbPkt.getUserId());
        if (vc != null) {
            tree = vc.findTreeConnection(smbPkt.getTreeId());
        }
        return tree;
    }

    protected final void cleanupSession() {
        block7: {
            if (logger.isDebugEnabled() && this.hasDebug(2)) {
                logger.debug((Object)("Cleanup session, vcircuits=" + this.getCircuitCount()));
            }
            if (this.vcircuits != null && this.vcircuits.size() > 0) {
                Enumeration<Integer> uidEnum = this.vcircuits.keys();
                while (uidEnum.hasMoreElements()) {
                    Integer uid = uidEnum.nextElement();
                    VirtualCircuit vc = this.vcircuits.get(new Integer(uid));
                    if (vc == null) continue;
                    if (logger.isDebugEnabled() && this.hasDebug(2)) {
                        logger.debug((Object)("  Cleanup vc=" + vc));
                    }
                    vc.closeCircuit(this);
                }
                this.vcircuits.clear();
            }
            try {
                this.endTransaction();
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block7;
                logger.debug((Object)"Error committing transaction", (Throwable)ex);
            }
        }
        if (this.hasDynamicShares()) {
            this.getDynamicShares().removeAllShares();
        }
    }

    protected final void closeSocket() {
        this.setShutdown(true);
        try {
            this.m_pktHandler.closeHandler();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void closeSession() {
        super.closeSession();
        try {
            this.setState(5);
            this.setShutdown(true);
            this.m_pktHandler.closeHandler();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void finalize() {
        this.cleanupSession();
        this.closeSocket();
    }

    protected final byte[] getBuffer() {
        return this.m_buf;
    }

    public final int getDefaultFlags() {
        return this.m_defFlags;
    }

    public final int getDefaultFlags2() {
        return this.m_defFlags2;
    }

    public final int getClientMaximumBufferSize() {
        return this.m_maxBufSize;
    }

    public final int getClientMaximumMultiplex() {
        return this.m_maxMultiplex;
    }

    public final int getClientCapabilities() {
        return this.m_clientCaps;
    }

    public final boolean hasClientCapability(int cap) {
        return (this.m_clientCaps & cap) != 0;
    }

    public final int getNegotiatedSMBDialect() {
        return this.m_dialect;
    }

    public final PacketHandler getPacketHandler() {
        return this.m_pktHandler;
    }

    public final SMBSrvPacket getReceivePacket() {
        return this.m_smbPkt;
    }

    public final String getRemoteNetBIOSName() {
        return this.m_callerNBName;
    }

    public final boolean hasTargetNetBIOSName() {
        return this.m_targetNBName != null;
    }

    public final String getTargetNetBIOSName() {
        return this.m_targetNBName;
    }

    public final boolean hasRemoteAddress() {
        return this.m_pktHandler.hasRemoteAddress();
    }

    public final InetAddress getRemoteAddress() {
        return this.m_pktHandler.getRemoteAddress();
    }

    public final SMBServer getSMBServer() {
        return (SMBServer)this.getServer();
    }

    public final String getServerName() {
        return this.getSMBServer().getServerName();
    }

    public final int isState() {
        return this.m_state;
    }

    private void hangupSession(String reason) {
        if (logger.isDebugEnabled() && this.hasDebug(1)) {
            logger.debug((Object)("## Session closing - " + reason));
        }
        this.setState(5);
    }

    public final boolean hasMacintoshExtensions() {
        return this.getSMBServer().getConfiguration().hasMacintoshExtensions();
    }

    public final boolean hasSetupObject() {
        return this.m_setupObject != null;
    }

    public final Object getSetupObject() {
        return this.m_setupObject;
    }

    public final void setSetupObject(Object obj) {
        this.m_setupObject = obj;
    }

    public final void setClientMaximumBufferSize(int maxBuf) {
        this.m_maxBufSize = maxBuf;
    }

    public final void setClientMaximumMultiplex(int maxMpx) {
        this.m_maxMultiplex = maxMpx;
    }

    public final void setClientCapabilities(int flags) {
        this.m_clientCaps = flags;
    }

    public final void setDefaultFlags(int flags) {
        this.m_defFlags = flags;
    }

    public final void setDefaultFlags2(int flags) {
        this.m_defFlags2 = flags;
    }

    public final void setReceivePacket(SMBSrvPacket pkt) {
        this.m_smbPkt = pkt;
        this.m_buf = pkt.getBuffer();
    }

    protected void setState(int state) {
        if (logger.isDebugEnabled() && this.hasDebug(2)) {
            logger.debug((Object)("State changed to " + SMBSrvSessionState.getStateAsString(state)));
        }
        this.m_state = state;
    }

    protected void procNetBIOSSessionRequest() throws IOException, NetBIOSException {
        NetBIOSPacket nbPkt = new NetBIOSPacket(this.m_buf);
        if (this.m_rxlen < 72 || nbPkt.getHeaderType() != 129) {
            throw new NetBIOSException("NBREQ Invalid packet");
        }
        if (this.m_buf[4] != 32 || this.m_buf[38] != 32) {
            throw new NetBIOSException("NBREQ Invalid NetBIOS name data");
        }
        StringBuffer nbName = new StringBuffer(32);
        for (int i = 0; i < 32; ++i) {
            nbName.append((char)this.m_buf[5 + i]);
        }
        String toName = NetBIOSSession.DecodeName(nbName.toString());
        toName = toName.trim();
        nbName.setLength(0);
        for (int i = 0; i < 32; ++i) {
            nbName.append((char)this.m_buf[39 + i]);
        }
        String fromName = NetBIOSSession.DecodeName(nbName.toString());
        fromName = fromName.trim();
        if (logger.isDebugEnabled() && this.hasDebug(1)) {
            logger.debug((Object)("NetBIOS CALL From " + fromName + " to " + toName));
        }
        boolean forThisServer = false;
        if (toName.compareTo(this.getServerName()) == 0 || toName.compareTo("*SMBSERVER") == 0 || toName.compareTo("*SMBSERV") == 0 || toName.compareTo("*") == 0) {
            forThisServer = true;
        } else {
            InetAddress[] srvAddr = this.getSMBServer().getServerAddresses();
            if (srvAddr != null) {
                int idx = 0;
                while (idx < srvAddr.length && !forThisServer) {
                    if (srvAddr[idx++].getHostAddress().compareTo(toName) != 0) continue;
                    forThisServer = true;
                }
            }
        }
        if (!forThisServer) {
            throw new NetBIOSException("NBREQ Called name is not this server (" + toName + ")");
        }
        if (logger.isDebugEnabled() && this.hasDebug(1)) {
            logger.debug((Object)("NetBIOS session request from " + fromName));
        }
        this.m_callerNBName = fromName;
        this.m_targetNBName = toName;
        this.setRemoteName(fromName);
        nbPkt.setHeaderType(130);
        nbPkt.setHeaderFlags(0);
        nbPkt.setHeaderLength(0);
        this.m_pktHandler.writePacket(this.m_buf, 0, 4);
        this.setState(1);
    }

    protected void procSMBNegotiate() throws SMBSrvException, IOException {
        this.m_smbPkt = new SMBSrvPacket(this.m_buf);
        this.m_buf[0] = 0;
        if (this.m_smbPkt.getCommand() != 114 || !this.m_smbPkt.checkPacketIsValid(0, 2)) {
            this.sendErrorResponseSMB(64, 2);
            return;
        }
        int dataPos = this.m_smbPkt.getByteOffset();
        String diaStr = null;
        StringList dialects = new StringList();
        for (int dataLen = this.m_smbPkt.getByteCount(); dataLen > 0; dataLen -= diaStr.length() + 2) {
            diaStr = DataPacker.getDataString('\u0002', this.m_buf, dataPos, dataLen, false);
            if (diaStr == null) {
                this.sendErrorResponseSMB(1, 2);
                this.setState(5);
                return;
            }
            dialects.addString(diaStr);
            dataPos += diaStr.length() + 2;
        }
        DialectSelector dia = this.getSMBServer().getConfiguration().getEnabledDialects();
        int diaIdx = -1;
        for (int i = 0; i < 8; ++i) {
            if (!dia.hasDialect(i)) continue;
            for (int j = 0; j < Dialect.SMB_PROT_MAXSTRING; ++j) {
                if (Dialect.DialectType(j) != i || !dialects.containsString(Dialect.DialectString(j)) || i <= diaIdx) continue;
                diaIdx = i;
            }
        }
        if (logger.isDebugEnabled() && this.hasDebug(4)) {
            if (diaIdx == -1) {
                logger.debug((Object)"Failed to negotiate SMB dialect");
            } else {
                logger.debug((Object)("Negotiated SMB dialect - " + Dialect.DialectTypeString(diaIdx)));
            }
        }
        if (diaIdx != -1) {
            this.m_dialect = diaIdx;
            diaIdx = dialects.findString(Dialect.DialectTypeString(diaIdx));
            this.m_handler = ProtocolFactory.getHandler(this.m_dialect);
            if (this.m_handler != null) {
                if (logger.isDebugEnabled() && this.hasDebug(4)) {
                    logger.debug((Object)("Assigned protocol handler - " + this.m_handler.getClass().getName()));
                }
                this.m_handler.setSession(this);
            } else {
                diaIdx = -1;
            }
        }
        boolean extendedSecurity = false;
        if (this.m_dialect == -1 || this.m_dialect <= 1) {
            this.m_smbPkt.setParameterCount(1);
            this.m_smbPkt.setParameter(0, diaIdx);
            this.m_smbPkt.setByteCount(0);
            this.m_smbPkt.setTreeId(0);
            this.m_smbPkt.setUserId(0);
        } else {
            if (this.m_dialect <= 6) {
                this.m_smbPkt.setFlags2(1);
                this.m_smbPkt.setParameterCount(13);
                this.m_smbPkt.setParameter(0, diaIdx);
                int securityMode = this.getServer().getConfiguration().getSecurity();
                this.m_smbPkt.setParameter(1, securityMode);
                this.m_smbPkt.setParameter(2, 8192);
                this.m_smbPkt.setParameter(3, 1);
                this.m_smbPkt.setParameter(4, 16);
                this.m_smbPkt.setParameter(5, 0);
                this.m_smbPkt.setParameterLong(6, (int)(System.currentTimeMillis() & 0xFFFFFFFFFFFFFFFFL));
                SMBDate srvDate = new SMBDate(System.currentTimeMillis());
                this.m_smbPkt.setParameter(8, srvDate.asSMBTime());
                this.m_smbPkt.setParameter(9, srvDate.asSMBDate());
                this.m_smbPkt.setParameter(10, this.getServer().getConfiguration().getTimeZoneOffset());
                this.m_smbPkt.setParameter(11, 8);
                this.m_smbPkt.setParameter(12, 0);
                this.m_smbPkt.setTreeId(0);
                this.m_smbPkt.setUserId(0);
                try {
                    String domain;
                    NTLanManAuthContext authCtx;
                    if (this.hasAuthenticationContext() && this.getAuthenticationContext() instanceof NTLanManAuthContext) {
                        authCtx = (NTLanManAuthContext)this.getAuthenticationContext();
                    } else {
                        authCtx = new NTLanManAuthContext();
                        this.setAuthenticationContext(authCtx);
                    }
                    int pos = this.m_smbPkt.getByteOffset();
                    byte[] buf = this.m_smbPkt.getBuffer();
                    if (authCtx.getChallenge() == null) {
                        for (int i = 0; i < 8; ++i) {
                            buf[pos++] = 0;
                        }
                    } else {
                        byte[] key = authCtx.getChallenge();
                        for (int i = 0; i < key.length; ++i) {
                            buf[pos++] = key[i];
                        }
                    }
                    if ((domain = this.getServer().getConfiguration().getDomainName()) != null) {
                        pos = DataPacker.putString(domain, buf, pos, true, true);
                    }
                    pos = DataPacker.putString(this.getServer().getServerName(), buf, pos, true, true);
                    this.m_smbPkt.setByteCount(pos - this.m_smbPkt.getByteOffset());
                }
                catch (Exception ex) {
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)"Negotiate error", (Throwable)ex);
                    }
                    this.setState(5);
                    return;
                }
            }
            if (this.m_dialect == 7) {
                this.setDefaultFlags(8);
                this.setDefaultFlags2(32769);
                NTParameterPacker nt = new NTParameterPacker(this.m_smbPkt.getBuffer());
                this.m_smbPkt.setParameterCount(17);
                nt.packWord(diaIdx);
                int securityMode = this.getServer().getConfiguration().getSecurity();
                nt.packByte(securityMode);
                nt.packWord(4);
                nt.packWord(16);
                int maxBufSize = this.m_smbPkt.getBuffer().length - 4;
                nt.packInt(maxBufSize);
                nt.packInt(0);
                nt.packInt((int)(System.currentTimeMillis() & 0xFFFFFFFFL));
                int srvCapabs = 49244;
                if (!extendedSecurity) {
                    srvCapabs &= Integer.MAX_VALUE;
                }
                nt.packInt(srvCapabs);
                long srvTime = NTTime.toNTTime(new Date(System.currentTimeMillis()));
                nt.packLong(srvTime);
                nt.packWord(this.getServer().getConfiguration().getTimeZoneOffset());
                nt.packByte(8);
                this.m_smbPkt.setFlags(this.getDefaultFlags());
                this.m_smbPkt.setFlags2(this.getDefaultFlags2());
                this.m_smbPkt.setTreeId(0);
                this.m_smbPkt.setUserId(0);
                try {
                    String domain;
                    NTLanManAuthContext authCtx;
                    if (this.hasAuthenticationContext() && this.getAuthenticationContext() instanceof NTLanManAuthContext) {
                        authCtx = (NTLanManAuthContext)this.getAuthenticationContext();
                    } else {
                        authCtx = new NTLanManAuthContext();
                        this.setAuthenticationContext(authCtx);
                    }
                    int pos = this.m_smbPkt.getByteOffset();
                    byte[] buf = this.m_smbPkt.getBuffer();
                    if (authCtx.getChallenge() == null) {
                        for (int i = 0; i < 8; ++i) {
                            buf[pos++] = 0;
                        }
                    } else {
                        byte[] key = authCtx.getChallenge();
                        for (int i = 0; i < key.length; ++i) {
                            buf[pos++] = key[i];
                        }
                    }
                    if ((domain = this.getServer().getConfiguration().getDomainName()) != null) {
                        pos = DataPacker.putString(domain, buf, pos, true, true);
                    }
                    pos = DataPacker.putString(this.getServer().getServerName(), buf, pos, true, true);
                    this.m_smbPkt.setByteCount(pos - this.m_smbPkt.getByteOffset());
                }
                catch (Exception ex) {
                    if (logger.isErrorEnabled()) {
                        logger.error((Object)"Negotiate error", (Throwable)ex);
                    }
                    this.setState(5);
                    return;
                }
            }
        }
        if (!this.m_smbPkt.isResponse()) {
            this.m_smbPkt.setFlags(this.m_smbPkt.getFlags() + 128);
        }
        this.m_pktHandler.writePacket(this.m_smbPkt, this.m_smbPkt.getLength());
        if (this.m_dialect == -1) {
            this.setState(5);
        } else if (Dialect.DialectSupportsCommand(this.m_dialect, 115)) {
            this.setState(2);
        } else {
            this.setState(3);
        }
        if (this.m_dialect != -1) {
            this.getSMBServer().sessionOpened(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (logger.isDebugEnabled() && this.hasDebug(4)) {
                logger.debug((Object)"Server session started");
            }
            while (this.m_state != 5) {
                block33: {
                    this.m_rxlen = -1;
                    this.m_rxlen = this.m_pktHandler.readPacket(this.m_smbPkt);
                    if (this.m_rxlen == 0) continue;
                    if (this.m_rxlen == -1) {
                        this.hangupSession("Remote disconnect");
                        continue;
                    }
                    this.m_smbPkt.setReceivedLength(this.m_rxlen);
                    ++this.m_reqCount;
                    switch (this.m_state) {
                        case 0: {
                            this.procNetBIOSSessionRequest();
                            break;
                        }
                        case 1: {
                            this.procSMBNegotiate();
                            this.mapWorkspacesAsShares();
                            break;
                        }
                        case 2: {
                            this.m_handler.runProtocol();
                            break;
                        }
                        case 3: {
                            this.runHandler();
                        }
                    }
                    try {
                        this.endTransaction();
                    }
                    catch (Exception ex) {
                        if (!logger.isDebugEnabled()) break block33;
                        logger.debug((Object)"Error committing transaction", (Throwable)ex);
                    }
                }
                Thread.yield();
            }
        }
        catch (SocketException ex) {
            logger.error((Object)"Socket closed by remote client");
        }
        catch (Exception ex) {
            if (!this.isShutdown()) {
                logger.error((Object)"Closing session due to exception", (Throwable)ex);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            logger.error((Object)"Closing session due to throwable", ex);
        }
        finally {
            if (this.hasUserTransaction()) {
                try {
                    this.getUserTransaction().rollback();
                }
                catch (Exception ex) {
                    logger.warn((Object)"Failed to rollback transaction", (Throwable)ex);
                }
            }
        }
        this.cleanupSession();
        if (logger.isDebugEnabled() && this.hasDebug(2)) {
            logger.debug((Object)"Server session closed");
        }
        this.closeSocket();
        this.getSMBServer().sessionClosed(this);
    }

    protected final void runHandler() throws IOException, SMBSrvException, TooManyConnectionsException {
        if (this.m_rxlen < 4) {
            return;
        }
        if (logger.isDebugEnabled() && this.hasDebug(8192)) {
            logger.debug((Object)("Rx packet type - " + this.m_smbPkt.getPacketTypeString() + ", SID=" + this.m_smbPkt.getSID()));
        }
        if (!this.m_handler.runProtocol()) {
            this.sendErrorResponseSMB(65535, 2);
        }
        while (this.hasAsynchResponse()) {
            SMBSrvPacket asynchPkt = this.removeFirstAsynchResponse();
            this.sendResponseSMB(asynchPkt, asynchPkt.getLength());
            if (!logger.isDebugEnabled() || !this.hasDebug(65536)) continue;
            logger.debug((Object)("Sent queued asynch response type=" + asynchPkt.getPacketTypeString() + ", mid=" + asynchPkt.getMultiplexId() + ", pid=" + asynchPkt.getProcessId()));
        }
    }

    public final void sendResponseSMB(SMBSrvPacket pkt) throws IOException {
        this.sendResponseSMB(pkt, pkt.getLength());
    }

    public final synchronized void sendResponseSMB(SMBSrvPacket pkt, int len) throws IOException {
        if (!pkt.isResponse()) {
            pkt.setFlags(pkt.getFlags() + 128);
        }
        pkt.setFlags(pkt.getFlags() | this.getDefaultFlags());
        int flags2 = pkt.getFlags2() | this.getDefaultFlags2();
        pkt.setFlags2(flags2 &= 0xFFFFEFF9);
        this.m_pktHandler.writePacket(pkt, len);
        this.m_pktHandler.flushPacket();
    }

    public final void sendSuccessResponseSMB() throws IOException {
        if (!this.m_smbPkt.isResponse()) {
            this.m_smbPkt.setFlags(this.m_smbPkt.getFlags() + 128);
        }
        this.m_smbPkt.setFlags(this.m_smbPkt.getFlags() | this.getDefaultFlags());
        this.m_smbPkt.setFlags2(this.m_smbPkt.getFlags2() | this.getDefaultFlags2());
        this.m_smbPkt.setParameterCount(0);
        this.m_smbPkt.setByteCount(0);
        if (this.m_smbPkt.isLongErrorCode()) {
            this.m_smbPkt.setLongErrorCode(0);
        } else {
            this.m_smbPkt.setErrorClass(0);
            this.m_smbPkt.setErrorCode(0);
        }
        this.sendResponseSMB(this.m_smbPkt, this.m_smbPkt.getLength());
    }

    public final void sendErrorResponseSMB(int ntCode, int stdCode, int stdClass) throws IOException {
        if (this.m_smbPkt.isLongErrorCode()) {
            if (ntCode != -1) {
                this.sendErrorResponseSMB(ntCode, 6);
            } else {
                this.sendErrorResponseSMB(stdCode, stdClass);
            }
        } else {
            this.sendErrorResponseSMB(stdCode, stdClass);
        }
    }

    public final void sendErrorResponseSMB(int errCode, int errClass) throws IOException {
        if (!this.m_smbPkt.isResponse()) {
            this.m_smbPkt.setFlags(this.m_smbPkt.getFlags() + 128);
        }
        this.m_smbPkt.setParameterCount(0);
        this.m_smbPkt.setByteCount(0);
        this.m_smbPkt.setFlags(this.m_smbPkt.getFlags() | this.getDefaultFlags());
        this.m_smbPkt.setFlags2(this.m_smbPkt.getFlags2() | this.getDefaultFlags2());
        if (errClass == 6) {
            if (!this.m_smbPkt.isLongErrorCode()) {
                this.m_smbPkt.setFlags2(this.m_smbPkt.getFlags2() + 16384);
            }
            this.m_smbPkt.setLongErrorCode(errCode);
        } else {
            if (this.m_smbPkt.isLongErrorCode()) {
                this.m_smbPkt.setFlags2(this.m_smbPkt.getFlags2() - 16384);
            }
            this.m_smbPkt.setErrorCode(errCode);
            this.m_smbPkt.setErrorClass(errClass);
        }
        this.sendResponseSMB(this.m_smbPkt, this.m_smbPkt.getLength());
        if (logger.isDebugEnabled() && this.hasDebug(1024)) {
            logger.debug((Object)("Error : Cmd = " + this.m_smbPkt.getPacketTypeString() + " - " + SMBErrorText.ErrorString(errClass, errCode)));
        }
    }

    public final boolean sendAsynchResponseSMB(SMBSrvPacket pkt, int len) throws IOException {
        boolean sts = false;
        if (this.m_rxlen == -1 && this.m_pktHandler.availableBytes() == 0) {
            this.sendResponseSMB(pkt, len);
            this.m_pktHandler.flushPacket();
            sts = true;
        } else {
            this.queueAsynchResponseSMB(pkt);
        }
        return sts;
    }

    protected final synchronized void queueAsynchResponseSMB(SMBSrvPacket pkt) {
        if (this.m_asynchQueue == null) {
            this.m_asynchQueue = new Vector();
        }
        this.m_asynchQueue.addElement(pkt);
    }

    protected final synchronized boolean hasAsynchResponse() {
        return this.m_asynchQueue != null && this.m_asynchQueue.size() > 0;
    }

    protected final synchronized SMBSrvPacket removeFirstAsynchResponse() {
        if (this.m_asynchQueue == null || this.m_asynchQueue.size() == 0) {
            return null;
        }
        return this.m_asynchQueue.remove(0);
    }

    protected final boolean hasTransaction() {
        return this.m_transact != null;
    }

    protected final SrvTransactBuffer getTransaction() {
        return this.m_transact;
    }

    protected final void setTransaction(SrvTransactBuffer buf) {
        this.m_transact = buf;
    }

    private void mapWorkspacesAsShares() {
        String[] wks = ((SMBServer)this.getServer()).getWorkspaceList();
        DiskInfo di = new DiskInfo(null, null, 2560000L, 64, 512, 2304000L);
        int c = 0;
        for (int i = 0; i < wks.length; ++i) {
            VolumeInfo vi = new VolumeInfo(wks[i], 1111, new Date());
            SharedDevice dev = new SharedDevice(wks[i], 0);
            dev.setDiskInfo(di);
            dev.setVolumeInfo(vi);
            if (this.getServer().getShares().findShare(dev.getName()) != null) continue;
            this.addDynamicShare(dev);
            ++c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addVirtualCircuit(VirtualCircuit vc) {
        if (this.vcircuits == null) {
            this.vcircuits = new Hashtable(4);
        }
        int uid = 0;
        Hashtable<Integer, VirtualCircuit> hashtable = this.vcircuits;
        synchronized (hashtable) {
            if (this.vcircuits.size() == 16) {
                return -1;
            }
            uid = this.nextUID++ & 0xFFFF;
            Integer key = new Integer(uid);
            while (this.vcircuits.contains(key)) {
                uid = this.nextUID++ & 0xFFFF;
                key = new Integer(uid);
            }
            vc.setUID(uid);
            this.vcircuits.put(key, vc);
        }
        return uid;
    }

    public final VirtualCircuit findVirtualCircuit(int uid) {
        if (this.vcircuits == null) {
            return null;
        }
        return this.vcircuits.get(new Integer(uid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeVirtualCircuit(int uid) {
        if (this.vcircuits == null) {
            return;
        }
        Hashtable<Integer, VirtualCircuit> hashtable = this.vcircuits;
        synchronized (hashtable) {
            Integer key = new Integer(uid);
            VirtualCircuit vc = this.vcircuits.get(key);
            if (vc != null) {
                vc.closeCircuit(this);
                this.vcircuits.remove(key);
            }
        }
    }

    public final int getCircuitCount() {
        return this.vcircuits != null ? this.vcircuits.size() : 0;
    }
}

