/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.server;

import org.exoplatform.services.cifs.server.filesys.FileInfo;
import org.exoplatform.services.cifs.server.filesys.UnsupportedInfoLevelException;
import org.exoplatform.services.cifs.smb.NTTime;
import org.exoplatform.services.cifs.smb.SMBDate;
import org.exoplatform.services.cifs.util.DataBuffer;

public class QueryInfoPacker {
    public static final int packInfo(FileInfo info, DataBuffer buf, int infoLevel, boolean uni) throws UnsupportedInfoLevelException {
        int curPos = buf.getPosition();
        switch (infoLevel) {
            case 1: {
                QueryInfoPacker.packInfoStandard(info, buf, false, uni);
                break;
            }
            case 2: {
                QueryInfoPacker.packInfoStandard(info, buf, true, uni);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 6: {
                break;
            }
            case 257: 
            case 1004: {
                QueryInfoPacker.packBasicFileInfo(info, buf);
                break;
            }
            case 258: 
            case 1005: {
                QueryInfoPacker.packStandardFileInfo(info, buf);
                break;
            }
            case 259: 
            case 1007: {
                QueryInfoPacker.packEAFileInfo(info, buf);
                break;
            }
            case 260: 
            case 1009: {
                QueryInfoPacker.packNameFileInfo(info, buf, uni);
                break;
            }
            case 263: 
            case 1018: {
                QueryInfoPacker.packAllFileInfo(info, buf, uni);
                break;
            }
            case 264: 
            case 1021: {
                QueryInfoPacker.packAlternateNameFileInfo(info, buf);
                break;
            }
            case 265: 
            case 1022: {
                QueryInfoPacker.packStreamFileInfo(info, buf, uni);
                break;
            }
            case 267: 
            case 1028: {
                QueryInfoPacker.packCompressionFileInfo(info, buf);
                break;
            }
            case 1006: {
                QueryInfoPacker.packFileInternalInfo(info, buf);
                break;
            }
            case 1014: {
                QueryInfoPacker.packFilePositionInfo(info, buf);
                break;
            }
            case 1035: {
                QueryInfoPacker.packFileAttributeTagInfo(info, buf);
                break;
            }
            case 1034: {
                QueryInfoPacker.packFileNetworkOpenInfo(info, buf);
            }
        }
        return buf.getPosition() - curPos;
    }

    private static void packInfoStandard(FileInfo info, DataBuffer buf, boolean eaFlag, boolean uni) {
        SMBDate dateTime = new SMBDate(0);
        if (info.hasCreationDateTime()) {
            dateTime.setTime(info.getCreationDateTime());
            buf.putShort(dateTime.asSMBDate());
            buf.putShort(dateTime.asSMBTime());
        } else {
            buf.putZeros(4);
        }
        if (info.hasAccessDateTime()) {
            dateTime.setTime(info.getAccessDateTime());
            buf.putShort(dateTime.asSMBDate());
            buf.putShort(dateTime.asSMBTime());
        } else {
            buf.putZeros(4);
        }
        if (info.hasModifyDateTime()) {
            dateTime.setTime(info.getModifyDateTime());
            buf.putShort(dateTime.asSMBDate());
            buf.putShort(dateTime.asSMBTime());
        } else {
            buf.putZeros(4);
        }
        buf.putInt(info.getSizeInt());
        if (info.getAllocationSize() < info.getSize()) {
            buf.putInt(info.getSizeInt());
        } else {
            buf.putInt(info.getAllocationSizeInt());
        }
        buf.putShort(info.getFileAttributes());
        if (eaFlag) {
            buf.putZeros(4);
        }
    }

    private static void packBasicFileInfo(FileInfo info, DataBuffer buf) {
        if (info.hasCreationDateTime()) {
            buf.putLong(NTTime.toNTTime(info.getCreationDateTime()));
        } else {
            buf.putZeros(8);
        }
        if (info.hasAccessDateTime()) {
            buf.putLong(NTTime.toNTTime(info.getAccessDateTime()));
        } else {
            buf.putZeros(8);
        }
        if (info.hasModifyDateTime()) {
            long ntTime = NTTime.toNTTime(info.getModifyDateTime());
            buf.putLong(ntTime);
            buf.putLong(ntTime);
        } else {
            buf.putZeros(16);
        }
        buf.putInt(info.getFileAttributes());
        buf.putZeros(4);
    }

    private static void packStandardFileInfo(FileInfo info, DataBuffer buf) {
        if (info.getAllocationSize() < info.getSize()) {
            buf.putLong(info.getSize());
        } else {
            buf.putLong(info.getAllocationSize());
        }
        buf.putLong(info.getSize());
        buf.putInt(1);
        buf.putByte(0);
        buf.putByte(info.isDirectory() ? 1 : 0);
    }

    private static void packEAFileInfo(FileInfo info, DataBuffer buf) {
        buf.putInt(0);
    }

    private static void packNameFileInfo(FileInfo info, DataBuffer buf, boolean uni) {
        int nameLen = info.getFileName().length();
        if (uni) {
            nameLen *= 2;
        }
        buf.putInt(nameLen);
        buf.putString(info.getFileName(), uni, false);
    }

    private static void packAllFileInfo(FileInfo info, DataBuffer buf, boolean uni) {
        if (info.hasCreationDateTime()) {
            buf.putLong(NTTime.toNTTime(info.getCreationDateTime()));
        } else {
            buf.putZeros(8);
        }
        if (info.hasAccessDateTime()) {
            buf.putLong(NTTime.toNTTime(info.getAccessDateTime()));
        } else {
            buf.putZeros(8);
        }
        if (info.hasModifyDateTime()) {
            long ntTime = NTTime.toNTTime(info.getModifyDateTime());
            buf.putLong(ntTime);
            buf.putLong(ntTime);
        } else {
            buf.putZeros(16);
        }
        buf.putInt(info.getFileAttributes());
        buf.putInt(1);
        if (info.getAllocationSize() < info.getSize()) {
            buf.putLong(info.getSize());
        } else {
            buf.putLong(info.getAllocationSize());
        }
        buf.putLong(info.getSize());
        buf.putByte(0);
        buf.putByte(info.isDirectory() ? 1 : 0);
        buf.putShort(0);
        buf.putInt(0);
        buf.putInt(3);
        int nameLen = info.getFileName().length();
        if (uni) {
            nameLen *= 2;
        }
        buf.putInt(nameLen);
        buf.putString(info.getFileName(), uni, false);
    }

    private static void packAlternateNameFileInfo(FileInfo info, DataBuffer buf) {
    }

    private static void packStreamFileInfo(FileInfo info, DataBuffer buf, boolean uni) {
        String streamName = "::$DATA";
        buf.putInt(0);
        int nameLen = streamName.length();
        if (uni) {
            nameLen *= 2;
        }
        buf.putInt(nameLen);
        buf.putLong(info.getSize());
        if (info.getAllocationSize() < info.getSize()) {
            buf.putLong(info.getSize());
        } else {
            buf.putLong(info.getAllocationSize());
        }
        buf.putString(streamName, uni, false);
    }

    private static void packCompressionFileInfo(FileInfo info, DataBuffer buf) {
        buf.putLong(info.getSize());
        buf.putInt(0);
    }

    private static void packFileInternalInfo(FileInfo info, DataBuffer buf) {
        buf.putInt(1);
        buf.putInt(0);
    }

    private static void packFilePositionInfo(FileInfo info, DataBuffer buf) {
        buf.putInt(0);
        buf.putInt(0);
    }

    private static void packFileNetworkOpenInfo(FileInfo info, DataBuffer buf) {
        if (info.hasCreationDateTime()) {
            buf.putLong(NTTime.toNTTime(info.getCreationDateTime()));
        } else {
            buf.putZeros(8);
        }
        if (info.hasAccessDateTime()) {
            buf.putLong(NTTime.toNTTime(info.getAccessDateTime()));
        } else {
            buf.putZeros(8);
        }
        if (info.hasModifyDateTime()) {
            long ntTime = NTTime.toNTTime(info.getModifyDateTime());
            buf.putLong(ntTime);
            buf.putLong(ntTime);
        } else {
            buf.putZeros(16);
        }
        if (info.getAllocationSize() < info.getSize()) {
            buf.putLong(info.getSize());
        } else {
            buf.putLong(info.getAllocationSize());
        }
        buf.putLong(info.getSize());
        buf.putInt(info.getFileAttributes());
        buf.putInt(0);
    }

    private static void packFileAttributeTagInfo(FileInfo info, DataBuffer buf) {
        buf.putLong(0L);
        buf.putLong(0L);
    }
}

