/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.server;

import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cifs.ServerConfiguration;
import org.exoplatform.services.cifs.server.SrvSession;
import org.exoplatform.services.cifs.server.core.SharedDevice;
import org.exoplatform.services.cifs.server.core.SharedDeviceList;
import org.exoplatform.services.log.ExoLogger;

public abstract class NetworkServer {
    private static final Log logger = ExoLogger.getLogger((String)"org.exoplatform.services.cifs.server");
    private String m_version;
    private ServerConfiguration m_config;
    private boolean m_debug;
    private int m_debugFlags;
    private InetAddress[] m_ipAddr;
    private volatile boolean m_shutdown = false;
    private volatile boolean m_active = false;
    private Exception m_exception;
    private SharedDeviceList k_shares;

    public NetworkServer(ServerConfiguration config) {
        this.m_config = config;
        this.k_shares = new SharedDeviceList();
    }

    public final ServerConfiguration getConfiguration() {
        return this.m_config;
    }

    public final String getServerName() {
        return this.m_config.getServerName();
    }

    public final InetAddress[] getServerAddresses() {
        return this.m_ipAddr;
    }

    public SharedDeviceList getShares() {
        return this.k_shares;
    }

    public SharedDeviceList getAllShares(SrvSession sess) {
        SharedDeviceList shrList = new SharedDeviceList(this.getShares());
        if (sess != null && sess.hasDynamicShares()) {
            shrList.addShares(sess.getDynamicShares());
        }
        return shrList;
    }

    public final SharedDevice findShare(String name, int typ, SrvSession sess) throws Exception {
        SharedDevice share = null;
        if (sess.hasDynamicShares()) {
            share = sess.getDynamicShares().findShare(name, typ, true);
        }
        if (share == null && (share = this.getShares().findShare(name, typ, false)) == null) {
            share = this.getShares().findShare(name, typ, true);
        }
        return share;
    }

    public final boolean isActive() {
        return this.m_active;
    }

    public final String isVersion() {
        return this.m_version;
    }

    public final boolean hasException() {
        return this.m_exception != null;
    }

    public final Exception getException() {
        return this.m_exception;
    }

    public final void clearException() {
        this.m_exception = null;
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final boolean hasDebugFlag(int flg) {
        return (this.m_debugFlags & flg) != 0;
    }

    public final boolean hasShutdown() {
        return this.m_shutdown;
    }

    protected void setActive(boolean active) {
        this.m_active = active;
    }

    protected final void setException(Exception ex) {
        this.m_exception = ex;
    }

    protected final void setServerAddresses(InetAddress[] addrs) {
        this.m_ipAddr = addrs;
    }

    protected final void setVersion(String ver) {
        this.m_version = ver;
    }

    protected final void setDebug(boolean dbg) {
        this.m_debug = dbg;
    }

    protected final void setDebugFlags(int flags) {
        this.m_debugFlags = flags;
        this.setDebug(flags != 0);
    }

    protected final void setShutdown(boolean ena) {
        this.m_shutdown = ena;
    }

    public abstract void startServer();

    public abstract void shutdownServer(boolean var1);
}

