/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.server.core;

import org.exoplatform.services.cifs.server.core.ShareType;
import org.exoplatform.services.cifs.server.filesys.DiskInfo;
import org.exoplatform.services.cifs.server.filesys.VolumeInfo;

public class SharedDevice {
    public static final int Admin = 1;
    public static final int Hidden = 2;
    public static final int ReadOnly = 4;
    public static final int Temporary = 8;
    private String m_name;
    private int m_type;
    private String m_comments;
    private int m_attrib;
    private int m_maxUses = -1;
    private int m_curUses = 0;
    private DiskInfo m_diskinfo;
    private VolumeInfo m_volinfo;

    public SharedDevice() {
    }

    public SharedDevice(String name, int type) {
        this.m_name = name;
        this.m_type = type;
    }

    public void setName(String s) {
        this.m_name = s;
    }

    public void setType(int type) {
        this.m_type = type;
    }

    public void setComments(String com) {
        this.m_comments = com;
    }

    public void setAttributes(int i) {
        this.m_attrib = i;
    }

    public String getName() {
        return this.m_name;
    }

    public int getType() {
        return this.m_type;
    }

    public String getComments() {
        return this.m_comments;
    }

    public int getAttributes() {
        return this.m_attrib;
    }

    public final boolean isAdmin() {
        return (this.m_attrib & 1) != 0;
    }

    public final boolean isHidden() {
        return (this.m_attrib & 2) != 0;
    }

    public final boolean isReadOnly() {
        return (this.m_attrib & 4) != 0;
    }

    public final boolean isTemporary() {
        return (this.m_attrib & 8) != 0;
    }

    public synchronized void incrementConnectionCount() {
        ++this.m_curUses;
    }

    public synchronized void decrementConnectionCount() {
        --this.m_curUses;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getName());
        str.append(",");
        str.append(ShareType.TypeAsString(this.getType()));
        str.append(",");
        if (this.isAdmin()) {
            str.append(",Admin");
        }
        if (this.isHidden()) {
            str.append(",Hidden");
        }
        if (this.isReadOnly()) {
            str.append(",ReadOnly");
        }
        if (this.isTemporary()) {
            str.append(",Temp");
        }
        str.append("]");
        return str.toString();
    }

    public DiskInfo getDiskInformation() {
        return this.m_diskinfo;
    }

    public VolumeInfo getVolumeInformation() {
        return this.m_volinfo;
    }

    public void setDiskInfo(DiskInfo di) {
        this.m_diskinfo = di;
    }

    public void setVolumeInfo(VolumeInfo vi) {
        this.m_volinfo = vi;
    }
}

