/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.server.filesys;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Node;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;

public class BufferedInputStream
extends InputStream
implements Runnable {
    private static final Log logger = ExoLogger.getLogger((String)"org.exoplatform.services.cifs.smb.filesys.BufferedInputStream");
    private static final int BufferSize = 131072;
    private Node node;
    private boolean isStop = false;
    private byte[] buffer;
    private int currentBufPosition = -1;
    private int currentBufSize = 0;
    private boolean newBuffer = false;
    private boolean readyToAppload = true;

    public BufferedInputStream(Node n) {
        this.node = n;
        if (this.buffer == null) {
            this.buffer = new byte[131072];
        }
        this.newBuffer = false;
        this.isStop = false;
    }

    public BufferedInputStream() {
        if (this.buffer == null) {
            this.buffer = new byte[131072];
        }
        this.newBuffer = false;
        this.isStop = false;
    }

    public void setNodeRef(Node n) {
        this.node = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        logger.debug((Object)"read");
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            while (!this.newBuffer) {
                try {
                    this.buffer.wait(100L);
                    if (!this.isStop) continue;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return -1;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            byte ret = this.buffer[this.currentBufPosition];
            if (this.currentBufPosition == this.currentBufSize - 1) {
                this.readyToAppload = true;
                this.newBuffer = false;
            }
            ++this.currentBufPosition;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadBuffer(byte[] buf) {
        logger.debug((Object)("upload bufer: size " + buf.length));
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            while (!this.readyToAppload) {
                try {
                    this.buffer.wait(100L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.buffer == null) {
                this.buffer = new byte[131072];
            }
            System.arraycopy(buf, 0, this.buffer, 0, buf.length);
            this.currentBufSize = buf.length;
            this.currentBufPosition = 0;
            this.newBuffer = true;
            this.readyToAppload = false;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void run() {
        logger.debug((Object)"run");
        try {
            this.node.getNode("jcr:content").getProperty("jcr:data").setValue((InputStream)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        this.isStop = true;
    }
}

