/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cifs.smb.mailslot;

import org.exoplatform.services.cifs.util.DataPacker;

public class SMBMailslotPacket {
    public static final int SIGNATURE = 0;
    public static final int COMMAND = 4;
    public static final int ERRORCODE = 5;
    public static final int ERRORCLASS = 5;
    public static final int ERROR = 7;
    public static final int FLAGS = 9;
    public static final int FLAGS2 = 10;
    public static final int PIDHIGH = 12;
    public static final int SID = 18;
    public static final int SEQNO = 20;
    public static final int TID = 24;
    public static final int PID = 26;
    public static final int UID = 28;
    public static final int MID = 30;
    public static final int WORDCNT = 32;
    public static final int ANDXCOMMAND = 33;
    public static final int ANDXRESERVED = 34;
    public static final int PARAMWORDS = 33;
    public static final int TRANS_HEADERLEN = 66;
    public static final int MIN_RXLEN = 32;
    public static final int DEFAULT_BUFSIZE = 500;
    public static final int FLG_SUBDIALECT = 1;
    public static final int FLG_CASELESS = 8;
    public static final int FLG_CANONICAL = 16;
    public static final int FLG_OPLOCK = 32;
    public static final int FLG_NOTIFY = 64;
    public static final int FLG_RESPONSE = 128;
    public static final int FLG2_LONGFILENAMES = 1;
    public static final int FLG2_EXTENDEDATTRIB = 2;
    public static final int FLG2_READIFEXE = 8192;
    public static final int FLG2_LONGERRORCODE = 16384;
    public static final int FLG2_UNICODE = 32768;
    private byte[] m_smbbuf;
    private int m_offset;
    private static final int STD_PARAMS = 14;
    public static final int Transaction = 37;
    public static final int Transaction2 = 50;

    public SMBMailslotPacket() {
        this.m_smbbuf = new byte[500];
        this.m_offset = 0;
    }

    public SMBMailslotPacket(byte[] buf) {
        this.m_smbbuf = buf;
        this.m_offset = 0;
    }

    public SMBMailslotPacket(byte[] buf, int off) {
        this.m_smbbuf = buf;
        this.m_offset = off;
    }

    public final void resetPacket(byte[] buf, int offset) {
        this.m_smbbuf = buf;
        this.m_offset = offset;
    }

    public final int getAndXCommand() {
        return this.m_smbbuf[33 + this.m_offset] & 0xFF;
    }

    public final byte[] getBuffer() {
        return this.m_smbbuf;
    }

    public final int getBufferLength() {
        return this.m_smbbuf.length - this.m_offset;
    }

    public final int getByteCount() {
        int pos = 33 + 2 * this.getParameterCount();
        return DataPacker.getIntelShort(this.m_smbbuf, pos);
    }

    public final int getByteOffset() {
        int pCnt = this.getParameterCount();
        int pos = 32 + 2 * pCnt + 3 + this.m_offset;
        return pos;
    }

    public final int getCommand() {
        return this.m_smbbuf[4 + this.m_offset] & 0xFF;
    }

    public final boolean hasLongErrorCode() {
        return (this.getFlags2() & 0x4000) != 0;
    }

    public final int getErrorClass() {
        return this.m_smbbuf[5 + this.m_offset] & 0xFF;
    }

    public final int getErrorCode() {
        return this.m_smbbuf[7 + this.m_offset] & 0xFF;
    }

    public final int getFlags() {
        return this.m_smbbuf[9 + this.m_offset] & 0xFF;
    }

    public final int getFlags2() {
        return DataPacker.getIntelShort(this.m_smbbuf, 10 + this.m_offset);
    }

    public final int getLength() {
        return this.getByteOffset() + this.getByteCount() - this.m_offset;
    }

    public final int getLongErrorCode() {
        return DataPacker.getIntelInt(this.m_smbbuf, 5 + this.m_offset);
    }

    public final int getMultiplexId() {
        return DataPacker.getIntelShort(this.m_smbbuf, 30 + this.m_offset);
    }

    public final int getParameter(int idx) throws IndexOutOfBoundsException {
        if (idx > this.getParameterCount()) {
            throw new IndexOutOfBoundsException();
        }
        int pos = 32 + 2 * idx + 1 + this.m_offset;
        return DataPacker.getIntelShort(this.m_smbbuf, pos) & 0xFFFF;
    }

    public final int getParameterCount() {
        return this.m_smbbuf[32 + this.m_offset];
    }

    public final int getProcessId() {
        return DataPacker.getIntelShort(this.m_smbbuf, 26 + this.m_offset);
    }

    public final int getTreeId() {
        return DataPacker.getIntelShort(this.m_smbbuf, 24 + this.m_offset);
    }

    public final int getUserId() {
        return DataPacker.getIntelShort(this.m_smbbuf, 28 + this.m_offset);
    }

    public final int getDataBlockOffset() {
        int pos = this.getParameterBlockOffset() + this.getParameter(3) + this.m_offset;
        if ((pos & 1) != 0) {
            ++pos;
        }
        return pos;
    }

    public final int getDataBlockOffset(int prmLen) {
        int pos = this.getParameterBlockOffset() + prmLen;
        if ((pos & 1) != 0) {
            ++pos;
        }
        return pos;
    }

    public final int getParameterBlockOffset() {
        int pos = this.getByteOffset() + this.m_offset;
        if ((pos & 1) != 0) {
            ++pos;
        }
        return pos;
    }

    public final int getRxDataBlock() {
        return this.getParameter(12) + this.m_offset;
    }

    public final int getRxDataBlockLength() {
        return this.getParameter(11);
    }

    public final int getRxParameter(int prmIdx) {
        int pos = this.getRxParameterBlock();
        return DataPacker.getIntelShort(this.getBuffer(), pos += prmIdx * 2);
    }

    public final int getRxParameterBlock() {
        return this.getParameter(10) + this.m_offset;
    }

    public final int getRxParameterBlockLength() {
        return this.getParameter(9);
    }

    public final int getRxParameterCount() {
        return this.getParameterCount() - 14;
    }

    public final int getRxParameterInt(int prmIdx) {
        int pos = this.getRxParameterBlock();
        return DataPacker.getIntelInt(this.getBuffer(), pos += prmIdx * 2);
    }

    public final String getRxParameterString(int pos) {
        pos += this.getRxParameterBlock();
        byte[] buf = this.getBuffer();
        int len = buf[pos++] & 0xFF;
        return DataPacker.getString(buf, pos, len);
    }

    public final String getRxParameterString(int pos, int len) {
        byte[] buf = this.getBuffer();
        return DataPacker.getString(buf, pos += this.getRxParameterBlock(), len);
    }

    public final String getRxTransactName() {
        if (this.getCommand() == 50) {
            return "";
        }
        int pos = this.getByteOffset();
        return DataPacker.getString(this.getBuffer(), pos, this.getByteCount());
    }

    public final int getSetupParameter(int idx) throws ArrayIndexOutOfBoundsException {
        if (idx >= this.getRxParameterCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.getParameter(idx + 14);
    }

    public final int getMailslotOpcode() {
        try {
            return this.getSetupParameter(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return -1;
        }
    }

    public final int getMailslotPriority() {
        try {
            return this.getSetupParameter(1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return -1;
        }
    }

    public final int getMailslotClass() {
        try {
            return this.getSetupParameter(2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return -1;
        }
    }

    public final int getMailslotSubOpcode() {
        return this.m_smbbuf[this.getMailslotDataOffset()] & 0xFF;
    }

    public final int getMailslotDataOffset() {
        return this.getRxDataBlock();
    }

    public final void initializeMailslotSMB(String name, byte[] data, int dlen) {
        this.initializeBuffer();
        this.setFlags(0);
        this.setFlags2(0);
        this.setUserId(0);
        this.setMultiplexId(0);
        this.setTreeId(0);
        this.setProcessId(0);
        this.initializeTransact(name, 17, null, 0, data, dlen);
        this.setSetupParameter(0, 1);
        this.setSetupParameter(1, 1);
        this.setSetupParameter(2, 2);
    }

    protected final void initializeTransact(String name, int pcnt, byte[] paramblk, int plen, byte[] datablk, int dlen) {
        int idx;
        int pos;
        if (name == null) {
            this.setCommand(50);
        } else {
            this.setCommand(37);
        }
        this.setParameterCount(pcnt);
        this.setParameter(0, plen);
        this.setParameter(1, dlen);
        int i = 2;
        while (i < 9) {
            this.setParameter(i++, 0);
        }
        this.setParameter(6, 1000);
        this.setParameter(9, plen);
        this.setParameter(11, dlen);
        this.setParameter(13, pcnt - 14);
        int startPos = pos = this.getByteOffset();
        byte[] buf = this.getBuffer();
        if (name != null) {
            byte[] nam = name.getBytes();
            for (idx = 0; idx < nam.length; ++idx) {
                buf[pos++] = nam[idx];
            }
        }
        if (pos % 2 > 0) {
            ++pos;
        }
        if (paramblk != null) {
            this.setParameter(10, pos - this.m_offset);
            for (idx = 0; idx < plen; ++idx) {
                buf[pos++] = paramblk[idx];
            }
        } else {
            this.setParameter(10, 0);
        }
        if (pos % 2 > 0) {
            ++pos;
        }
        if (datablk != null) {
            this.setParameter(12, pos - this.m_offset);
            for (idx = 0; idx < dlen; ++idx) {
                buf[pos++] = datablk[idx];
            }
        } else {
            this.setParameter(12, 0);
        }
        this.setByteCount(pos - startPos);
    }

    public final void setAndXCommand(int cmd) {
        this.m_smbbuf[33 + this.m_offset] = (byte)cmd;
        this.m_smbbuf[34 + this.m_offset] = 0;
    }

    public final void setByteCount(int cnt) {
        int offset = this.getByteOffset() - 2;
        DataPacker.putIntelShort(cnt, this.m_smbbuf, offset);
    }

    public final void setBytes(byte[] byts) {
        int offset = this.getByteOffset() - 2;
        DataPacker.putIntelShort(byts.length, this.m_smbbuf, offset);
        offset += 2;
        int idx = 0;
        while (idx < byts.length) {
            this.m_smbbuf[offset + idx] = byts[idx++];
        }
    }

    public final void setCommand(int cmd) {
        this.m_smbbuf[4 + this.m_offset] = (byte)cmd;
    }

    public final void setErrorClass(int cl) {
        this.m_smbbuf[5 + this.m_offset] = (byte)(cl & 0xFF);
    }

    public final void setErrorCode(int sts) {
        this.m_smbbuf[7 + this.m_offset] = (byte)(sts & 0xFF);
    }

    public final void setFlags(int flg) {
        this.m_smbbuf[9 + this.m_offset] = (byte)flg;
    }

    public final void setFlags2(int flg) {
        DataPacker.putIntelShort(flg, this.m_smbbuf, 10 + this.m_offset);
    }

    public final void setMultiplexId(int mid) {
        DataPacker.putIntelShort(mid, this.m_smbbuf, 30 + this.m_offset);
    }

    public final void setParameter(int idx, int val) {
        int pos = 32 + 2 * idx + 1 + this.m_offset;
        DataPacker.putIntelShort(val, this.m_smbbuf, pos);
    }

    public final void setParameterCount(int cnt) {
        this.m_smbbuf[32 + this.m_offset] = (byte)cnt;
    }

    public final void setProcessId(int pid) {
        DataPacker.putIntelShort(pid, this.m_smbbuf, 26 + this.m_offset);
    }

    public final void setSeqNo(int seq) {
        DataPacker.putIntelShort(seq, this.m_smbbuf, 20 + this.m_offset);
    }

    public final void setSID(int sid) {
        DataPacker.putIntelShort(sid, this.m_smbbuf, 18 + this.m_offset);
    }

    public final void setTreeId(int tid) {
        DataPacker.putIntelShort(tid, this.m_smbbuf, 24 + this.m_offset);
    }

    public final void setUserId(int uid) {
        DataPacker.putIntelShort(uid, this.m_smbbuf, 28 + this.m_offset);
    }

    public final void setSetupParameter(int idx, int val) {
        this.setParameter(14 + idx, val);
    }

    private final void initializeBuffer() {
        this.m_smbbuf[0 + this.m_offset] = -1;
        this.m_smbbuf[1 + this.m_offset] = 83;
        this.m_smbbuf[2 + this.m_offset] = 77;
        this.m_smbbuf[3 + this.m_offset] = 66;
    }
}

