/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.recovery;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.replication.ChannelManager;
import org.exoplatform.services.jcr.ext.replication.priority.AbstractPriorityChecker;
import org.exoplatform.services.jcr.ext.replication.priority.DynamicPriorityChecker;
import org.exoplatform.services.jcr.ext.replication.priority.MemberListener;
import org.exoplatform.services.jcr.ext.replication.priority.StaticPriorityChecker;
import org.exoplatform.services.jcr.ext.replication.recovery.RecoveryManager;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.log.ExoLogger;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.MembershipListener;
import org.jgroups.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionFailDetector
implements ChannelListener,
MembershipListener,
MemberListener {
    private static Log log = ExoLogger.getLogger((String)"ext.ConnectionFailDetector");
    private static final int VIEW_CHECK = 200;
    private static final int INFORM_TIMOUT = 5000;
    private static final int BEFORE_CHECK = 10000;
    private static final int BEFORE_INIT = 60000;
    private static final int AFTER_INIT = 60000;
    private final ChannelManager channelManager;
    private String channelName;
    private ReconectTtread reconectTtread;
    private int lastViewSize = 2;
    private boolean allInited = false;
    private final WorkspaceDataContainer dataContainer;
    private final RecoveryManager recoveryManager;
    private List<Address> suspectMembers;
    private final int ownPriority;
    private final String ownName;
    private final List<String> otherPartisipants;
    private final AbstractPriorityChecker priorityChecker;
    private final ViewChecker viewChecker;

    public ConnectionFailDetector(ChannelManager channelManager, WorkspaceDataContainer dataContainer, RecoveryManager recoveryManager, int ownPriority, List<String> otherParticipants, String ownName, String priprityType) {
        this.channelManager = channelManager;
        this.channelManager.setChannelListener(this);
        this.dataContainer = dataContainer;
        this.recoveryManager = recoveryManager;
        this.ownPriority = ownPriority;
        this.ownName = ownName;
        this.otherPartisipants = new ArrayList<String>(otherParticipants);
        this.priorityChecker = priprityType.equals("static") ? new StaticPriorityChecker(channelManager, ownPriority, ownName, otherParticipants) : new DynamicPriorityChecker(channelManager, ownPriority, ownName, otherParticipants);
        this.priorityChecker.setMemberListener(this);
        this.viewChecker = new ViewChecker();
        this.viewChecker.start();
    }

    public void channelClosed(Channel channel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Channel closed : " + channel.getClusterName()));
        }
    }

    public void channelConnected(Channel channel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Channel connected : " + channel.getClusterName()));
        }
        this.channelName = channel.getClusterName();
    }

    public void channelDisconnected(Channel channel) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Channel disconnected : " + channel.getClusterName()));
        }
    }

    public void channelReconnected(Address address) {
    }

    public void channelShunned() {
    }

    public void block() {
    }

    public void suspect(Address adrress) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(" ------->>> MembershipListener.suspect : " + adrress.toString()));
        }
        if (this.suspectMembers == null) {
            this.suspectMembers = new ArrayList<Address>();
        }
        if (!this.suspectMembers.contains(adrress)) {
            this.suspectMembers.add(adrress);
        }
    }

    public void viewAccepted(View view) {
        this.viewChecker.putView(view);
    }

    private void viewAccepted(int viewSise) throws InterruptedException {
        this.priorityChecker.informAll();
        Thread.sleep(5000L);
        if (this.priorityChecker.isAllOnline()) {
            this.memberRejoin();
            return;
        }
        if (viewSise > 1) {
            this.allInited = true;
        }
        if (this.allInited) {
            this.lastViewSize = viewSise;
        }
        if (this.priorityChecker instanceof StaticPriorityChecker || this.otherPartisipants.size() == 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("lastViewSize == 1 && !priorityChecker.isMaxPriority() == " + (this.lastViewSize == 1 && !this.priorityChecker.isMaxPriority())));
                log.debug((Object)("lastViewSize > 1 && !priorityChecker.isMaxOnline() == " + (this.lastViewSize > 1 && !this.priorityChecker.isMaxOnline())));
            }
            if (this.lastViewSize == 1 && !this.priorityChecker.isMaxPriority()) {
                if (this.reconectTtread == null || this.reconectTtread.isStoped()) {
                    this.reconectTtread = new ReconectTtread(true);
                    this.reconectTtread.start();
                    this.memberSuspect();
                }
            } else if (this.reconectTtread != null && this.priorityChecker.isAllOnline()) {
                this.reconectTtread.setStop(false);
                this.reconectTtread = null;
            } else if (this.lastViewSize > 1 && !this.priorityChecker.isMaxOnline() && (this.reconectTtread == null || this.reconectTtread.isStoped())) {
                this.reconectTtread = new ReconectTtread(true);
                this.reconectTtread.start();
                this.memberSuspect();
            }
        } else if (this.priorityChecker instanceof DynamicPriorityChecker && this.otherPartisipants.size() > 1) {
            if (this.lastViewSize == 1 && !this.priorityChecker.isMaxPriority()) {
                if (this.reconectTtread == null || this.reconectTtread.isStoped()) {
                    this.reconectTtread = new ReconectTtread(true);
                    this.reconectTtread.start();
                    this.memberSuspect();
                }
            } else if (this.reconectTtread != null && this.priorityChecker.isAllOnline()) {
                this.reconectTtread.setStop(false);
                this.reconectTtread = null;
            }
        }
    }

    @Override
    public void memberRejoin() {
        log.info((Object)(this.dataContainer.getName() + " set not read-only"));
        this.dataContainer.setReadOnly(false);
        log.info((Object)(this.dataContainer.getName() + " recovery start ..."));
        this.recoveryManager.startRecovery();
    }

    public void memberSuspect() {
        log.info((Object)(this.dataContainer.getName() + " set read-only"));
        this.dataContainer.setReadOnly(true);
    }

    private class ReconectTtread
    extends Thread {
        private boolean isStop;

        public ReconectTtread(boolean isStop) {
            log.info((Object)("Thread '" + this.getName() + "' is init ..."));
            this.isStop = isStop;
        }

        public void run() {
            log.info((Object)("Thread '" + this.getName() + "' is run ..."));
            while (this.isStop) {
                try {
                    log.info((Object)("Connect to channel : " + ConnectionFailDetector.this.channelName));
                    Thread.sleep(10000L);
                    int curruntOnlin = 1;
                    if (ConnectionFailDetector.this.channelManager.getChannel() != null) {
                        while (ConnectionFailDetector.this.channelManager.getChannel().getView() == null) {
                            Thread.sleep(200L);
                        }
                        curruntOnlin = ConnectionFailDetector.this.channelManager.getChannel().getView().size();
                    }
                    if (curruntOnlin <= 1 || curruntOnlin > 1 && !ConnectionFailDetector.this.priorityChecker.isMaxOnline()) {
                        ConnectionFailDetector.this.channelManager.closeChannel();
                        Thread.sleep(60000L);
                        ConnectionFailDetector.this.channelManager.init();
                        ConnectionFailDetector.this.channelManager.connect();
                    } else {
                        this.isStop = false;
                    }
                    Thread.sleep(60000L);
                }
                catch (Exception e) {
                    log.info((Object)e, (Throwable)e);
                }
            }
        }

        public void setStop(boolean isStop) {
            this.isStop = isStop;
        }

        public boolean isStoped() {
            return !this.isStop;
        }
    }

    private class ViewChecker
    extends Thread {
        private final ConcurrentLinkedQueue<Integer> queue = new ConcurrentLinkedQueue();

        private ViewChecker() {
        }

        public void putView(View view) {
            log.info((Object)(" Memebers view :" + view.printDetails()));
            this.queue.offer(view.size());
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        Integer viewSize;
                        if ((viewSize = this.queue.poll()) != null) {
                            ConnectionFailDetector.this.viewAccepted(viewSize);
                        }
                        ViewChecker.sleep(400L);
                    }
                }
                catch (Throwable t) {
                    log.error((Object)"View check error :", t);
                    continue;
                }
                break;
            }
        }
    }
}

